/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.standalone;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MetricsProvider;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import io.smallrye.faulttolerance.core.metrics.MicrometerRecorder;
import io.smallrye.faulttolerance.core.timer.Timer;
import io.smallrye.faulttolerance.standalone.MetricsAdapter;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MicrometerAdapter
implements MetricsAdapter {
    private final MeterRegistry registry;

    public MicrometerAdapter(MeterRegistry registry) {
        this.registry = registry;
    }

    MetricsProvider createMetricsProvider(Timer timer) {
        this.registry.gauge("ft.timer.scheduled", Collections.singletonList(Tag.of((String)"id", (String)("" + timer.getId()))), (Object)timer, Timer::countScheduledTasks);
        return new MetricsProvider(){
            private final Map<Object, MetricsRecorder> cache = new ConcurrentHashMap<Object, MetricsRecorder>();

            public boolean isEnabled() {
                return true;
            }

            public MetricsRecorder create(MeteredOperation operation) {
                return this.cache.computeIfAbsent(operation.cacheKey(), ignored -> new MicrometerRecorder(MicrometerAdapter.this.registry, operation));
            }
        };
    }
}

