/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.standalone;

import io.smallrye.faulttolerance.apiimpl.BuilderLazyDependencies;
import io.smallrye.faulttolerance.core.event.loop.EventLoop;
import io.smallrye.faulttolerance.core.metrics.MetricsProvider;
import io.smallrye.faulttolerance.core.timer.ThreadTimer;
import io.smallrye.faulttolerance.core.timer.Timer;
import io.smallrye.faulttolerance.standalone.Configuration;
import io.smallrye.faulttolerance.standalone.MetricsAdapter;
import io.smallrye.faulttolerance.standalone.MicrometerAdapter;
import io.smallrye.faulttolerance.standalone.NoopAdapter;
import io.smallrye.faulttolerance.standalone.OpenTelemetryAdapter;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

final class LazyDependencies
implements BuilderLazyDependencies {
    private final boolean enabled;
    private final ExecutorService executor;
    private final MetricsAdapter metricsAdapter;
    private final EventLoop eventLoop;
    private final Timer timer;
    private volatile MetricsProvider metricsProvider;

    LazyDependencies(Configuration config) {
        this.enabled = config.enabled();
        this.executor = config.executor();
        this.metricsAdapter = config.metricsAdapter();
        this.eventLoop = EventLoop.get();
        this.timer = new ThreadTimer((Executor)this.executor);
    }

    public boolean ftEnabled() {
        return this.enabled;
    }

    public ExecutorService asyncExecutor() {
        return this.executor;
    }

    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    public Timer timer() {
        return this.timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricsProvider metricsProvider() {
        MetricsProvider metricsProvider = this.metricsProvider;
        if (metricsProvider == null) {
            LazyDependencies lazyDependencies = this;
            synchronized (lazyDependencies) {
                metricsProvider = this.metricsProvider;
                if (metricsProvider == null) {
                    if (this.metricsAdapter instanceof NoopAdapter) {
                        metricsProvider = ((NoopAdapter)this.metricsAdapter).createMetricsProvider();
                    } else if (this.metricsAdapter instanceof MicrometerAdapter) {
                        metricsProvider = ((MicrometerAdapter)this.metricsAdapter).createMetricsProvider(this.timer);
                    } else if (this.metricsAdapter instanceof OpenTelemetryAdapter) {
                        metricsProvider = ((OpenTelemetryAdapter)this.metricsAdapter).createMetricsProvider(this.timer);
                    } else {
                        throw new IllegalStateException("Invalid metrics adapter: " + String.valueOf(this.metricsAdapter));
                    }
                    this.metricsProvider = metricsProvider;
                }
            }
        }
        return metricsProvider;
    }

    void shutdown() throws InterruptedException {
        this.timer.shutdown();
    }
}

