/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.internal;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class SecurityActions {
    private SecurityActions() {
    }

    static void setAccessible(AccessibleObject accessibleObject) {
        if (System.getSecurityManager() == null) {
            accessibleObject.setAccessible(true);
        }
        AccessController.doPrivileged(() -> {
            accessibleObject.setAccessible(true);
            return accessibleObject;
        });
    }

    static Method findFallbackMethod(Class<?> beanClass, Class<?> declaringClass, String name, Type[] parameterTypes, Type returnType) throws PrivilegedActionException {
        Set result = System.getSecurityManager() == null ? SecurityActions.doFindFallbackMethod(beanClass, declaringClass, name, parameterTypes, returnType, false) : AccessController.doPrivileged(() -> SecurityActions.doFindFallbackMethod(beanClass, declaringClass, name, parameterTypes, returnType, false));
        return result.isEmpty() ? null : (Method)result.iterator().next();
    }

    static Set<Method> findFallbackMethodsWithExceptionParammeter(Class<?> beanClass, Class<?> declaringClass, String name, Type[] parameterTypes, Type returnType) throws PrivilegedActionException {
        if (System.getSecurityManager() == null) {
            return SecurityActions.doFindFallbackMethod(beanClass, declaringClass, name, parameterTypes, returnType, true);
        }
        return AccessController.doPrivileged(() -> SecurityActions.doFindFallbackMethod(beanClass, declaringClass, name, parameterTypes, returnType, true));
    }

    private static Set<Method> doFindFallbackMethod(Class<?> beanClass, Class<?> declaringClass, String name, Type[] expectedParameterTypes, Type expectedReturnType, boolean expectedExceptionParameter) {
        HashSet<Method> result = new HashSet<Method>();
        TypeMapping expectedMapping = TypeMapping.createFor(beanClass, declaringClass);
        TypeMapping actualMapping = new TypeMapping();
        Set<String> possibleFallbackMethodNames = SecurityActions.findPossibleFallbackMethodNames(declaringClass);
        Class<?> clazz = beanClass;
        while (true) {
            Set<Method> methods = SecurityActions.getMethodsFromClass(declaringClass, clazz, name, expectedParameterTypes, expectedReturnType, expectedExceptionParameter, actualMapping, expectedMapping);
            for (Method method : methods) {
                if (!possibleFallbackMethodNames.contains(method.getName())) continue;
                result.add(method);
                if (expectedExceptionParameter) continue;
                return result;
            }
            if (clazz.getSuperclass() == null) break;
            actualMapping = actualMapping.getSuperclassMapping(clazz);
            clazz = clazz.getSuperclass();
        }
        for (Class<?> iface : beanClass.getInterfaces()) {
            Set<Method> methods = SecurityActions.getMethodsFromClass(declaringClass, iface, name, expectedParameterTypes, expectedReturnType, expectedExceptionParameter, actualMapping, expectedMapping);
            for (Method method : methods) {
                if (!possibleFallbackMethodNames.contains(method.getName())) continue;
                result.add(method);
                if (expectedExceptionParameter) continue;
                return result;
            }
        }
        return result;
    }

    private static Set<String> findPossibleFallbackMethodNames(Class<?> declaringClass) {
        HashSet<String> result = new HashSet<String>();
        for (Class<?> clazz = declaringClass; clazz != null; clazz = clazz.getSuperclass()) {
            for (GenericDeclaration genericDeclaration : clazz.getDeclaredMethods()) {
                result.add(((Method)genericDeclaration).getName());
            }
        }
        for (GenericDeclaration genericDeclaration : declaringClass.getInterfaces()) {
            for (Method m : ((Class)genericDeclaration).getMethods()) {
                result.add(m.getName());
            }
        }
        return result;
    }

    private static Set<Method> getMethodsFromClass(Class<?> guardedMethodDeclaringClass, Class<?> classToSearch, String name, Type[] parameterTypes, Type returnType, boolean exceptionParameter, TypeMapping actualMapping, TypeMapping expectedMapping) {
        HashSet<Method> set = new HashSet<Method>();
        for (Method method : classToSearch.getDeclaredMethods()) {
            if (!SecurityActions.isAccessibleFrom(method, guardedMethodDeclaringClass) || !method.getName().equals(name) || !SecurityActions.signaturesMatch(method, parameterTypes, returnType, exceptionParameter, actualMapping, expectedMapping)) continue;
            set.add(method);
        }
        return set;
    }

    private static boolean isAccessibleFrom(Method method, Class<?> guardedMethodDeclaringClass) {
        if (Modifier.isPublic(method.getModifiers()) || Modifier.isProtected(method.getModifiers())) {
            return true;
        }
        if (Modifier.isPrivate(method.getModifiers())) {
            return method.getDeclaringClass() == guardedMethodDeclaringClass;
        }
        return method.getDeclaringClass().getPackage() == guardedMethodDeclaringClass.getPackage();
    }

    private static boolean signaturesMatch(Method method, Type[] expectedParameterTypes, Type expectedReturnType, boolean expectedExceptionParameter, TypeMapping actualMapping, TypeMapping expectedMapping) {
        Type[] methodParams;
        int expectedParameters = expectedParameterTypes.length;
        if (expectedExceptionParameter) {
            ++expectedParameters;
        }
        if (expectedParameters != (methodParams = method.getGenericParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < expectedParameterTypes.length; ++i) {
            if (SecurityActions.typeMatches(methodParams[i], expectedParameterTypes[i], actualMapping, expectedMapping)) continue;
            return false;
        }
        if (expectedExceptionParameter) {
            boolean isThrowable;
            Type lastParameter = methodParams[methodParams.length - 1];
            boolean bl = isThrowable = lastParameter instanceof Class && Throwable.class.isAssignableFrom((Class)lastParameter);
            if (!isThrowable) {
                return false;
            }
        }
        return SecurityActions.typeMatches(method.getGenericReturnType(), expectedReturnType, actualMapping, expectedMapping);
    }

    private static boolean typeMatches(Type actualType, Type expectedType, TypeMapping actualMapping, TypeMapping expectedMapping) {
        actualType = actualMapping.map(actualType);
        expectedType = expectedMapping.map(expectedType);
        if (actualType instanceof Class) {
            return expectedType == actualType;
        }
        if (SecurityActions.isArray(actualType) && SecurityActions.isArray(expectedType)) {
            return SecurityActions.typeMatches(SecurityActions.getArrayComponentType(actualType), SecurityActions.getArrayComponentType(expectedType), actualMapping, expectedMapping);
        }
        if (actualType instanceof ParameterizedType && expectedType instanceof ParameterizedType) {
            return SecurityActions.parameterizedTypeMatches((ParameterizedType)actualType, (ParameterizedType)expectedType, actualMapping, expectedMapping);
        }
        if (actualType instanceof WildcardType && expectedType instanceof WildcardType) {
            return SecurityActions.wildcardTypeMatches((WildcardType)actualType, (WildcardType)expectedType, actualMapping, expectedMapping);
        }
        return false;
    }

    private static boolean wildcardTypeMatches(WildcardType actualType, WildcardType expectedType, TypeMapping actualMapping, TypeMapping expectedMapping) {
        boolean lowerBoundsMatch = SecurityActions.typeArrayMatches(actualType.getLowerBounds(), expectedType.getLowerBounds(), actualMapping, expectedMapping);
        boolean upperBoundsMatch = SecurityActions.typeArrayMatches(actualType.getUpperBounds(), expectedType.getUpperBounds(), actualMapping, expectedMapping);
        return lowerBoundsMatch && upperBoundsMatch;
    }

    private static boolean parameterizedTypeMatches(ParameterizedType actualType, ParameterizedType expectedType, TypeMapping actualMapping, TypeMapping expectedMapping) {
        return SecurityActions.typeArrayMatches(actualType.getActualTypeArguments(), expectedType.getActualTypeArguments(), actualMapping, expectedMapping);
    }

    private static boolean typeArrayMatches(Type[] actualTypes, Type[] expectedTypes, TypeMapping actualMapping, TypeMapping expectedMapping) {
        if (actualTypes.length != expectedTypes.length) {
            return false;
        }
        for (int i = 0; i < actualTypes.length; ++i) {
            if (SecurityActions.typeMatches(actualTypes[i], expectedTypes[i], actualMapping, expectedMapping)) continue;
            return false;
        }
        return true;
    }

    private static Type getArrayComponentType(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getComponentType();
        }
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        throw new IllegalArgumentException("Not an array: " + type);
    }

    private static boolean isArray(Type parameterType) {
        if (parameterType instanceof Class) {
            return ((Class)parameterType).isArray();
        }
        return parameterType instanceof GenericArrayType;
    }

    private static class TypeMapping {
        private final Map<Type, Type> map;

        private TypeMapping() {
            this.map = Collections.emptyMap();
        }

        private TypeMapping(Map<Type, Type> map) {
            this.map = map;
        }

        private static TypeMapping createFor(Class<?> beanClass, Class<?> declaringClass) {
            TypeMapping result = new TypeMapping();
            if (beanClass == declaringClass) {
                return result;
            }
            for (Class<?> current = beanClass; current != declaringClass && current != null && current.getSuperclass() != null; current = current.getSuperclass()) {
                result = result.getSuperclassMapping(current);
            }
            return result;
        }

        private Type map(Type type) {
            Type result = this.map.get(type);
            return result != null ? result : type;
        }

        private TypeMapping getSuperclassMapping(Class<?> current) {
            return new TypeMapping(TypeMapping.mappingForSuperclass(current, this.map));
        }

        private static Map<Type, Type> mappingForSuperclass(Class<?> clazz, Map<Type, Type> previousMapping) {
            Class<?> superclass = clazz.getSuperclass();
            TypeVariable<Class<?>>[] typeParameters = superclass.getTypeParameters();
            Type genericSuperclass = clazz.getGenericSuperclass();
            Type[] typeArguments = genericSuperclass instanceof ParameterizedType ? ((ParameterizedType)genericSuperclass).getActualTypeArguments() : new Type[]{};
            HashMap<Type, Type> result = new HashMap<Type, Type>();
            for (int i = 0; i < typeArguments.length; ++i) {
                Type typeArgument = typeArguments[i];
                if (typeArgument instanceof Class) {
                    result.put(typeParameters[i], typeArgument);
                    continue;
                }
                Type type = previousMapping.get(typeArgument);
                result.put(typeParameters[i], type != null ? type : typeArgument);
            }
            return result;
        }
    }
}

