/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.model;

import io.smallrye.graphql.client.model.Annotations;
import io.smallrye.graphql.client.model.ClientModel;
import io.smallrye.graphql.client.model.ClientModels;
import io.smallrye.graphql.client.model.QueryBuilder;
import io.smallrye.graphql.client.model.ScanningContext;
import io.smallrye.graphql.client.model.helper.OperationModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class ClientModelBuilder {
    private static final Logger LOG = Logger.getLogger((String)ClientModelBuilder.class.getName());

    public static ClientModels build(IndexView index) {
        ScanningContext.register(index);
        return new ClientModelBuilder().generateClientModels();
    }

    private ClientModelBuilder() {
    }

    private ClientModels generateClientModels() {
        ClientModels clientModels = new ClientModels();
        HashMap clientModelMap = new HashMap();
        Collection graphQLApiAnnotations = ScanningContext.getIndex().getAnnotations(Annotations.GRAPHQL_CLIENT_API);
        this.validateNamespaceAnnotations(graphQLApiAnnotations);
        graphQLApiAnnotations.forEach(graphQLApiAnnotation -> {
            ClientModel operationMap = new ClientModel();
            ClassInfo apiClass = graphQLApiAnnotation.target().asClass();
            List<MethodInfo> methods = this.getAllMethodsIncludingFromSuperClasses(apiClass);
            methods.forEach(method -> {
                String query = new QueryBuilder((MethodInfo)method).build();
                LOG.debugf("[%s] \u2013 Query created: %s", (Object)apiClass.name().toString(), (Object)query);
                operationMap.getOperationMap().putIfAbsent(OperationModel.of(method).getMethodKey(), query);
            });
            clientModelMap.put(graphQLApiAnnotation.value("configKey") == null ? apiClass.name().toString() : graphQLApiAnnotation.value("configKey").asString(), operationMap);
        });
        clientModels.setClientModelMap(clientModelMap);
        return clientModels;
    }

    private void validateNamespaceAnnotations(Collection<AnnotationInstance> graphQLApiAnnotations) {
        List errorInterfaces = graphQLApiAnnotations.stream().map(annotation -> annotation.target().asClass()).filter(classInfo -> classInfo.hasDeclaredAnnotation(Annotations.NAMESPACE) && classInfo.hasDeclaredAnnotation(Annotations.NAME)).map(classInfo -> classInfo.name().toString()).collect(Collectors.toList());
        if (!errorInterfaces.isEmpty()) {
            throw new RuntimeException("You can only use one of the annotations - @Name or @Namespace over the GraphQLClientApi interface. Please, fix the following interfaces: " + String.join((CharSequence)", ", errorInterfaces));
        }
    }

    private List<MethodInfo> getAllMethodsIncludingFromSuperClasses(ClassInfo classInfo) {
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        classInfo.methods().stream().filter(methodInfo -> !methodInfo.isSynthetic()).forEach(methods::add);
        List interfaceNames = classInfo.interfaceNames();
        interfaceNames.forEach(interfaceName -> {
            List<MethodInfo> parentMethods = this.getAllMethodsIncludingFromSuperClasses(ScanningContext.getIndex().getClassByName(interfaceName));
            methods.addAll(parentMethods);
        });
        return methods;
    }
}

