/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.model.helper;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class DirectiveInstance {
    private final String name;
    private final Map<String, Object> values;

    DirectiveInstance(AnnotationInstance annotationInstance) {
        this.name = this.toDirectiveName(annotationInstance.name().withoutPackagePrefix());
        this.values = annotationInstance.values().stream().collect(Collectors.toUnmodifiableMap(AnnotationValue::name, AnnotationValue::value));
    }

    public static DirectiveInstance of(AnnotationInstance annotationInstance) {
        return new DirectiveInstance(annotationInstance);
    }

    public String buildDirective() {
        StringBuilder builder = new StringBuilder();
        builder.append(" @").append(this.name);
        if (!this.values.isEmpty()) {
            builder.append("(").append(this.buildDirectiveArgs()).append(")");
        }
        return builder.toString();
    }

    private String buildDirectiveArgs() {
        return this.values.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + this.directiveArgumentValueToString(entry.getValue())).collect(Collectors.joining(", "));
    }

    private String toDirectiveName(String name) {
        if (Character.isUpperCase(((String)name).charAt(0))) {
            name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
        }
        return name;
    }

    private String directiveArgumentValueToString(Object dirArgVal) {
        if (dirArgVal.getClass().isArray()) {
            return Arrays.stream((Object[])dirArgVal).map(this::directiveArgumentValueToString).collect(Collectors.joining(", ", "[", "]"));
        }
        return (dirArgVal instanceof String ? "\"" + String.valueOf(dirArgVal) + "\"" : dirArgVal).toString();
    }

    public String toString() {
        return "DirectiveInstance{type=" + this.name + ", values=" + String.valueOf(this.values) + "}";
    }
}

