/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.model.helper;

import io.smallrye.graphql.client.model.Annotations;
import io.smallrye.graphql.client.model.Scalars;
import io.smallrye.graphql.client.model.ScanningContext;
import io.smallrye.graphql.client.model.helper.DirectiveHelper;
import io.smallrye.graphql.client.model.helper.DirectiveInstance;
import io.smallrye.graphql.client.model.helper.NamedElement;
import io.smallrye.graphql.client.model.helper.TypeModel;
import io.smallrye.graphql.client.typesafe.api.Header;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.MethodParameterInfo;

public class ParameterModel
implements NamedElement {
    private MethodParameterInfo parameter;
    private TypeModel type;
    private List<DirectiveInstance> directives;
    private static final String PARAMETER_NAME_PLACEHOLDER = "arg";

    ParameterModel(MethodParameterInfo parameter) {
        this.parameter = parameter;
        this.type = TypeModel.of(parameter.type());
        this.directives = DirectiveHelper.resolveDirectives(parameter.annotations().stream(), this.getDirectiveLocation()).map(DirectiveInstance::of).collect(Collectors.toList());
    }

    public static ParameterModel of(MethodParameterInfo parameter) {
        return new ParameterModel(parameter);
    }

    public boolean isValueParameter() {
        return this.isRootParameter() || this.isNestedParameter();
    }

    public boolean isRootParameter() {
        return !this.isHeaderParameter() && !this.isNestedParameter();
    }

    public boolean isNestedParameter() {
        return this.parameter.hasAnnotation(Annotations.NESTED_PARAMETER);
    }

    public Stream<String> getNestedParameterNames() {
        return Stream.of(this.parameter.annotation(Annotations.NESTED_PARAMETER).value().asStringArray());
    }

    @Override
    public String getName() {
        if (this.parameter.hasAnnotation(Annotations.NAME)) {
            return this.parameter.annotation(Annotations.NAME).value().asString();
        }
        if (this.parameter.name() == null) {
            throw new RuntimeException("Missing name information for " + String.valueOf(this) + ".\nYou can either annotate all parameters with @Name, or compile your source code with the -parameters options, so the parameter names are compiled into the class file and available at runtime.");
        }
        return this.getRawName();
    }

    @Override
    public String getRawName() {
        String rawName = this.parameter.name();
        return rawName != null ? rawName : PARAMETER_NAME_PLACEHOLDER + this.parameter.position();
    }

    @Override
    public String getDirectiveLocation() {
        return "VARIABLE_DEFINITION";
    }

    public String graphQlInputTypeName() {
        return this.graphQlInputTypeNameRecursion(this.type);
    }

    @Override
    public boolean hasDirectives() {
        return !this.directives.isEmpty();
    }

    @Override
    public List<DirectiveInstance> getDirectives() {
        return this.directives;
    }

    private String baseTypeName(TypeModel type) {
        if (type.isSimpleClassType() && !type.isScalar()) {
            String value;
            if (type.hasClassAnnotation(Annotations.INPUT) && !(value = type.getClassAnnotation(Annotations.INPUT).orElseThrow().valueWithDefault(ScanningContext.getIndex()).asString()).isEmpty()) {
                return value;
            }
            if (type.hasClassAnnotation(Annotations.NAME)) {
                return type.getClassAnnotation(Annotations.NAME).orElseThrow().value().asString();
            }
        }
        if (Scalars.isScalar(type.getName())) {
            return Scalars.getScalar(type.getName());
        }
        return type.getSimpleName() + (type.isEnum() ? "" : "Input");
    }

    private String optionalExclamationMark(TypeModel type) {
        return this.parameter.hasAnnotation(Annotations.KOTLIN_NOT_NULL) || type.isNonNull() ? "!" : "";
    }

    private boolean isHeaderParameter() {
        return this.parameter.hasAnnotation(Header.class);
    }

    private String graphQlInputTypeNameRecursion(TypeModel type) {
        if (type.isCollectionOrArray()) {
            TypeModel elementType = type.isArray() ? type.getArrayElementType() : type.getCollectionElementType();
            return "[" + this.graphQlInputTypeNameRecursion(elementType) + "]" + this.optionalExclamationMark(type);
        }
        if (type.isMap()) {
            TypeModel keyType = type.getMapKeyType();
            TypeModel valueType = type.getMapValueType();
            String key = this.baseTypeName(keyType) + this.optionalExclamationMark(keyType);
            String value = this.baseTypeName(valueType) + this.optionalExclamationMark(valueType);
            return "[Entry_" + key + "_" + value + "Input]" + this.optionalExclamationMark(type);
        }
        if (this.parameter.hasAnnotation(Annotations.ID)) {
            return "ID" + this.optionalExclamationMark(type);
        }
        if (type.isSimpleClassType() && !type.isScalar()) {
            String value;
            if (type.hasClassAnnotation(Annotations.INPUT) && !(value = type.getClassAnnotation(Annotations.INPUT).orElseThrow().valueWithDefault(ScanningContext.getIndex()).asString()).isEmpty()) {
                return value + this.optionalExclamationMark(type);
            }
            if (type.hasClassAnnotation(Annotations.NAME)) {
                return type.getClassAnnotation(Annotations.NAME).orElseThrow().value().asString() + this.optionalExclamationMark(type);
            }
        }
        if (Scalars.isScalar(type.getName())) {
            return Scalars.getScalar(type.getName()) + this.optionalExclamationMark(type);
        }
        return type.getSimpleName() + (type.isEnum() ? "" : "Input") + this.optionalExclamationMark(type);
    }
}

