/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.event;

import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.bootstrap.Config;
import io.smallrye.graphql.execution.event.InvokeInfo;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.spi.EventingService;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.jboss.logging.Logger;

public class EventEmitter {
    private static final Logger LOG = Logger.getLogger(EventEmitter.class);
    private static final Map<Config, EventEmitter> INSTANCES = new IdentityHashMap<Config, EventEmitter>();
    private final List<EventingService> enabledServices = new ArrayList<EventingService>();

    public static EventEmitter getInstance(Config config) {
        return INSTANCES.computeIfAbsent(config, k -> new EventEmitter(config));
    }

    private EventEmitter(Config config) {
        if (config != null) {
            ServiceLoader<EventingService> eventingServices = ServiceLoader.load(EventingService.class);
            Iterator<EventingService> it = eventingServices.iterator();
            EventingService eventingService = null;
            while (it.hasNext()) {
                try {
                    eventingService = it.next();
                    String configKey = eventingService.getConfigKey();
                    boolean enabled = config.getConfigValue(configKey, Boolean.TYPE, false);
                    if (!enabled) continue;
                    this.enabledServices.add(eventingService);
                }
                catch (Throwable t) {
                    Throwable cause = t.getCause();
                    LOG.warn((Object)("Failed to register " + t.getMessage() + (cause != null ? "\n\tCaused by: " + cause.toString() : "")));
                }
            }
        }
    }

    public void fireBeforeExecute(Context context) {
        for (EventingService extensionService : this.enabledServices) {
            extensionService.beforeExecute(context);
        }
    }

    public void fireOnExecuteError(String executionId, Throwable t) {
        for (EventingService extensionService : this.enabledServices) {
            extensionService.errorExecute(executionId, t);
        }
    }

    public void fireAfterExecute(Context context) {
        for (EventingService extensionService : this.enabledServices) {
            extensionService.afterExecute(context);
        }
    }

    public void fireBeforeDataFetch(Context context) {
        for (EventingService extensionService : this.enabledServices) {
            extensionService.beforeDataFetch(context);
        }
    }

    public void fireBeforeMethodInvoke(InvokeInfo invokeInfo) throws Exception {
        for (EventingService extensionService : this.enabledServices) {
            extensionService.beforeInvoke(invokeInfo);
        }
    }

    public void fireOnDataFetchError(String executionId, Throwable t) {
        for (EventingService extensionService : this.enabledServices) {
            extensionService.errorDataFetch(executionId, t);
        }
    }

    public void fireAfterDataFetch(Context context) {
        for (EventingService extensionService : this.enabledServices) {
            extensionService.afterDataFetch(context);
        }
    }

    public GraphQL.Builder fireBeforeGraphQLBuild(GraphQL.Builder builder) {
        for (EventingService extensionService : this.enabledServices) {
            builder = extensionService.beforeGraphQLBuild(builder);
        }
        return builder;
    }

    public GraphQLSchema.Builder fireBeforeSchemaBuild(GraphQLSchema.Builder builder) {
        for (EventingService extensionService : this.enabledServices) {
            builder = extensionService.beforeSchemaBuild(builder);
        }
        return builder;
    }

    public Operation fireCreateOperation(Operation operation) {
        for (EventingService extensionService : this.enabledServices) {
            operation = extensionService.createOperation(operation);
        }
        return operation;
    }
}

