/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.transformation;

import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Transformation;
import io.smallrye.graphql.transformation.NumberTransformer;
import io.smallrye.graphql.transformation.Transformer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class FormattedNumberTransformer
implements Transformer<Number, String> {
    private final DecimalFormat numberFormat;
    private final NumberTransformer numberTransformer;

    protected FormattedNumberTransformer(Field field) {
        this.numberTransformer = new NumberTransformer(field);
        this.numberFormat = this.getNumberFormat(field.getTransformation());
        this.numberFormat.setParseBigDecimal(true);
    }

    private DecimalFormat getNumberFormat(Transformation formatter) {
        String format = formatter.getFormat();
        String locale = formatter.getLocale();
        if (format == null && locale == null) {
            return new DecimalFormat();
        }
        if (format == null) {
            return (DecimalFormat)NumberFormat.getInstance(Locale.forLanguageTag(locale));
        }
        if (locale == null) {
            return new DecimalFormat(format);
        }
        return new DecimalFormat(format, DecimalFormatSymbols.getInstance(Locale.forLanguageTag(locale)));
    }

    @Override
    public Number in(String o) throws ParseException {
        Number parsed = this.numberFormat.parse(o);
        return this.numberTransformer.in(parsed);
    }

    @Override
    public String out(Number object) {
        return this.numberFormat.format(object);
    }
}

