/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.error;

import io.smallrye.graphql.api.ErrorExtensionProvider;
import io.smallrye.graphql.execution.error.ErrorInfoMap;
import io.smallrye.graphql.schema.model.ErrorInfo;
import java.util.Locale;
import javax.json.Json;
import javax.json.JsonValue;

public class ErrorCodeExtensionProvider
implements ErrorExtensionProvider {
    public String getKey() {
        return "code";
    }

    public JsonValue mapValueFrom(Throwable exception) {
        return Json.createValue((String)this.errorCode(exception));
    }

    private String errorCode(Throwable exception) {
        ErrorInfo errorInfo = ErrorInfoMap.getErrorInfo(exception.getClass().getName());
        if (errorInfo == null) {
            return ErrorCodeExtensionProvider.camelToKebab(exception.getClass().getSimpleName().replaceAll("Exception$", ""));
        }
        return errorInfo.getErrorCode();
    }

    private static String camelToKebab(String input) {
        return String.join((CharSequence)"-", input.split("(?=\\p{javaUpperCase})")).toLowerCase(Locale.ROOT);
    }
}

