/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.transformation;

import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Transformation;
import io.smallrye.graphql.transformation.Transformer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DateTransformer
implements Transformer<Temporal, String> {
    private static final Map<String, DateTimeFormatter> DEFAULT_FORMATTER = DateTransformer.createDefaultFormatter();
    private static final Map<String, TemporalQuery<?>> TEMPORAL_QUERYS = DateTransformer.createTemporalQuerys();
    private final DateTimeFormatter dateTimeFormatter;
    private final String targetClassName;

    public DateTransformer(Field field, String targetClassName) {
        this.dateTimeFormatter = DateTransformer.getDateFormat(field.getTransformation(), targetClassName);
        this.targetClassName = targetClassName;
    }

    public DateTransformer(Field field) {
        this(field, field.getReference().getClassName());
    }

    @Override
    public Temporal in(String o) {
        TemporalQuery<?> temporalAccessor = TEMPORAL_QUERYS.get(this.targetClassName);
        if (temporalAccessor == null || this.dateTimeFormatter == null) {
            throw SmallRyeGraphQLServerMessages.msg.notValidDateOrTimeType(this.targetClassName);
        }
        return (Temporal)this.dateTimeFormatter.parse((CharSequence)o, temporalAccessor);
    }

    @Override
    public String out(Temporal temporal) {
        if (temporal instanceof Instant) {
            temporal = ((Instant)temporal).atOffset(ZoneOffset.UTC);
        }
        return this.dateTimeFormatter.format(temporal);
    }

    private static Map<String, TemporalQuery<?>> createTemporalQuerys() {
        HashMap defaultFormatter = new HashMap();
        defaultFormatter.put(LocalDate.class.getName(), LocalDate::from);
        defaultFormatter.put(LocalTime.class.getName(), LocalTime::from);
        defaultFormatter.put(LocalDateTime.class.getName(), LocalDateTime::from);
        defaultFormatter.put(OffsetTime.class.getName(), OffsetTime::from);
        defaultFormatter.put(OffsetDateTime.class.getName(), OffsetDateTime::from);
        defaultFormatter.put(ZonedDateTime.class.getName(), ZonedDateTime::from);
        defaultFormatter.put(Instant.class.getName(), DateTransformer::instantFrom);
        return defaultFormatter;
    }

    private static Instant instantFrom(TemporalAccessor temporal) {
        if (temporal.isSupported(ChronoField.INSTANT_SECONDS) && temporal.isSupported(ChronoField.NANO_OF_SECOND)) {
            return Instant.from(temporal);
        }
        LocalDate date = LocalDate.ofEpochDay(temporal.getLong(ChronoField.EPOCH_DAY));
        LocalTime time = LocalTime.ofNanoOfDay(temporal.getLong(ChronoField.NANO_OF_DAY));
        return date.atTime(time).toInstant(ZoneOffset.UTC);
    }

    private static DateTimeFormatter getDateFormat(Transformation formatter, String className) {
        if (formatter != null) {
            String format = formatter.getFormat();
            String locale = formatter.getLocale();
            if (format == null) {
                return null;
            }
            if (locale == null) {
                return DateTimeFormatter.ofPattern(format);
            }
            return DateTimeFormatter.ofPattern(format).withLocale(Locale.forLanguageTag(locale));
        }
        return DEFAULT_FORMATTER.get(className);
    }

    private static Map<String, DateTimeFormatter> createDefaultFormatter() {
        HashMap<String, DateTimeFormatter> defaultFormatter = new HashMap<String, DateTimeFormatter>();
        defaultFormatter.put(LocalDate.class.getName(), DateTimeFormatter.ISO_LOCAL_DATE);
        defaultFormatter.put(LocalTime.class.getName(), DateTimeFormatter.ISO_LOCAL_TIME);
        defaultFormatter.put(LocalDateTime.class.getName(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        defaultFormatter.put(OffsetTime.class.getName(), DateTimeFormatter.ISO_OFFSET_TIME);
        defaultFormatter.put(OffsetDateTime.class.getName(), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        defaultFormatter.put(ZonedDateTime.class.getName(), DateTimeFormatter.ISO_ZONED_DATE_TIME);
        defaultFormatter.put(Instant.class.getName(), DateTimeFormatter.ISO_INSTANT);
        return defaultFormatter;
    }
}

