/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher.helper;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLScalarType;
import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.execution.Classes;
import io.smallrye.graphql.execution.datafetcher.helper.AbstractHelper;
import io.smallrye.graphql.execution.datafetcher.helper.ReflectionInvoker;
import io.smallrye.graphql.json.InputFieldsInfo;
import io.smallrye.graphql.json.JsonBCreator;
import io.smallrye.graphql.scalar.GraphQLScalarTypes;
import io.smallrye.graphql.schema.model.AdaptWith;
import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import io.smallrye.graphql.transformation.TransformException;
import io.smallrye.graphql.transformation.Transformer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ArgumentHelper
extends AbstractHelper {
    private final List<Argument> arguments;
    private static final String CONSTRUCTOR_METHOD_NAME = "<init>";

    public ArgumentHelper(List<Argument> arguments) {
        this.arguments = arguments;
    }

    public List<Object> getArguments(DataFetchingEnvironment dfe) throws AbstractDataFetcherException {
        return this.getArguments(dfe, false);
    }

    public List<Object> getArguments(DataFetchingEnvironment dfe, boolean excludeSource) throws AbstractDataFetcherException {
        LinkedList<Object> argumentObjects = new LinkedList<Object>();
        for (Argument argument : this.arguments) {
            if (argument.isSourceArgument() && excludeSource) continue;
            Object argumentValue = this.getArgument(dfe, argument);
            argumentObjects.add(argumentValue);
        }
        return argumentObjects;
    }

    private Object getArgument(DataFetchingEnvironment dfe, Argument argument) throws AbstractDataFetcherException {
        Object source;
        if (argument.isSourceArgument() && (source = dfe.getSource()) != null) {
            return source;
        }
        Optional<Object> argumentValueFromGraphQLJava = dfe.getArgument(argument.getName());
        if (argumentValueFromGraphQLJava == null) {
            if (argument.hasWrapper() && argument.getWrapper().isOptional()) {
                return Optional.empty();
            }
            return null;
        }
        if (argument.hasWrapper() && argument.getWrapper().isOptional()) {
            argumentValueFromGraphQLJava = Optional.of(argumentValueFromGraphQLJava);
        }
        return this.transformOrAdapt(argumentValueFromGraphQLJava, (Field)argument, dfe);
    }

    @Override
    Object singleTransform(Object argumentValue, Field field) throws AbstractDataFetcherException {
        if (!this.shouldTransform(field)) {
            return argumentValue;
        }
        return this.transformInput(field, argumentValue);
    }

    @Override
    Object singleAdapting(Object argumentValue, Field field, DataFetchingEnvironment dfe) throws AbstractDataFetcherException {
        if (argumentValue == null) {
            return null;
        }
        if (this.shouldAdaptWith(field)) {
            return this.adaptInputWith(field, argumentValue, dfe);
        }
        if (this.shouldAdaptTo(field)) {
            return this.adaptInputTo(field, argumentValue);
        }
        if (field.hasWrapper() && field.getWrapper().isMap()) {
            return this.defaultAdaptMap(field, argumentValue, dfe);
        }
        return argumentValue;
    }

    private Object adaptInputTo(Field field, Object object) {
        String methodName = this.getCreateMethodName(field);
        if (methodName != null && !methodName.isEmpty()) {
            Class<?> mappingClass = this.classloadingService.loadClass(field.getReference().getClassName());
            try {
                if (methodName.equals(CONSTRUCTOR_METHOD_NAME)) {
                    Constructor<?> constructor = mappingClass.getConstructor(object.getClass());
                    return constructor.newInstance(object);
                }
                Method method = mappingClass.getMethod(methodName, object.getClass());
                if (Modifier.isStatic(method.getModifiers())) {
                    Object instance = method.invoke(null, object);
                    return instance;
                }
                Constructor<?> constructor = mappingClass.getConstructor(new Class[0]);
                Object instance = constructor.newInstance(new Object[0]);
                method.invoke(instance, object);
                return instance;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
        return object;
    }

    private Object defaultAdaptMap(Field field, Object argumentValue, DataFetchingEnvironment dfe) throws AbstractDataFetcherException {
        Set providedSet = (Set)argumentValue;
        Set adaptInnerSet = (Set)this.recursiveAdapting(providedSet, this.mapAdapter.getAdaptedField(field), dfe);
        return this.mapAdapter.from(adaptInnerSet, field);
    }

    private Object adaptInputWith(Field field, Object argumentValue, DataFetchingEnvironment dfe) throws TransformException, AbstractDataFetcherException {
        if (argumentValue == null) {
            return null;
        }
        if (field.isAdaptingWith()) {
            AdaptWith adaptWith = field.getAdaptWith();
            ReflectionInvoker reflectionInvoker = this.getReflectionInvokerForInput(adaptWith);
            if (Map.class.isAssignableFrom(argumentValue.getClass())) {
                argumentValue = this.correctComplexObjectFromMap((Map)argumentValue, field, dfe);
            }
            try {
                Object adaptedObject = reflectionInvoker.invoke(argumentValue);
                return adaptedObject;
            }
            catch (Exception ex) {
                SmallRyeGraphQLServerLogging.log.transformError(ex);
                throw new TransformException(ex, field, argumentValue);
            }
        }
        return argumentValue;
    }

    private Object transformInput(Field field, Object object) throws AbstractDataFetcherException {
        if (object == null) {
            return null;
        }
        if (!this.shouldTransform(field)) {
            return object;
        }
        try {
            Transformer transformer = super.getTransformer(field);
            if (transformer == null) {
                return object;
            }
            return transformer.in(object);
        }
        catch (Exception e) {
            throw new TransformException(e, field, object);
        }
    }

    private String getCreateMethodName(Field field) {
        if (field.getReference().isAdaptingTo()) {
            return field.getReference().getAdaptTo().getDeserializeMethod();
        }
        if (field.isAdaptingTo()) {
            return field.getAdaptTo().getDeserializeMethod();
        }
        return null;
    }

    @Override
    protected Object afterRecursiveTransform(Object fieldValue, Field field, DataFetchingEnvironment dfe) throws AbstractDataFetcherException {
        String receivedType;
        String expectedType = field.getReference().getClassName();
        if (expectedType.equals(receivedType = fieldValue.getClass().getName())) {
            return fieldValue;
        }
        if (Classes.isPrimitiveOf(expectedType, receivedType)) {
            return fieldValue;
        }
        if (expectedType.equals("java.util.Calendar") && receivedType.equals("java.util.GregorianCalendar")) {
            return fieldValue;
        }
        if (field.getReference().getType().equals((Object)ReferenceType.ENUM)) {
            Class<?> enumClass = this.classloadingService.loadClass(field.getReference().getClassName());
            return Enum.valueOf(enumClass, fieldValue.toString());
        }
        return this.correctObjectClass(fieldValue, field, dfe);
    }

    private Object correctObjectClass(Object argumentValue, Field field, DataFetchingEnvironment dfe) throws AbstractDataFetcherException {
        String receivedClassName = argumentValue.getClass().getName();
        if (Map.class.isAssignableFrom(argumentValue.getClass())) {
            return this.correctComplexObjectFromMap((Map)argumentValue, field, dfe);
        }
        if (receivedClassName.equals(String.class.getName())) {
            if (field.getReference().getClassName().equals("org.bson.types.ObjectId")) {
                return argumentValue;
            }
            return this.correctComplexObjectFromJsonString(argumentValue.toString(), field);
        }
        if (GraphQLScalarTypes.isGraphQLScalarType(field.getReference().getClassName())) {
            GraphQLScalarType scalar = GraphQLScalarTypes.getScalarByClassName(field.getReference().getClassName());
            return scalar.getCoercing().parseLiteral(argumentValue);
        }
        SmallRyeGraphQLServerLogging.log.dontKnowHoToHandleArgument(argumentValue.getClass().getName(), field.getMethodName());
        return argumentValue;
    }

    private Object correctComplexObjectFromMap(Map m, Field field, DataFetchingEnvironment dfe) throws AbstractDataFetcherException {
        String fieldName;
        String className = field.getReference().getClassName();
        if (InputFieldsInfo.hasTransformationFields(className)) {
            Map<String, Field> transformationFields = InputFieldsInfo.getTransformationFields(className);
            for (Map.Entry<String, Field> entry : transformationFields.entrySet()) {
                fieldName = entry.getKey();
                if (!m.containsKey(fieldName)) continue;
                Object valueThatShouldTransform = m.get(fieldName);
                Field fieldThatShouldTransform = entry.getValue();
                valueThatShouldTransform = super.recursiveTransform(valueThatShouldTransform, fieldThatShouldTransform, dfe);
                m.put(fieldName, valueThatShouldTransform);
            }
        }
        if (InputFieldsInfo.hasAdaptToFields(className)) {
            Map<String, Field> mappingFields = InputFieldsInfo.getAdaptToFields(className);
            for (Map.Entry<String, Field> entry : mappingFields.entrySet()) {
                fieldName = entry.getKey();
                if (!m.containsKey(fieldName)) continue;
                Object valueThatShouldMap = m.get(fieldName);
                Field fieldThatShouldMap = entry.getValue();
                valueThatShouldMap = super.recursiveAdapting(valueThatShouldMap, fieldThatShouldMap, dfe);
                m.put(fieldName, valueThatShouldMap);
            }
        }
        if (InputFieldsInfo.hasAdaptWithFields(className)) {
            Map<String, Field> adaptingFields = InputFieldsInfo.getAdaptWithFields(className);
            for (Map.Entry<String, Field> entry : adaptingFields.entrySet()) {
                fieldName = entry.getKey();
                if (!m.containsKey(fieldName)) continue;
                Object valueThatShouldAdapt = m.get(fieldName);
                Field fieldThatShouldAdapt = entry.getValue();
                Object valueThatAdapted = super.recursiveAdapting(valueThatShouldAdapt, fieldThatShouldAdapt, dfe);
                m.put(fieldName, valueThatAdapted);
            }
        }
        m = this.includeNullCreatorParameters(m, field);
        String jsonString = JsonBCreator.getJsonB(className).toJson((Object)m);
        return this.correctComplexObjectFromJsonString(jsonString, field);
    }

    private Map includeNullCreatorParameters(Map m, Field field) {
        if (m == null) {
            return null;
        }
        String className = field.getReference().getClassName();
        HashMap<String, Object> result = new HashMap<String, Object>(m);
        for (Field f : InputFieldsInfo.getCreatorParameters(className)) {
            String s = f.getName();
            if (result.containsKey(s)) {
                Object fieldValue = result.get(s);
                if (fieldValue instanceof Map) {
                    result.put(s, this.includeNullCreatorParameters((Map)result.get(s), f));
                    continue;
                }
                if (!(fieldValue instanceof List)) continue;
                result.put(s, this.handleList((List)fieldValue, f));
                continue;
            }
            result.put(s, null);
        }
        return result;
    }

    private List handleList(List list, Field field) {
        ArrayList result = new ArrayList();
        list.forEach(item -> {
            if (item instanceof Map) {
                result.add(this.includeNullCreatorParameters((Map)item, field));
            } else {
                result.add(item);
            }
        });
        return result;
    }

    private Object correctComplexObjectFromJsonString(String jsonString, Field field) throws AbstractDataFetcherException {
        Type type;
        String className;
        if (field.isAdaptingWith()) {
            className = field.getAdaptWith().getToReference().getClassName();
            type = this.getType(field.getAdaptWith().getToReference());
        } else {
            type = this.getType(field.getReference());
            className = field.getReference().getClassName();
        }
        try {
            Jsonb jsonb = JsonBCreator.getJsonB(className);
            return jsonb.fromJson(jsonString, type);
        }
        catch (JsonbException jbe) {
            throw new TransformException(jbe, field, jsonString);
        }
    }

    private Type getType(Reference reference) {
        Class<?> ownerClass = this.classloadingService.loadClass(reference.getClassName());
        if (reference.getAllParametrizedTypes() == null || reference.getAllParametrizedTypes().isEmpty()) {
            return ownerClass;
        }
        ArrayList<Type> typeParameters = new ArrayList<Type>();
        for (TypeVariable<Class<?>> typeParameter : ownerClass.getTypeParameters()) {
            Reference typeRef = reference.getClassParametrizedType(typeParameter.getName());
            typeParameters.add(this.getType(typeRef));
        }
        Type[] types = typeParameters.toArray(new Type[0]);
        return new ParameterizedTypeImpl(ownerClass, types);
    }

    private static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Type ownerClass;
        private final Type[] types;

        public ParameterizedTypeImpl(Type ownerClass, Type[] types) {
            this.ownerClass = ownerClass;
            this.types = types;
        }

        @Override
        public Type getRawType() {
            return this.ownerClass;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.types;
        }
    }
}

