/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.scalar.custom;

import graphql.language.IntValue;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.api.CustomIntScalar;
import io.smallrye.graphql.spi.ClassloadingService;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;

public class IntCoercing
implements Coercing<Object, BigInteger> {
    private final Class<? extends CustomIntScalar> customScalarClass;

    public IntCoercing(String customScalarClass) {
        ClassloadingService classloadingService = ClassloadingService.get();
        this.customScalarClass = classloadingService.loadClass(customScalarClass);
    }

    private CustomIntScalar newInstance(BigInteger graphqlPrimitiveValue) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return graphqlPrimitiveValue == null ? null : this.customScalarClass.getConstructor(BigInteger.class).newInstance(graphqlPrimitiveValue);
    }

    private static String typeName(Object input) {
        if (input == null) {
            return "null";
        }
        return input.getClass().getSimpleName();
    }

    private CustomIntScalar convertImpl(Object input) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        if (input instanceof BigInteger) {
            return this.newInstance((BigInteger)input);
        }
        if (input.getClass().isAssignableFrom(this.customScalarClass)) {
            return (CustomIntScalar)input;
        }
        throw new RuntimeException("Unable to convert null input.");
    }

    public BigInteger serialize(Object input) throws CoercingSerializeException {
        CustomIntScalar result;
        try {
            result = this.convertImpl(input);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CoercingSerializeException("Unable to serialize input: " + String.valueOf(input), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw SmallRyeGraphQLServerMessages.msg.coercingSerializeException("BigInteger or class extending " + String.valueOf(this.customScalarClass), IntCoercing.typeName(input), e);
        }
        return result.intValueForSerialization();
    }

    public Object parseValue(Object input) throws CoercingParseValueException {
        CustomIntScalar result;
        try {
            result = this.convertImpl(input);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CoercingParseValueException("Unable to serialize input: " + String.valueOf(input), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw SmallRyeGraphQLServerMessages.msg.coercingParseValueException("BigInteger or class extending " + String.valueOf(this.customScalarClass), IntCoercing.typeName(input), null);
        }
        return result;
    }

    public Object parseLiteral(Object input) throws CoercingParseLiteralException {
        if (!(input instanceof IntValue)) {
            throw new CoercingParseLiteralException("Expected a String AST type object but was '" + IntCoercing.typeName(input) + "'.");
        }
        try {
            return this.newInstance(((IntValue)input).getValue());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CoercingParseLiteralException("Unable to parse literal: " + String.valueOf(input), (Throwable)e);
        }
    }

    public Value<?> valueToLiteral(Object input) {
        BigInteger s = this.serialize(input);
        return IntValue.newIntValue((BigInteger)s).build();
    }
}

