/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.scalar.federation;

import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.Coercing;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.api.federation.link.Import;
import java.util.Map;

public class ImportCoercing
implements Coercing<Object, Object> {
    private static String typeName(Object input) {
        if (input == null) {
            return "null";
        }
        return input.getClass().getSimpleName();
    }

    private Object convertImpl(Object input) {
        if (input instanceof Map) {
            Object name = ((Map)input).get("name");
            if (name instanceof String) {
                Object as = ((Map)input).get("as");
                if (as != null) {
                    if (as instanceof String) {
                        if (name.equals(as)) {
                            return name;
                        }
                        return Map.of("name", name, "as", as);
                    }
                    throw new RuntimeException("Can not parse a String from [" + ImportCoercing.typeName(as) + "]");
                }
                return name;
            }
            throw new RuntimeException("Can not parse a String from [" + ImportCoercing.typeName(name) + "]");
        }
        throw new RuntimeException("Can not parse a Import from [" + ImportCoercing.typeName(input) + "]");
    }

    public Object serialize(Object input) {
        if (input == null) {
            return null;
        }
        try {
            return this.convertImpl(input);
        }
        catch (RuntimeException e) {
            throw SmallRyeGraphQLServerMessages.msg.coercingSerializeException(Import.class.getSimpleName(), input.getClass().getSimpleName(), null);
        }
    }

    public Object parseValue(Object input) {
        try {
            return this.convertImpl(input);
        }
        catch (RuntimeException e) {
            throw SmallRyeGraphQLServerMessages.msg.coercingParseValueException(Import.class.getSimpleName(), input.getClass().getSimpleName(), e);
        }
    }

    public Object parseLiteral(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof StringValue) {
            return ((StringValue)input).getValue();
        }
        throw SmallRyeGraphQLServerMessages.msg.coercingParseLiteralException(input.getClass().getSimpleName());
    }

    public Value<?> valueToLiteral(Object input) {
        Object s = this.serialize(input);
        if (s instanceof String) {
            return StringValue.newStringValue((String)((String)s)).build();
        }
        Map map = (Map)s;
        StringValue name = StringValue.newStringValue((String)((String)map.get("name"))).build();
        StringValue as = StringValue.newStringValue((String)((String)map.get("as"))).build();
        return ObjectValue.newObjectValue().objectField(new ObjectField("name", (Value)name)).objectField(new ObjectField("as", (Value)as)).build();
    }
}

