/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.bootstrap;

import com.apollographql.federation.graphqljava.FederationDirectives;
import com.apollographql.federation.graphqljava.exceptions.UnsupportedFederationVersionException;
import graphql.language.DirectiveDefinition;
import io.smallrye.graphql.scalar.federation.ImportCoercing;
import io.smallrye.graphql.schema.model.DirectiveInstance;
import io.smallrye.graphql.schema.model.Schema;
import java.lang.module.ModuleDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class LinkProcessor {
    private String specUrl;
    private String specNamespace;
    private final Schema schema;
    private final Map<String, String> specImports;
    private final Map<String, String> imports;
    private final List<String> federationSpecDefinitions;
    private static final Pattern FEDERATION_VERSION_PATTERN = Pattern.compile("/v([\\d.]+)$");
    private static final Map<String, String> FEDERATION_DIRECTIVES_VERSION = Map.of("@composeDirective", "2.1", "@interfaceObject", "2.3", "@authenticated", "2.5", "@requiresScopes", "2.5", "@policy", "2.6");
    private static final ImportCoercing IMPORT_COERCING = new ImportCoercing();
    private static final List<String> FORBIDDEN_SPEC_DEFINITIONS = Arrays.asList("@link", "Import", "Purpose");

    public LinkProcessor(Schema schema) {
        this.schema = schema;
        this.imports = new LinkedHashMap<String, String>();
        this.specImports = new LinkedHashMap<String, String>();
        this.federationSpecDefinitions = new ArrayList<String>();
    }

    public void createLinkImports() {
        ArrayList<DirectiveInstance> specLinkDirectives = new ArrayList<DirectiveInstance>();
        ArrayList<DirectiveInstance> linkDirectives = new ArrayList<DirectiveInstance>();
        this.schema.getDirectiveInstances().stream().filter(directiveInstance -> "link".equals(directiveInstance.getType().getName())).filter(directiveInstance -> {
            Map values = directiveInstance.getValues();
            return values.containsKey("url") && values.get("url") instanceof String;
        }).forEach(directiveInstance -> {
            String url = (String)directiveInstance.getValues().get("url");
            if (url.startsWith("https://specs.apollo.dev/federation/")) {
                specLinkDirectives.add((DirectiveInstance)directiveInstance);
            } else {
                linkDirectives.add((DirectiveInstance)directiveInstance);
            }
        });
        this.createSpecLinkImports(specLinkDirectives);
        this.createLinkImports(linkDirectives);
    }

    private void createSpecLinkImports(List<DirectiveInstance> linkDirectives) {
        if (linkDirectives.isEmpty()) {
            return;
        }
        if (linkDirectives.size() > 1) {
            String directivesString = linkDirectives.stream().map(DirectiveInstance::toString).collect(Collectors.joining(", "));
            throw new RuntimeException("Multiple @link directives that import Federation spec found on schema: " + directivesString);
        }
        DirectiveInstance linkDirective = linkDirectives.get(0);
        this.specUrl = (String)linkDirective.getValues().get("url");
        this.specNamespace = (String)linkDirective.getValues().get("as");
        this.validateNamespace(this.specNamespace, this.specUrl);
        String federationSpecVersion = this.extractFederationVersion(this.specUrl);
        if (this.isVersionGreaterThan("2.0", federationSpecVersion)) {
            throw new UnsupportedFederationVersionException(this.specUrl);
        }
        this.processFederationSpecImports(this.specUrl, this.federationSpecDefinitions);
        this.processImports((Object[])linkDirective.getValues().get("import"), this.specImports);
        this.validateForbiddenSpecDefinitionsImport(this.specImports);
        for (Map.Entry<String, String> directiveInfo : FEDERATION_DIRECTIVES_VERSION.entrySet()) {
            this.validateDirectiveSupport(this.specImports, federationSpecVersion, directiveInfo.getKey(), directiveInfo.getValue());
        }
        this.specImports.forEach((key, value) -> {
            if (!this.federationSpecDefinitions.contains(key)) {
                throw new RuntimeException(String.format("Import key %s is not present in the Federation spec %s", key, this.specUrl));
            }
        });
    }

    private void createLinkImports(List<DirectiveInstance> linkDirectives) {
        for (DirectiveInstance linkDirective : linkDirectives) {
            this.processImports((Object[])linkDirective.getValues().get("import"), this.imports);
        }
    }

    private void validateNamespace(String namespace, String url) {
        if (namespace != null) {
            if (namespace.startsWith("@")) {
                throw new RuntimeException(String.format("Argument as %s for Federation spec %s on @link directive must not start with '@'", namespace, url));
            }
            if (namespace.contains("__")) {
                throw new RuntimeException(String.format("Argument as %s for Federation spec %s on @link directive must not contain the namespace separator '__'", namespace, url));
            }
            if (namespace.endsWith("_")) {
                throw new RuntimeException(String.format("Argument as %s for Federation spec %s on @link directive must not end with an underscore", namespace, url));
            }
        }
    }

    private boolean isVersionGreaterThan(String version1, String version2) {
        ModuleDescriptor.Version v2;
        ModuleDescriptor.Version v1 = ModuleDescriptor.Version.parse(version1);
        return v1.compareTo(v2 = ModuleDescriptor.Version.parse(version2)) > 0;
    }

    private String extractFederationVersion(String specUrl) {
        try {
            Matcher matcher = FEDERATION_VERSION_PATTERN.matcher(specUrl);
            if (matcher.find()) {
                return matcher.group(1);
            }
            throw new UnsupportedFederationVersionException(specUrl);
        }
        catch (Exception e) {
            throw new UnsupportedFederationVersionException(specUrl);
        }
    }

    private void processImports(Object[] importsArray, Map<String, String> imports) {
        if (importsArray == null) {
            return;
        }
        for (Object _import : importsArray) {
            String importName;
            Object parsedImport = IMPORT_COERCING.parseValue(_import);
            if (parsedImport == null) continue;
            if (parsedImport instanceof String) {
                importName = (String)parsedImport;
                imports.put(importName, importName);
                continue;
            }
            if (!(parsedImport instanceof Map)) continue;
            Map importMap = (Map)parsedImport;
            importName = (String)importMap.get("name");
            String importAs = (String)importMap.get("as");
            if (importName.startsWith("@") && !importAs.startsWith("@") || !importName.startsWith("@") && importAs.startsWith("@")) {
                throw new RuntimeException(String.format("Import name '%s' and alias '%s' on on @link directive must be of the same type: either both directives or both types", importName, importAs));
            }
            imports.put(importName, importAs);
        }
    }

    private void validateDirectiveSupport(Map<String, String> imports, String version, String directiveName, String minVersion) {
        if (imports.containsKey(directiveName) && this.isVersionGreaterThan(minVersion, version)) {
            throw new RuntimeException(String.format("Federation v%s feature %s imported using old Federation v%s version", minVersion, directiveName, version));
        }
    }

    private void processFederationSpecImports(String specUrl, List<String> imports) {
        imports.addAll(FederationDirectives.loadFederationSpecDefinitions((String)specUrl).stream().map(definition -> definition instanceof DirectiveDefinition ? "@" + definition.getName() : definition.getName()).collect(Collectors.toList()));
    }

    private void validateForbiddenSpecDefinitionsImport(Map<String, String> imports) {
        for (String forbiddenKey : FORBIDDEN_SPEC_DEFINITIONS) {
            if (!imports.containsKey(forbiddenKey)) continue;
            throw new RuntimeException(String.format("Import key %s should not be imported within @link directive itself", forbiddenKey));
        }
    }

    public String newNameDirective(String name) {
        return this.newName(name, true);
    }

    public String newName(String name) {
        return this.newName(name, false);
    }

    private String newName(String name, boolean isDirective) {
        Object key;
        Object object = key = isDirective ? "@" + name : name;
        if (this.imports.containsKey(key)) {
            String newName = this.imports.get(key);
            return isDirective ? newName.substring(1) : newName;
        }
        if (this.federationSpecDefinitions.contains(key) && !((String)key).equals("@link")) {
            if (this.specImports.containsKey(key)) {
                String newName = this.specImports.get(key);
                return isDirective ? newName.substring(1) : newName;
            }
            if (name.equals("Import") || name.equals("Purpose")) {
                return "link__" + name;
            }
            String prefix = this.specNamespace == null ? "federation__" : this.specNamespace + "__";
            return prefix + name;
        }
        return name;
    }
}

