/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.context;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.language.Document;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.execution.QueryCache;
import io.smallrye.graphql.execution.context.DocumentSupplier;
import io.smallrye.graphql.schema.model.Field;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class SmallRyeContext
implements Context {
    private final String createdBy;
    private String fetchId;
    private JsonObject request;
    private String executionId;
    private Field field;
    private String fieldName;
    private Map<String, ?> arguments;
    private Object source;
    private String path;
    private JsonArray selectedFields;
    private JsonArray selectedAndSourceFields;
    private String operationType;
    private List<String> requestedOperationTypes;
    private String parentTypeName;
    private String operationName;
    private DataFetchingEnvironment dataFetchingEnvironment;
    private ExecutionInput executionInput;
    private QueryCache queryCache;
    private DocumentSupplier documentSupplier;
    private ExecutionResult executionResult;
    private Map<String, Object> addedExtensions = new ConcurrentHashMap<String, Object>();

    public SmallRyeContext clone() {
        SmallRyeContext clone = new SmallRyeContext(this.createdBy);
        clone.fetchId = this.fetchId;
        clone.request = this.request;
        clone.executionId = this.executionId;
        clone.field = this.field;
        clone.fieldName = this.fieldName;
        clone.arguments = this.arguments;
        clone.source = this.source;
        clone.path = this.path;
        clone.selectedFields = this.selectedFields;
        clone.selectedAndSourceFields = this.selectedAndSourceFields;
        clone.operationType = this.operationType;
        clone.requestedOperationTypes = this.requestedOperationTypes;
        clone.parentTypeName = this.parentTypeName;
        clone.operationName = this.operationName;
        clone.dataFetchingEnvironment = this.dataFetchingEnvironment;
        clone.executionInput = this.executionInput;
        clone.queryCache = this.queryCache;
        clone.documentSupplier = this.documentSupplier;
        clone.executionResult = this.executionResult;
        clone.addedExtensions = this.addedExtensions;
        return clone;
    }

    public Map<String, Object> getAddedExtensions() {
        return this.addedExtensions;
    }

    private void setAddedExtensions(Map<String, Object> addedExtensions) {
        this.addedExtensions = addedExtensions;
    }

    public void addExtension(String key, Object value) {
        this.addedExtensions.put(key, value);
    }

    public SmallRyeContext(String createdBy) {
        this.createdBy = createdBy;
    }

    public JsonObject getRequest() {
        return this.request;
    }

    public void setRequest(JsonObject request) {
        this.request = request;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public <A> Map<String, A> getArguments() {
        return this.arguments;
    }

    public <A> void setArguments(Map<String, A> arguments) {
        this.arguments = arguments;
    }

    public <S> S getSource() {
        return (S)this.source;
    }

    public <S> void setSource(S source) {
        this.source = source;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public JsonArray getSelectedFields() {
        return this.selectedFields;
    }

    public void setSelectedFields(JsonArray selectedFields) {
        this.selectedFields = selectedFields;
    }

    public JsonArray getSelectedAndSourceFields() {
        return this.selectedAndSourceFields;
    }

    public void setSelectedAndSourceFields(JsonArray selectedAndSourceFields) {
        this.selectedAndSourceFields = selectedAndSourceFields;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public List<String> getRequestedOperationTypes() {
        return this.requestedOperationTypes;
    }

    public void setRequestedOperationTypes(List<String> requestedOperationTypes) {
        this.requestedOperationTypes = requestedOperationTypes;
    }

    public Optional<String> getParentTypeName() {
        if (this.parentTypeName != null) {
            return Optional.of(this.parentTypeName);
        }
        return Optional.empty();
    }

    public void setParentTypeName(String parentTypeName) {
        this.parentTypeName = parentTypeName;
    }

    public Optional<String> getOperationName() {
        if (this.operationName != null) {
            return Optional.of(this.operationName);
        }
        return Optional.empty();
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public DataFetchingEnvironment getDataFetchingEnvironment() {
        return this.dataFetchingEnvironment;
    }

    public void setDataFetchingEnvironment(DataFetchingEnvironment dataFetchingEnvironment) {
        this.dataFetchingEnvironment = dataFetchingEnvironment;
    }

    public ExecutionInput getExecutionInput() {
        return this.executionInput;
    }

    public void setExecutionInput(ExecutionInput executionInput) {
        this.executionInput = executionInput;
    }

    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    public void setQueryCache(QueryCache queryCache) {
        this.queryCache = queryCache;
    }

    public DocumentSupplier getDocumentSupplier() {
        return this.documentSupplier;
    }

    public void setDocumentSupplier(DocumentSupplier documentSupplier) {
        this.documentSupplier = documentSupplier;
    }

    public void setExecutionResult(ExecutionResult executionResult) {
        this.executionResult = executionResult;
    }

    public <T> T unwrap(Class<T> wrappedType) {
        if (wrappedType.equals(DataFetchingEnvironment.class)) {
            return (T)this.getDataFetchingEnvironment();
        }
        if (wrappedType.equals(ExecutionInput.class)) {
            return (T)this.getExecutionInput();
        }
        if (wrappedType.equals(Document.class)) {
            if (this.getExecutionInput() != null && this.getQueryCache() != null) {
                DocumentSupplier documentSupplier = new DocumentSupplier(this.executionInput, this.queryCache);
                return (T)documentSupplier.get();
            }
            return null;
        }
        if (wrappedType.equals(ExecutionResult.class)) {
            if (this.executionResult != null) {
                return (T)this.executionResult;
            }
            return null;
        }
        throw SmallRyeGraphQLServerMessages.msg.unsupportedWrappedClass(wrappedType.getName());
    }

    public String toString() {
        String f = "";
        if (this.dataFetchingEnvironment != null) {
            f = this.dataFetchingEnvironment.getExecutionStepInfo().getField().getName();
        }
        return "SmallRyeContext{\n\t createdBy=" + this.createdBy + ",\n\t request=" + this.request + ",\n\t executionId=" + this.executionId + ",\n\t field=" + this.field + ",\n\t fieldName=" + this.fieldName + " (" + f + "),\n\t arguments=" + this.arguments + ",\n\t source=" + this.source + ",\n\t path=" + this.path + ",\n\t selectedFields=" + this.selectedFields + ",\n\t selectedAndSourceFields=" + this.selectedAndSourceFields + ",\n\t operationType=" + this.operationType + ",\n\t requestedOperationTypes=" + this.requestedOperationTypes + ",\n\t parentTypeName=" + this.parentTypeName + ",\n\t operationName=" + this.operationName + ",\n}";
    }
}

