/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.health.checks;

import io.smallrye.health.checks.HealthChecksLogging;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

public class SocketHealthCheck
implements HealthCheck {
    static final String DEFAULT_NAME = "Socket Check";
    static final int DEFAULT_TIMEOUT = 2000;
    private String host;
    private String name;
    private int port;
    private int timeout;

    public SocketHealthCheck(String host, int port) {
        this.host = host;
        this.port = port;
        this.name = DEFAULT_NAME;
        this.timeout = 2000;
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder healthCheckResponseBuilder = HealthCheckResponse.named((String)this.name);
        healthCheckResponseBuilder.withData("host", String.format("%s:%d", this.host, this.port));
        try (Socket s = new Socket();){
            InetSocketAddress socketAddress = new InetSocketAddress(this.host, this.port);
            s.connect(socketAddress, this.timeout);
            healthCheckResponseBuilder.up();
        }
        catch (IOException ex) {
            HealthChecksLogging.log.socketHealthCheckError(ex);
            healthCheckResponseBuilder.withData("error", ex.getMessage());
            healthCheckResponseBuilder.down();
        }
        return healthCheckResponseBuilder.build();
    }

    public SocketHealthCheck name(String name) {
        this.name = name;
        return this;
    }

    public SocketHealthCheck timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }
}

