/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.interceptors;

import io.smallrye.metrics.interceptors.MetricResolver;
import io.smallrye.metrics.interceptors.MetricsBinding;
import io.smallrye.metrics.setup.MetricsMetadata;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.jboss.logging.Logger;

@Interceptor
@MetricsBinding
@Priority(value=1000)
public class MetricsInterceptor {
    private static final Logger log = Logger.getLogger(MetricsInterceptor.class);
    private final MetricRegistry registry;
    private final MetricResolver resolver;

    @Inject
    private MetricsInterceptor(MetricRegistry registry) {
        this.registry = registry;
        this.resolver = new MetricResolver();
    }

    @AroundConstruct
    private Object metrics(InvocationContext context) throws Exception {
        Class bean = context.getConstructor().getDeclaringClass();
        log.debugf("MetricsInterceptor, bean=%s\n", bean);
        MetricsMetadata.registerMetrics(this.registry, this.resolver, bean, context.getConstructor());
        Class type = bean;
        do {
            for (Method method : type.getDeclaredMethods()) {
                if (method.isSynthetic() || Modifier.isPrivate(method.getModifiers())) continue;
                MetricsMetadata.registerMetrics(this.registry, this.resolver, bean, method);
            }
        } while (!Object.class.equals(type = type.getSuperclass()));
        Object target = context.proceed();
        type = bean;
        do {
            for (Method method : type.getDeclaredMethods()) {
                MetricResolver.Of<org.eclipse.microprofile.metrics.annotation.Gauge> gauge = this.resolver.gauge(bean, method);
                if (!gauge.isPresent()) continue;
                org.eclipse.microprofile.metrics.annotation.Gauge g = gauge.metricAnnotation();
                Metadata metadata = MetricsMetadata.getMetadata(g, gauge.metricName(), g.unit(), g.description(), g.displayName(), MetricType.GAUGE, false, g.tags());
                this.registry.register(metadata, (Metric)new ForwardingGauge(method, context.getTarget()));
            }
        } while (!Object.class.equals(type = type.getSuperclass()));
        return target;
    }

    private static Object invokeMethod(Method method, Object object) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException cause) {
            throw new IllegalStateException("Error while calling method [" + method + "]", cause);
        }
    }

    private static final class ForwardingGauge
    implements Gauge<Object> {
        private final Method method;
        private final Object object;

        private ForwardingGauge(Method method, Object object) {
            this.method = method;
            this.object = object;
            method.setAccessible(true);
        }

        public Object getValue() {
            return MetricsInterceptor.invokeMethod(this.method, this.object);
        }
    }
}

