/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.response;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.models.media.ContentImpl;
import io.smallrye.openapi.api.models.media.MediaTypeImpl;
import io.smallrye.openapi.api.models.responses.APIResponseImpl;
import io.smallrye.openapi.api.models.responses.APIResponsesImpl;
import io.smallrye.openapi.runtime.io.ContentDirection;
import io.smallrye.openapi.runtime.io.CurrentScannerInfo;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.content.ContentReader;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.header.HeaderReader;
import io.smallrye.openapi.runtime.io.link.LinkReader;
import io.smallrye.openapi.runtime.io.response.ResponseConstant;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class ResponseReader {
    private ResponseReader() {
    }

    public static APIResponses readResponses(AnnotationScannerContext context, AnnotationValue annotationValue) {
        AnnotationInstance[] nestedArray;
        if (annotationValue == null) {
            return null;
        }
        IoLogging.log.annotationsListInto("@APIResponse", "APIResponses model");
        APIResponsesImpl responses = new APIResponsesImpl();
        for (AnnotationInstance nested : nestedArray = annotationValue.asNestedArray()) {
            String responseCode = JandexUtil.stringValue(nested, "responseCode");
            if (responseCode == null) continue;
            responses.addAPIResponse(responseCode, ResponseReader.readResponse(context, nested));
        }
        return responses;
    }

    public static APIResponses readResponses(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.log.jsonList("APIResponse");
        APIResponsesImpl model = new APIResponsesImpl();
        model.setDefaultValue(ResponseReader.readResponse(node.get("default")));
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            if ("default".equals(fieldName)) continue;
            model.addAPIResponse(fieldName, ResponseReader.readResponse(node.get(fieldName)));
        }
        return model;
    }

    public static Map<String, APIResponse> readResponsesMap(AnnotationScannerContext context, AnnotationValue annotationValue) {
        AnnotationInstance[] nestedArray;
        if (annotationValue == null) {
            return null;
        }
        IoLogging.log.annotationsMap("@APIResponse");
        LinkedHashMap<String, APIResponse> responses = new LinkedHashMap<String, APIResponse>();
        for (AnnotationInstance nested : nestedArray = annotationValue.asNestedArray()) {
            String name = JandexUtil.stringValue(nested, "name");
            if (name == null && JandexUtil.isRef(nested)) {
                name = JandexUtil.nameFromRef(nested);
            }
            if (name == null) continue;
            responses.put(name, ResponseReader.readResponse(context, nested));
        }
        return responses;
    }

    public static Map<String, APIResponse> readResponsesMap(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.log.jsonMap("APIResponse");
        LinkedHashMap<String, APIResponse> responses = new LinkedHashMap<String, APIResponse>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode childNode = node.get(fieldName);
            responses.put(fieldName, ResponseReader.readResponse(childNode));
        }
        return responses;
    }

    public static APIResponse readResponse(AnnotationScannerContext context, AnnotationInstance annotationInstance) {
        if (annotationInstance == null) {
            return null;
        }
        IoLogging.log.singleAnnotation("@APIResponse");
        APIResponseImpl response = new APIResponseImpl();
        response.setDescription(JandexUtil.stringValue(annotationInstance, "description"));
        response.setHeaders(HeaderReader.readHeaders(context, annotationInstance.value("headers")));
        response.setLinks(LinkReader.readLinks(annotationInstance.value("links")));
        response.setContent(ContentReader.readContent(context, annotationInstance.value("content"), ContentDirection.OUTPUT));
        response.setRef(JandexUtil.refValue(annotationInstance, JandexUtil.RefType.Response));
        return response;
    }

    public static APIResponse readResponseSchema(AnnotationScannerContext context, AnnotationInstance annotation) {
        if (annotation == null || CurrentScannerInfo.getCurrentProduces() == null) {
            return null;
        }
        IoLogging.log.singleAnnotation("@APIResponseSchema");
        ContentImpl content = new ContentImpl();
        for (String mediaType : CurrentScannerInfo.getCurrentProduces()) {
            MediaTypeImpl type = new MediaTypeImpl();
            type.setSchema(SchemaFactory.typeToSchema(context.getIndex(), (Type)JandexUtil.value(annotation, "value"), context.getExtensions()));
            content.addMediaType(mediaType, type);
        }
        APIResponseImpl response = new APIResponseImpl();
        response.setContent(content);
        return response;
    }

    private static APIResponse readResponse(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.log.singleJsonObject("Response");
        APIResponseImpl model = new APIResponseImpl();
        model.setRef(JsonUtil.stringProperty(node, "$ref"));
        model.setDescription(JsonUtil.stringProperty(node, "description"));
        model.setHeaders(HeaderReader.readHeaders(node.get("headers")));
        model.setContent(ContentReader.readContent(node.get("content")));
        model.setLinks(LinkReader.readLinks(node.get("links")));
        ExtensionReader.readExtensions(node, model);
        return model;
    }

    public static List<AnnotationInstance> getResponseAnnotations(AnnotationTarget target) {
        return JandexUtil.getRepeatableAnnotation(target, ResponseConstant.DOTNAME_API_RESPONSE, ResponseConstant.DOTNAME_API_RESPONSES);
    }

    public static boolean hasResponseCodeValue(MethodInfo method) {
        if (method.hasAnnotation(ResponseConstant.DOTNAME_API_RESPONSE)) {
            AnnotationInstance annotation = ResponseReader.getResponseAnnotation(method);
            return annotation.value("responseCode") != null;
        }
        return false;
    }

    public static AnnotationInstance getResponseAnnotation(MethodInfo method) {
        return method.annotation(ResponseConstant.DOTNAME_API_RESPONSE);
    }

    public static AnnotationInstance getResponsesAnnotation(MethodInfo method) {
        return method.annotation(ResponseConstant.DOTNAME_API_RESPONSES);
    }

    public static AnnotationInstance getResponseSchemaAnnotation(MethodInfo method) {
        return method.annotation(ResponseConstant.DOTNAME_API_RESPONSE_SCHEMA);
    }

    public static String getResponseName(AnnotationInstance annotation) {
        return JandexUtil.stringValue(annotation, "responseCode");
    }
}

