/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.schema;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.ObjectWriter;
import io.smallrye.openapi.runtime.io.discriminator.DiscriminatorWriter;
import io.smallrye.openapi.runtime.io.extension.ExtensionWriter;
import io.smallrye.openapi.runtime.io.externaldocs.ExternalDocsWriter;
import io.smallrye.openapi.runtime.io.xml.XmlWriter;
import io.smallrye.openapi.runtime.util.StringUtil;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.media.Schema;

public class SchemaWriter {
    private SchemaWriter() {
    }

    public static void writeSchemas(ObjectNode parent, Map<String, Schema> schemas) {
        SchemaWriter.writeSchemas(parent, schemas, "schemas");
    }

    private static void writeSchemas(ObjectNode parent, Map<String, Schema> schemas, String propertyName) {
        if (schemas == null) {
            return;
        }
        ObjectNode schemasNode = parent.putObject(propertyName);
        for (Map.Entry<String, Schema> entry : schemas.entrySet()) {
            SchemaWriter.writeSchema(schemasNode, entry.getValue(), entry.getKey());
        }
    }

    public static void writeSchema(ObjectNode parent, Schema model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        SchemaWriter.writeSchema(node, model);
    }

    private static void writeSchema(ObjectNode node, Schema model) {
        if (StringUtil.isNotEmpty(model.getRef())) {
            JsonUtil.stringProperty(node, "$ref", model.getRef());
        } else {
            JsonUtil.stringProperty(node, "format", model.getFormat());
            JsonUtil.stringProperty(node, "title", model.getTitle());
            JsonUtil.stringProperty(node, "description", model.getDescription());
            ObjectWriter.writeObject(node, "default", model.getDefaultValue());
            JsonUtil.bigDecimalProperty(node, "multipleOf", model.getMultipleOf());
            JsonUtil.bigDecimalProperty(node, "maximum", model.getMaximum());
            JsonUtil.booleanProperty(node, "exclusiveMaximum", model.getExclusiveMaximum());
            JsonUtil.bigDecimalProperty(node, "minimum", model.getMinimum());
            JsonUtil.booleanProperty(node, "exclusiveMinimum", model.getExclusiveMinimum());
            JsonUtil.intProperty(node, "maxLength", model.getMaxLength());
            JsonUtil.intProperty(node, "minLength", model.getMinLength());
            JsonUtil.stringProperty(node, "pattern", model.getPattern());
            JsonUtil.intProperty(node, "maxItems", model.getMaxItems());
            JsonUtil.intProperty(node, "minItems", model.getMinItems());
            JsonUtil.booleanProperty(node, "uniqueItems", model.getUniqueItems());
            JsonUtil.intProperty(node, "maxProperties", model.getMaxProperties());
            JsonUtil.intProperty(node, "minProperties", model.getMinProperties());
            ObjectWriter.writeStringArray(node, model.getRequired(), "required");
            ObjectWriter.writeObjectArray(node, model.getEnumeration(), "enum");
            JsonUtil.enumProperty(node, "type", model.getType());
            SchemaWriter.writeSchema(node, model.getItems(), "items");
            SchemaWriter.writeSchemaList(node, model.getAllOf(), "allOf");
            SchemaWriter.writeSchemas(node, model.getProperties(), "properties");
            if (model.getAdditionalPropertiesBoolean() != null) {
                JsonUtil.booleanProperty(node, "additionalProperties", model.getAdditionalPropertiesBoolean());
            } else {
                SchemaWriter.writeSchema(node, model.getAdditionalPropertiesSchema(), "additionalProperties");
            }
            JsonUtil.booleanProperty(node, "readOnly", model.getReadOnly());
            XmlWriter.writeXML(node, model.getXml());
            ExternalDocsWriter.writeExternalDocumentation(node, model.getExternalDocs());
            ObjectWriter.writeObject(node, "example", model.getExample());
            SchemaWriter.writeSchemaList(node, model.getOneOf(), "oneOf");
            SchemaWriter.writeSchemaList(node, model.getAnyOf(), "anyOf");
            SchemaWriter.writeSchema(node, model.getNot(), "not");
            DiscriminatorWriter.writeDiscriminator(node, model.getDiscriminator());
            JsonUtil.booleanProperty(node, "nullable", model.getNullable());
            JsonUtil.booleanProperty(node, "writeOnly", model.getWriteOnly());
            JsonUtil.booleanProperty(node, "deprecated", model.getDeprecated());
            ExtensionWriter.writeExtensions(node, model);
        }
    }

    private static void writeSchemaList(ObjectNode parent, List<Schema> models, String propertyName) {
        if (models == null) {
            return;
        }
        ArrayNode schemasNode = parent.putArray(propertyName);
        for (Schema schema : models) {
            SchemaWriter.writeSchema(schemasNode.addObject(), schema);
        }
    }
}

