/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ModuleInfo;
import org.jboss.jandex.Type;

public class AugmentedIndexView
implements IndexView {
    private final IndexView index;

    public static AugmentedIndexView augment(IndexView index) {
        if (index instanceof AugmentedIndexView) {
            return (AugmentedIndexView)index;
        }
        return new AugmentedIndexView(index);
    }

    private AugmentedIndexView(IndexView index) {
        Index indexedNames;
        try {
            indexedNames = Index.of(Names.getIndexable());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.index = CompositeIndex.create((IndexView[])new IndexView[]{Objects.requireNonNull(index), indexedNames});
    }

    public ClassInfo getClass(Type type) {
        return this.index.getClassByName(TypeUtil.getName(Objects.requireNonNull(type)));
    }

    public boolean containsClass(Type type) {
        return this.getClass(Objects.requireNonNull(type)) != null;
    }

    public ClassInfo getClass(Class<?> klazz) {
        return this.index.getClassByName(DotName.createSimple((String)Objects.requireNonNull(klazz).getName()));
    }

    public Set<Type> interfaces(ClassInfo klass) {
        LinkedHashSet<Type> interfaces = new LinkedHashSet<Type>();
        for (Type type : klass.interfaceTypes()) {
            interfaces.add(type);
            if (!this.containsClass(type)) continue;
            interfaces.addAll(this.interfaces(this.getClass(type)));
        }
        return interfaces;
    }

    public Map<ClassInfo, Type> inheritanceChain(ClassInfo klazz, Type type) {
        LinkedHashMap<ClassInfo, Type> chain = new LinkedHashMap<ClassInfo, Type>();
        do {
            chain.put(klazz, type);
        } while ((type = klazz.superClassType()) != null && (klazz = this.index.getClassByName(TypeUtil.getName(type))) != null);
        return chain;
    }

    public Map<ClassInfo, MethodInfo> ancestry(MethodInfo method) {
        ClassInfo declaringClass = method.declaringClass();
        Type resourceType = Type.create((DotName)declaringClass.name(), (Type.Kind)Type.Kind.CLASS);
        Map<ClassInfo, Type> chain = this.inheritanceChain(declaringClass, resourceType);
        LinkedHashMap<ClassInfo, MethodInfo> ancestry = new LinkedHashMap<ClassInfo, MethodInfo>();
        for (ClassInfo classInfo : chain.keySet()) {
            if (!AugmentedIndexView.saveOverride(method, classInfo, ancestry)) {
                ancestry.put(classInfo, null);
            }
            for (Type ifaceType : this.interfaces(classInfo)) {
                ClassInfo iface;
                if (TypeUtil.knownJavaType(ifaceType.name()) || AugmentedIndexView.saveOverride(method, iface = this.getClass(ifaceType), ancestry)) continue;
                ancestry.put(iface, null);
            }
        }
        return ancestry;
    }

    private static boolean saveOverride(MethodInfo searchMethod, ClassInfo clazz, Map<ClassInfo, MethodInfo> results) {
        MethodInfo classMethod = clazz.method(searchMethod);
        if (classMethod != null && !classMethod.isSynthetic()) {
            results.put(clazz, classMethod);
            return true;
        }
        return false;
    }

    public Collection<ClassInfo> getKnownClasses() {
        return this.index.getKnownClasses();
    }

    public ClassInfo getClassByName(DotName className) {
        return this.index.getClassByName(Objects.requireNonNull(className));
    }

    public Collection<ClassInfo> getKnownDirectSubclasses(DotName className) {
        return this.index.getKnownDirectSubclasses(Objects.requireNonNull(className));
    }

    public Collection<ClassInfo> getAllKnownSubclasses(DotName className) {
        return this.index.getAllKnownSubclasses(Objects.requireNonNull(className));
    }

    public Collection<ClassInfo> getKnownDirectSubinterfaces(DotName interfaceName) {
        return this.index.getKnownDirectSubinterfaces(Objects.requireNonNull(interfaceName));
    }

    public Collection<ClassInfo> getAllKnownSubinterfaces(DotName interfaceName) {
        return this.index.getAllKnownSubinterfaces(Objects.requireNonNull(interfaceName));
    }

    public Collection<ClassInfo> getKnownDirectImplementors(DotName className) {
        return this.index.getKnownDirectImplementors(Objects.requireNonNull(className));
    }

    public Collection<ClassInfo> getAllKnownImplementors(DotName interfaceName) {
        return this.index.getAllKnownImplementors(Objects.requireNonNull(interfaceName));
    }

    public Collection<AnnotationInstance> getAnnotations(DotName annotationName) {
        return this.index.getAnnotations(Objects.requireNonNull(annotationName));
    }

    public Collection<AnnotationInstance> getAnnotationsWithRepeatable(DotName annotationName, IndexView annotationIndex) {
        Objects.requireNonNull(annotationName);
        Objects.requireNonNull(annotationIndex);
        return this.index.getAnnotationsWithRepeatable(annotationName, annotationIndex);
    }

    public Collection<ModuleInfo> getKnownModules() {
        return this.index.getKnownModules();
    }

    public ModuleInfo getModuleByName(DotName moduleName) {
        return this.index.getModuleByName(Objects.requireNonNull(moduleName));
    }

    public Collection<ClassInfo> getKnownUsers(DotName className) {
        return this.index.getKnownUsers(Objects.requireNonNull(className));
    }

    public Collection<ClassInfo> getClassesInPackage(DotName packageName) {
        return this.index.getClassesInPackage(Objects.requireNonNull(packageName));
    }

    public Set<DotName> getSubpackages(DotName packageName) {
        return this.index.getSubpackages(Objects.requireNonNull(packageName));
    }

    public Collection<ClassInfo> getAllKnownImplementations(DotName interfaceName) {
        return this.index.getAllKnownImplementations(Objects.requireNonNull(interfaceName));
    }

    public Collection<ClassInfo> getKnownDirectImplementations(DotName interfaceName) {
        return this.index.getKnownDirectImplementations(Objects.requireNonNull(interfaceName));
    }
}

