/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;

public class ResponseHeaderAttribute
implements ExchangeAttribute {
    private final HttpString responseHeader;

    public ResponseHeaderAttribute(HttpString responseHeader) {
        this.responseHeader = responseHeader;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        return exchange.getResponseHeaders().getFirst(this.responseHeader);
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        exchange.getResponseHeaders().put(this.responseHeader, newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Response header";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("%{o,") && token.endsWith("}")) {
                HttpString headerName = HttpString.tryFromString(token.substring(4, token.length() - 1));
                return new ResponseHeaderAttribute(headerName);
            }
            return null;
        }
    }
}

