/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.form;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;

public class EagerFormParsingHandler
implements HttpHandler {
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;
    private final FormParserFactory formParserFactory;

    public EagerFormParsingHandler(FormParserFactory formParserFactory) {
        this.formParserFactory = formParserFactory;
    }

    public EagerFormParsingHandler() {
        this.formParserFactory = FormParserFactory.builder().build();
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        FormDataParser parser = this.formParserFactory.createParser(exchange);
        if (parser == null) {
            this.next.handleRequest(exchange);
            return;
        }
        parser.parse(this.next);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public EagerFormParsingHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }
}

