/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ContainsPredicate
implements Predicate {
    private final ExchangeAttribute attribute;
    private final String[] values;

    ContainsPredicate(ExchangeAttribute attribute, String[] values) {
        this.attribute = attribute;
        this.values = new String[values.length];
        System.arraycopy(values, 0, this.values, 0, values.length);
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        String attr = this.attribute.readAttribute(value);
        if (attr == null) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!attr.contains(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "contains";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("value", ExchangeAttribute.class);
            params.put("search", String[].class);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            HashSet<String> params = new HashSet<String>();
            params.add("value");
            params.add("search");
            return params;
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            String[] search = (String[])config.get("search");
            ExchangeAttribute values = (ExchangeAttribute)config.get("value");
            return new ContainsPredicate(values, search);
        }
    }
}

