/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.protocol.http.HttpContinue;
import java.io.IOException;

public class HttpContinueAcceptingHandler
implements HttpHandler {
    private volatile HttpHandler next;

    public HttpContinueAcceptingHandler(HttpHandler next) {
        this.next = next;
    }

    public HttpContinueAcceptingHandler() {
        this(ResponseCodeHandler.HANDLE_404);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (HttpContinue.requiresContinueResponse(exchange)) {
            if (this.acceptRequest(exchange)) {
                HttpContinue.sendContinueResponse(exchange, new IoCallback(){

                    @Override
                    public void onComplete(HttpServerExchange exchange, Sender sender) {
                        exchange.dispatch(HttpContinueAcceptingHandler.this.next);
                    }

                    @Override
                    public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                        UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
                        exchange.endExchange();
                    }
                });
            } else {
                HttpContinue.rejectExchange(exchange);
            }
        } else {
            this.next.handleRequest(exchange);
        }
    }

    protected boolean acceptRequest(HttpServerExchange exchange) {
        return true;
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public HttpContinueAcceptingHandler setNext(HttpHandler next) {
        HttpHandlers.handlerNotNull(next);
        this.next = next;
        return this;
    }
}

