/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.ajp;

import io.undertow.channels.DetachableStreamSinkChannel;
import io.undertow.channels.DetachableStreamSourceChannel;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.ContinueNotification;
import io.undertow.client.ajp.AjpClientConnection;
import io.undertow.client.ajp.AjpClientRequestConduit;
import io.undertow.util.AbstractAttachable;
import io.undertow.util.Headers;
import java.io.IOException;
import org.xnio.Bits;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public class AjpClientExchange
extends AbstractAttachable
implements ClientExchange {
    private final ClientRequest request;
    private final boolean requiresContinue;
    private final AjpClientConnection clientConnection;
    private ClientCallback<ClientExchange> responseCallback;
    private ClientCallback<ClientExchange> readyCallback;
    private ContinueNotification continueNotification;
    private AjpClientRequestConduit ajpClientRequestConduit;
    private ClientResponse response;
    private ClientResponse continueResponse;
    private IOException failedReason;
    private int state = 0;
    private final int REQUEST_TERMINATED = 1;
    private final int RESPONSE_TERMINATED = 2;

    public AjpClientExchange(ClientCallback<ClientExchange> readyCallback, ClientRequest request, AjpClientConnection clientConnection) {
        this.readyCallback = readyCallback;
        this.request = request;
        this.clientConnection = clientConnection;
        boolean reqContinue = false;
        if (request.getRequestHeaders().contains(Headers.EXPECT)) {
            for (String header : request.getRequestHeaders().get(Headers.EXPECT)) {
                if (!header.equals("100-continue")) continue;
                reqContinue = true;
            }
        }
        this.requiresContinue = reqContinue;
    }

    void terminateRequest() {
        this.state |= 1;
        this.clientConnection.getConnection().getSinkChannel().suspendWrites();
        if (Bits.anyAreSet(this.state, 2)) {
            this.clientConnection.requestDone();
        }
    }

    void terminateResponse() {
        this.state |= 2;
        this.clientConnection.getConnection().getSourceChannel().suspendReads();
        if (Bits.anyAreSet(this.state, 1)) {
            this.clientConnection.requestDone();
        }
    }

    public boolean isRequiresContinue() {
        return this.requiresContinue;
    }

    void setContinueResponse(ClientResponse response) {
        this.continueResponse = response;
        if (this.continueNotification != null) {
            this.continueNotification.handleContinue(this);
        }
    }

    void setResponse(ClientResponse response) {
        this.response = response;
        if (this.responseCallback != null) {
            this.responseCallback.completed(this);
        }
    }

    @Override
    public void setResponseListener(ClientCallback<ClientExchange> listener) {
        this.responseCallback = listener;
        if (listener != null) {
            if (this.failedReason != null) {
                listener.failed(this.failedReason);
            } else if (this.response != null) {
                listener.completed(this);
            }
        }
    }

    @Override
    public void setContinueHandler(ContinueNotification continueHandler) {
        this.continueNotification = continueHandler;
    }

    void setFailed(IOException e) {
        this.failedReason = e;
        if (this.readyCallback != null) {
            this.readyCallback.failed(e);
            this.readyCallback = null;
        }
        if (this.responseCallback != null) {
            this.responseCallback.failed(e);
            this.responseCallback = null;
        }
    }

    @Override
    public StreamSinkChannel getRequestChannel() {
        return new DetachableStreamSinkChannel(this.clientConnection.getConnection().getSinkChannel()){

            @Override
            protected boolean isFinished() {
                return Bits.anyAreSet(AjpClientExchange.this.state, 1);
            }
        };
    }

    @Override
    public StreamSourceChannel getResponseChannel() {
        return new DetachableStreamSourceChannel(this.clientConnection.getConnection().getSourceChannel()){

            @Override
            protected boolean isFinished() {
                return Bits.anyAreSet(AjpClientExchange.this.state, 2);
            }
        };
    }

    @Override
    public ClientRequest getRequest() {
        return this.request;
    }

    @Override
    public ClientResponse getResponse() {
        return this.response;
    }

    @Override
    public ClientResponse getContinueResponse() {
        return this.continueResponse;
    }

    @Override
    public ClientConnection getConnection() {
        return this.clientConnection;
    }

    ClientCallback<ClientExchange> getReadyCallback() {
        return this.readyCallback;
    }

    public AjpClientRequestConduit getAjpClientRequestConduit() {
        return this.ajpClientRequestConduit;
    }

    public void setAjpClientRequestConduit(AjpClientRequestConduit ajpClientRequestConduit) {
        this.ajpClientRequestConduit = ajpClientRequestConduit;
    }
}

