/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;

public class SessionListeners {
    private final List<SessionListener> sessionListeners = new CopyOnWriteArrayList<SessionListener>();

    public void addSessionListener(SessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public boolean removeSessionListener(SessionListener listener) {
        return this.sessionListeners.remove(listener);
    }

    public void clear() {
        this.sessionListeners.clear();
    }

    public void sessionCreated(Session session, HttpServerExchange exchange) {
        for (SessionListener listener : this.sessionListeners) {
            listener.sessionCreated(session, exchange);
        }
    }

    public void sessionDestroyed(Session session, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
        ArrayList<SessionListener> listeners = new ArrayList<SessionListener>(this.sessionListeners);
        ListIterator iterator = listeners.listIterator(listeners.size());
        while (iterator.hasPrevious()) {
            ((SessionListener)iterator.previous()).sessionDestroyed(session, exchange, reason);
        }
    }

    public void attributeAdded(Session session, String name, Object value) {
        for (SessionListener listener : this.sessionListeners) {
            listener.attributeAdded(session, name, value);
        }
    }

    public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
        for (SessionListener listener : this.sessionListeners) {
            listener.attributeUpdated(session, name, newValue, oldValue);
        }
    }

    public void attributeRemoved(Session session, String name, Object oldValue) {
        for (SessionListener listener : this.sessionListeners) {
            listener.attributeRemoved(session, name, oldValue);
        }
    }

    public void sessionIdChanged(Session session, String oldSessionId) {
        for (SessionListener listener : this.sessionListeners) {
            listener.sessionIdChanged(session, oldSessionId);
        }
    }
}

