/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.servlet.api.InstanceHandle;
import io.undertow.websockets.api.FrameHandler;
import io.undertow.websockets.api.WebSocketSession;
import io.undertow.websockets.impl.WebSocketChannelSession;
import io.undertow.websockets.jsr.AbstractFrameHandler;
import io.undertow.websockets.jsr.Encoding;
import io.undertow.websockets.jsr.EndpointSessionHandler;
import io.undertow.websockets.jsr.MixedFrameHandler;
import io.undertow.websockets.jsr.PartialFrameHandler;
import io.undertow.websockets.jsr.WebSocketSessionRemoteEndpoint;
import io.undertow.websockets.jsr.WholeFrameHandler;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.Channel;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.MessageHandler;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.xnio.ChannelListener;

public final class UndertowSession
implements Session {
    private final WebSocketSession session;
    private final WebSocketContainer container;
    private final Principal user;
    private final WebSocketSessionRemoteEndpoint remote;
    private final Map<String, Object> attrs = new ConcurrentHashMap<String, Object>();
    private final Map<String, List<String>> requestParameterMap;
    private final URI requestUri;
    private final Map<String, String> pathParameters;
    private final InstanceHandle<Endpoint> endpoint;
    private final Encoding encoding;

    public UndertowSession(WebSocketChannelSession session, URI requestUri, Map<String, String> pathParameters, Map<String, List<String>> requestParameterMap, EndpointSessionHandler handler, Principal user, InstanceHandle<Endpoint> endpoint, EndpointConfig config, Encoding encoding) {
        this.session = session;
        this.encoding = encoding;
        this.container = handler.getContainer();
        this.user = user;
        this.requestUri = requestUri;
        this.requestParameterMap = Collections.unmodifiableMap(requestParameterMap);
        this.pathParameters = Collections.unmodifiableMap(pathParameters);
        this.remote = new WebSocketSessionRemoteEndpoint(session, config, encoding);
        session.setFrameHandler((FrameHandler)new WholeFrameHandler(this, (Endpoint)endpoint.getInstance()));
        this.endpoint = endpoint;
        session.getChannel().getCloseSetter().set((ChannelListener)new ChannelListener<Channel>(){

            public void handleEvent(Channel channel) {
                UndertowSession.this.close0();
            }
        });
    }

    public WebSocketContainer getContainer() {
        return this.container;
    }

    public synchronized void addMessageHandler(MessageHandler messageHandler) throws IllegalStateException {
        AbstractFrameHandler handler = (AbstractFrameHandler)this.session.getFrameHandler();
        if (messageHandler instanceof MessageHandler.Whole) {
            if (handler instanceof WholeFrameHandler) {
                handler.addHandler(messageHandler);
            } else if (handler.getHandlers().isEmpty()) {
                handler = new WholeFrameHandler(this, (Endpoint)this.endpoint.getInstance());
                handler.addHandler(messageHandler);
                this.session.setFrameHandler((FrameHandler)handler);
            } else {
                this.switchToMixed(handler, messageHandler);
            }
        } else if (messageHandler instanceof MessageHandler.Partial) {
            if (handler instanceof PartialFrameHandler) {
                handler.addHandler(messageHandler);
            } else if (handler.getHandlers().isEmpty()) {
                handler = new PartialFrameHandler(this, (Endpoint)this.endpoint.getInstance());
                handler.addHandler(messageHandler);
                this.session.setFrameHandler((FrameHandler)handler);
            } else {
                this.switchToMixed(handler, messageHandler);
            }
        }
    }

    private void switchToMixed(AbstractFrameHandler handler, MessageHandler messageHandler) {
        Set<MessageHandler> handlers = handler.getHandlers();
        handler = new MixedFrameHandler(this, (Endpoint)this.endpoint.getInstance());
        for (MessageHandler h : handlers) {
            handler.addHandler(h);
        }
        handler.addHandler(messageHandler);
        this.session.setFrameHandler((FrameHandler)handler);
    }

    public synchronized Set<MessageHandler> getMessageHandlers() {
        return ((AbstractFrameHandler)this.session.getFrameHandler()).getHandlers();
    }

    public synchronized void removeMessageHandler(MessageHandler messageHandler) {
        AbstractFrameHandler handler = (AbstractFrameHandler)this.session.getFrameHandler();
        handler.removeHandler(messageHandler);
        if (handler instanceof MixedFrameHandler) {
            Set<MessageHandler> handlers = handler.getHandlers();
            boolean basic = false;
            boolean async = false;
            for (MessageHandler h : handlers) {
                if (h instanceof MessageHandler.Partial) {
                    async = true;
                } else if (h instanceof MessageHandler.Whole) {
                    basic = true;
                }
                if (!basic || !async) continue;
                return;
            }
            if (basic) {
                handler = new WholeFrameHandler(this, (Endpoint)this.endpoint.getInstance());
            } else if (async) {
                handler = new PartialFrameHandler(this, (Endpoint)this.endpoint.getInstance());
            }
            for (MessageHandler h : handlers) {
                handler.addHandler(h);
            }
            this.session.setFrameHandler((FrameHandler)handler);
        }
    }

    public void setFrameHandler(FrameHandler handler) {
        this.session.setFrameHandler(handler);
    }

    public String getProtocolVersion() {
        return this.session.getProtocolVersion();
    }

    public String getNegotiatedSubprotocol() {
        return null;
    }

    public boolean isSecure() {
        return this.session.isSecure();
    }

    public boolean isOpen() {
        return this.session.isOpen();
    }

    public long getMaxIdleTimeout() {
        return 0L;
    }

    public void setMaxIdleTimeout(long milliseconds) {
    }

    public String getId() {
        return this.session.getId();
    }

    public void close() throws IOException {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(CloseReason closeReason) throws IOException {
        try {
            ((Endpoint)this.endpoint.getInstance()).onClose((Session)this, closeReason);
            if (closeReason == null) {
                this.session.sendClose(null);
            } else {
                this.session.sendClose(new io.undertow.websockets.api.CloseReason(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase()));
            }
        }
        finally {
            this.close0();
        }
    }

    public URI getRequestURI() {
        return this.requestUri;
    }

    public Map<String, List<String>> getRequestParameterMap() {
        return this.requestParameterMap;
    }

    public String getQueryString() {
        return this.requestUri.getQuery();
    }

    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    public Map<String, Object> getUserProperties() {
        return this.attrs;
    }

    public Principal getUserPrincipal() {
        return this.user;
    }

    public void setMaxBinaryMessageBufferSize(int i) {
        this.session.setMaximumBinaryFrameSize((long)i);
    }

    public int getMaxBinaryMessageBufferSize() {
        return (int)this.session.getMaximumBinaryFrameSize();
    }

    public void setMaxTextMessageBufferSize(int i) {
        this.session.setMaximumTextFrameSize((long)i);
    }

    public int getMaxTextMessageBufferSize() {
        return (int)this.session.getMaximumTextFrameSize();
    }

    public RemoteEndpoint.Async getAsyncRemote() {
        return this.remote.getAsync();
    }

    public RemoteEndpoint.Basic getBasicRemote() {
        return this.remote.getBasic();
    }

    public Set<Session> getOpenSessions() {
        return Collections.emptySet();
    }

    public List<Extension> getNegotiatedExtensions() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close0() {
        try {
            this.endpoint.release();
        }
        finally {
            this.encoding.close();
        }
    }

    public Encoding getEncoding() {
        return this.encoding;
    }
}

