/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.api.AssembledFrameHandler;
import io.undertow.websockets.api.WebSocketFrameHeader;
import io.undertow.websockets.api.WebSocketSession;
import io.undertow.websockets.jsr.AbstractFrameHandler;
import io.undertow.websockets.jsr.DefaultPongMessage;
import io.undertow.websockets.jsr.UndertowSession;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.websocket.Endpoint;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import org.xnio.Buffers;

final class WholeFrameHandler
extends AbstractFrameHandler<MessageHandler.Whole<?>>
implements AssembledFrameHandler {
    public WholeFrameHandler(UndertowSession session, Endpoint endpoint) {
        super(session, endpoint);
    }

    public void onTextFrame(WebSocketSession s, WebSocketFrameHeader header, CharSequence payload) {
        AbstractFrameHandler.HandlerWrapper handler = this.getHandler(AbstractFrameHandler.FrameType.TEXT);
        if (handler != null) {
            ((MessageHandler.Whole)handler.getHandler()).onMessage((Object)payload.toString());
        }
    }

    public void onBinaryFrame(WebSocketSession s, WebSocketFrameHeader header, ByteBuffer ... payload) {
        AbstractFrameHandler.HandlerWrapper handler = this.getHandler(AbstractFrameHandler.FrameType.BYTE);
        if (handler != null) {
            MessageHandler.Whole mHandler = (MessageHandler.Whole)handler.getHandler();
            if (handler.getMessageType() == ByteBuffer.class) {
                mHandler.onMessage((Object)WholeFrameHandler.toBuffer(payload));
            }
            if (handler.getMessageType() == byte[].class) {
                long size = Buffers.remaining((Buffer[])payload);
                if (size == 0L) {
                    mHandler.onMessage((Object)EMPTY);
                } else {
                    byte[] data = WholeFrameHandler.toArray(payload);
                    mHandler.onMessage((Object)data);
                }
            }
        }
    }

    @Override
    public void onPongFrame(WebSocketSession s, ByteBuffer ... payload) {
        AbstractFrameHandler.HandlerWrapper handler = this.getHandler(AbstractFrameHandler.FrameType.PONG);
        if (handler != null) {
            PongMessage message = payload.length == 1 ? DefaultPongMessage.create(payload[0]) : DefaultPongMessage.create(WholeFrameHandler.toBuffer(payload));
            ((MessageHandler.Whole)handler.getHandler()).onMessage((Object)message);
        }
    }
}

