/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.annotated;

import io.undertow.servlet.api.InstanceHandle;
import io.undertow.websockets.api.FragmentedFrameHandler;
import io.undertow.websockets.api.FrameHandler;
import io.undertow.websockets.api.WebSocketFrameHeader;
import io.undertow.websockets.api.WebSocketSession;
import io.undertow.websockets.jsr.DefaultPongMessage;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.UTF8Output;
import io.undertow.websockets.jsr.UndertowSession;
import io.undertow.websockets.jsr.annotated.BoundMethod;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.websocket.CloseReason;
import javax.websocket.DecodeException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.PongMessage;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import org.xnio.Buffers;

public class AnnotatedEndpoint
extends Endpoint {
    private final InstanceHandle<?> instance;
    private final BoundMethod webSocketOpen;
    private final BoundMethod webSocketClose;
    private final BoundMethod webSocketError;
    private final BoundMethod textMessage;
    private final BoundMethod binaryMessage;
    private final BoundMethod pongMessage;

    AnnotatedEndpoint(InstanceHandle<?> instance, BoundMethod webSocketOpen, BoundMethod webSocketClose, BoundMethod webSocketError, BoundMethod textMessage, BoundMethod binaryMessage, BoundMethod pongMessage) {
        this.instance = instance;
        this.webSocketOpen = webSocketOpen;
        this.webSocketClose = webSocketClose;
        this.webSocketError = webSocketError;
        this.textMessage = textMessage;
        this.binaryMessage = binaryMessage;
        this.pongMessage = pongMessage;
    }

    public void onOpen(Session session, EndpointConfig endpointConfiguration) {
        UndertowSession s = (UndertowSession)session;
        s.setFrameHandler((FrameHandler)new AnnotatedEndpointFrameHandler((UndertowSession)session));
        if (this.webSocketOpen != null) {
            HashMap params = new HashMap();
            params.put(Session.class, session);
            params.put(EndpointConfig.class, endpointConfiguration);
            params.put(Map.class, session.getPathParameters());
            this.webSocketOpen.invoke(this.instance.getInstance(), params);
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        if (this.webSocketClose != null) {
            HashMap params = new HashMap();
            params.put(Session.class, session);
            params.put(Map.class, session.getPathParameters());
            this.webSocketClose.invoke(this.instance.getInstance(), params);
        }
    }

    public void onError(Session session, Throwable thr) {
        if (this.webSocketError != null) {
            HashMap params = new HashMap();
            params.put(Session.class, session);
            params.put(Throwable.class, thr);
            params.put(Map.class, session.getPathParameters());
            this.webSocketError.invoke(this.instance.getInstance(), params);
        }
    }

    private class AnnotatedEndpointFrameHandler
    implements FragmentedFrameHandler {
        private final UndertowSession session;
        private UTF8Output assembledTextFrame;
        private ByteArrayOutputStream assembledBinaryFrame;
        private final SendHandler errorReportingSendHandler = new SendHandler(){

            public void onResult(SendResult result) {
                if (!result.isOK()) {
                    AnnotatedEndpointFrameHandler.this.onError(null, result.getException());
                }
            }
        };

        public AnnotatedEndpointFrameHandler(UndertowSession session) {
            this.session = session;
        }

        public void onCloseFrame(WebSocketSession s, io.undertow.websockets.api.CloseReason reason) {
            if (AnnotatedEndpoint.this.webSocketClose == null) {
                return;
            }
            try {
                HashMap params = new HashMap();
                params.put(Session.class, this.session);
                params.put(Map.class, this.session.getPathParameters());
                AnnotatedEndpoint.this.webSocketClose.invoke(AnnotatedEndpoint.this.instance.getInstance(), params);
            }
            catch (Exception e) {
                this.onError(s, e);
            }
        }

        public void onPingFrame(WebSocketSession s, ByteBuffer ... payload) {
        }

        public void onPongFrame(WebSocketSession s, ByteBuffer ... payload) {
            PongMessage message;
            if (AnnotatedEndpoint.this.pongMessage == null) {
                return;
            }
            if (payload.length == 1) {
                message = DefaultPongMessage.create(payload[0]);
            } else {
                int count = 0;
                for (ByteBuffer b : payload) {
                    count += b.remaining();
                }
                ByteBuffer data = ByteBuffer.allocate(count);
                Buffers.copy((ByteBuffer)data, (ByteBuffer[])payload, (int)0, (int)payload.length);
                message = DefaultPongMessage.create(data);
            }
            try {
                HashMap params = new HashMap();
                params.put(Session.class, this.session);
                params.put(Map.class, this.session.getPathParameters());
                params.put(PongMessage.class, message);
                AnnotatedEndpoint.this.pongMessage.invoke(AnnotatedEndpoint.this.instance.getInstance(), params);
            }
            catch (Exception e) {
                this.onError(s, e);
            }
        }

        public void onError(WebSocketSession s, Throwable cause) {
            if (AnnotatedEndpoint.this.webSocketError == null) {
                return;
            }
            HashMap params = new HashMap();
            params.put(Session.class, this.session);
            params.put(Map.class, this.session.getPathParameters());
            params.put(Throwable.class, cause);
            AnnotatedEndpoint.this.webSocketError.invoke(AnnotatedEndpoint.this.instance.getInstance(), params);
        }

        public void onTextFrame(WebSocketSession s, WebSocketFrameHeader header, ByteBuffer ... payload) {
            if (AnnotatedEndpoint.this.textMessage == null) {
                this.onError(s, JsrWebSocketMessages.MESSAGES.receivedTextFrameButNoMethod());
                return;
            }
            if (this.assembledTextFrame == null) {
                this.assembledTextFrame = new UTF8Output(new ByteBuffer[0]);
            }
            UTF8Output builder = this.assembledTextFrame;
            builder.write(payload);
            if (header.isLastFragement() || AnnotatedEndpoint.this.textMessage.hasParameterType(Boolean.TYPE) && !AnnotatedEndpoint.this.textMessage.isDecoderRequired() && builder.hasData()) {
                Object messageObject;
                if (AnnotatedEndpoint.this.textMessage.isDecoderRequired()) {
                    try {
                        messageObject = this.session.getEncoding().decodeText(AnnotatedEndpoint.this.textMessage.getMessageType(), builder.extract());
                    }
                    catch (DecodeException e) {
                        this.onError(s, e);
                        return;
                    }
                } else {
                    messageObject = builder.extract();
                }
                HashMap params = new HashMap();
                params.put(Session.class, this.session);
                params.put(Map.class, this.session.getPathParameters());
                params.put(AnnotatedEndpoint.this.textMessage.getMessageType(), messageObject);
                params.put(Boolean.TYPE, header.isLastFragement());
                Object result = AnnotatedEndpoint.this.textMessage.invoke(AnnotatedEndpoint.this.instance.getInstance(), params);
                this.assembledTextFrame = null;
                this.sendResult(result);
            }
        }

        private void sendResult(Object result) {
            if (result != null) {
                if (result instanceof String) {
                    this.session.getAsyncRemote().sendText((String)result, this.errorReportingSendHandler);
                } else if (result instanceof byte[]) {
                    this.session.getAsyncRemote().sendBinary(ByteBuffer.wrap((byte[])result), this.errorReportingSendHandler);
                } else if (result instanceof ByteBuffer) {
                    this.session.getAsyncRemote().sendBinary((ByteBuffer)result, this.errorReportingSendHandler);
                } else {
                    this.session.getAsyncRemote().sendObject(result, this.errorReportingSendHandler);
                }
            }
        }

        public void onBinaryFrame(WebSocketSession s, WebSocketFrameHeader header, ByteBuffer ... payload) {
            if (AnnotatedEndpoint.this.binaryMessage == null) {
                this.onError(s, JsrWebSocketMessages.MESSAGES.receivedBinaryFrameButNoMethod());
                return;
            }
            boolean allowPartial = AnnotatedEndpoint.this.binaryMessage.hasParameterType(Boolean.TYPE);
            if (AnnotatedEndpoint.this.binaryMessage.getMessageType() == ByteBuffer.class && (allowPartial || payload.length == 1 && header.isLastFragement() && this.assembledBinaryFrame == null)) {
                HashMap params = new HashMap();
                params.put(Session.class, this.session);
                params.put(Map.class, this.session.getPathParameters());
                Object result = null;
                for (int i = 0; i < payload.length; ++i) {
                    params.put(ByteBuffer.class, payload);
                    params.put(Boolean.TYPE, header.isLastFragement() && i == payload.length - 1);
                    result = AnnotatedEndpoint.this.binaryMessage.invoke(AnnotatedEndpoint.this.instance.getInstance(), params);
                    this.sendResult(result);
                }
            } else {
                if (this.assembledBinaryFrame == null) {
                    this.assembledBinaryFrame = new ByteArrayOutputStream();
                }
                ByteArrayOutputStream builder = this.assembledBinaryFrame;
                for (ByteBuffer buf : payload) {
                    while (buf.hasRemaining()) {
                        builder.write(buf.get());
                    }
                }
                if (header.isLastFragement() || AnnotatedEndpoint.this.binaryMessage.hasParameterType(Boolean.TYPE)) {
                    HashMap params = new HashMap();
                    params.put(Session.class, this.session);
                    params.put(Map.class, this.session.getPathParameters());
                    if (AnnotatedEndpoint.this.binaryMessage.isDecoderRequired()) {
                        try {
                            params.put(AnnotatedEndpoint.this.binaryMessage.getMessageType(), this.session.getEncoding().decodeBinary(AnnotatedEndpoint.this.binaryMessage.getMessageType(), this.assembledBinaryFrame.toByteArray()));
                        }
                        catch (DecodeException e) {
                            this.onError(s, e);
                            return;
                        }
                    } else if (AnnotatedEndpoint.this.binaryMessage.getMessageType() == ByteBuffer.class) {
                        params.put(ByteBuffer.class, ByteBuffer.wrap(this.assembledBinaryFrame.toByteArray()));
                    } else if (AnnotatedEndpoint.this.binaryMessage.getMessageType() == byte[].class) {
                        params.put(byte[].class, this.assembledBinaryFrame.toByteArray());
                    } else {
                        throw new RuntimeException("decoders are not implemented yet");
                    }
                    params.put(Boolean.TYPE, header.isLastFragement());
                    Object result = AnnotatedEndpoint.this.binaryMessage.invoke(AnnotatedEndpoint.this.instance.getInstance(), params);
                    this.assembledBinaryFrame = null;
                    this.sendResult(result);
                }
            }
        }
    }
}

