/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.benchmarks;

import io.netty.util.CharsetUtil;
import io.vertx.benchmarks.BenchmarkBase;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Thread)
public class JsonDecodeBenchmark
extends BenchmarkBase {
    private Buffer small;
    private Buffer large;

    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public static void consume(JsonObject jsonObject) {
    }

    @Setup
    public void setup() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.small = this.loadJsonAsBuffer(classLoader.getResource("small.json"));
        this.large = this.loadJsonAsBuffer(classLoader.getResource("large.json"));
    }

    private Buffer loadJsonAsBuffer(URL url) {
        try {
            Buffer encoded = new JsonObject((Map)Json.mapper.readValue(url, Map.class)).toBuffer();
            return Buffer.buffer().appendInt(encoded.length()).appendBuffer(encoded);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Benchmark
    public void viaStringSmall() throws Exception {
        this.viaString(this.small);
    }

    @Benchmark
    public void viaStringLarge() throws Exception {
        this.viaString(this.large);
    }

    private void viaString(Buffer buffer) throws Exception {
        int pos = 0;
        int length = buffer.getInt(pos);
        byte[] encoded = buffer.getBytes(pos += 4, pos + length);
        String str = new String(encoded, CharsetUtil.UTF_8);
        JsonDecodeBenchmark.consume(new JsonObject(str));
    }

    @Benchmark
    public void directSmall() throws Exception {
        this.direct(this.small);
    }

    @Benchmark
    public void directLarge() throws Exception {
        this.direct(this.large);
    }

    private void direct(Buffer buffer) throws Exception {
        int pos = 0;
        int length = buffer.getInt(pos);
        JsonDecodeBenchmark.consume(new JsonObject(buffer.slice(pos += 4, pos + length)));
    }
}

