/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.benchmarks;

import io.netty.util.CharsetUtil;
import io.vertx.benchmarks.BenchmarkBase;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Thread)
public class JsonEncodeBenchmark
extends BenchmarkBase {
    private JsonObject small;
    private JsonObject large;

    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public static void consume(Buffer buffer) {
    }

    @Setup
    public void setup() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.small = this.loadJson(classLoader.getResource("small.json"));
        this.large = this.loadJson(classLoader.getResource("large.json"));
    }

    private JsonObject loadJson(URL url) {
        try {
            return new JsonObject((Map)Json.mapper.readValue(url, Map.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Benchmark
    public void viaStringSmall() throws Exception {
        this.viaString(this.small);
    }

    @Benchmark
    public void viaStringLarge() throws Exception {
        this.viaString(this.large);
    }

    private void viaString(JsonObject jsonObject) throws Exception {
        Buffer buffer = Buffer.buffer();
        String strJson = jsonObject.encode();
        byte[] encoded = strJson.getBytes(CharsetUtil.UTF_8);
        buffer.appendInt(encoded.length);
        Buffer buff = Buffer.buffer((byte[])encoded);
        buffer.appendBuffer(buff);
        JsonEncodeBenchmark.consume(buffer);
    }

    @Benchmark
    public void directSmall() throws Exception {
        this.direct(this.small);
    }

    @Benchmark
    public void directLarge() throws Exception {
        this.direct(this.large);
    }

    private void direct(JsonObject jsonObject) throws Exception {
        Buffer buffer = Buffer.buffer();
        Buffer encoded = jsonObject.toBuffer();
        buffer.appendInt(encoded.length());
        buffer.appendBuffer(encoded);
        JsonEncodeBenchmark.consume(buffer);
    }
}

