/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.cli.converters;

import io.vertx.core.cli.converters.BooleanConverter;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class BooleanConverterTest {
    private BooleanConverter converter = BooleanConverter.INSTANCE;

    @Test
    public void testYesNo() throws Exception {
        Assertions.assertThat((Boolean)this.converter.fromString("yes")).isTrue();
        Assertions.assertThat((Boolean)this.converter.fromString("YeS")).isTrue();
        Assertions.assertThat((Boolean)this.converter.fromString("no")).isFalse();
        Assertions.assertThat((Boolean)this.converter.fromString("nO")).isFalse();
    }

    @Test
    public void testOnOff() throws Exception {
        Assertions.assertThat((Boolean)this.converter.fromString("on")).isTrue();
        Assertions.assertThat((Boolean)this.converter.fromString("ON")).isTrue();
        Assertions.assertThat((Boolean)this.converter.fromString("off")).isFalse();
        Assertions.assertThat((Boolean)this.converter.fromString("oFf")).isFalse();
    }

    @Test
    public void testTrueFalse() throws Exception {
        Assertions.assertThat((Boolean)this.converter.fromString("true")).isTrue();
        Assertions.assertThat((Boolean)this.converter.fromString("TruE")).isTrue();
        Assertions.assertThat((Boolean)this.converter.fromString("fALse")).isFalse();
        Assertions.assertThat((Boolean)this.converter.fromString("false")).isFalse();
    }

    @Test
    public void testNumbers() throws Exception {
        Assertions.assertThat((Boolean)this.converter.fromString("1")).isTrue();
        Assertions.assertThat((Boolean)this.converter.fromString("2")).isFalse();
        Assertions.assertThat((Boolean)this.converter.fromString("0")).isFalse();
    }

    @Test
    public void testWithNullAndEmptyString() throws Exception {
        Assertions.assertThat((Boolean)this.converter.fromString(null)).isFalse();
        Assertions.assertThat((Boolean)this.converter.fromString("")).isFalse();
    }

    @Test
    public void testWithRandomString() throws Exception {
        Assertions.assertThat((Boolean)this.converter.fromString("aaaa")).isFalse();
        Assertions.assertThat((Boolean)this.converter.fromString("welcome true")).isFalse();
        Assertions.assertThat((Boolean)this.converter.fromString("true welcome")).isFalse();
    }
}

