/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.cli.impl;

import io.vertx.core.cli.Argument;
import io.vertx.core.cli.CLI;
import io.vertx.core.cli.CommandLine;
import io.vertx.core.cli.MissingValueException;
import io.vertx.core.cli.Option;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class DefaultCLITest {
    @Test
    public void testFlag() {
        CLI cli = CLI.create((String)"test").addOption(new Option().setShortName("f").setFlag(true)).addOption(new Option().setShortName("x"));
        CommandLine evaluated = cli.parse(Arrays.asList("-f", "-x", "foo"));
        Assertions.assertThat((boolean)evaluated.isFlagEnabled("f")).isTrue();
        Assertions.assertThat((String)((String)evaluated.getOptionValue("x"))).isEqualToIgnoringCase((CharSequence)"foo");
    }

    @Test
    public void testMissingFlag() {
        CLI cli = CLI.create((String)"test").addOption(new Option().setShortName("f").setFlag(true)).addOption(new Option().setShortName("x"));
        CommandLine evaluated = cli.parse(Arrays.asList("-x", "foo"));
        Assertions.assertThat((boolean)evaluated.isFlagEnabled("f")).isFalse();
        Assertions.assertThat((String)((String)evaluated.getOptionValue("x"))).isEqualToIgnoringCase((CharSequence)"foo");
    }

    @Test
    public void testUsageComputationWhenUsingOnlyFlagShortOption() {
        CLI cli = CLI.create((String)"test").addOption(new Option().setShortName("f").setDescription("turn on/off").setFlag(true));
        StringBuilder builder = new StringBuilder();
        cli.usage(builder);
        Assertions.assertThat((CharSequence)builder).contains(new CharSequence[]{"test [-f]"}).contains(new CharSequence[]{"Options and Arguments"}).contains(new CharSequence[]{" -f   turn on/off"});
    }

    @Test
    public void testUsageWhenNoArgsAndOptions() {
        CLI cli = CLI.create((String)"test").setDescription("A simple test command.");
        StringBuilder builder = new StringBuilder();
        cli.usage(builder);
        Assertions.assertThat((CharSequence)builder).contains(new CharSequence[]{"test"}).doesNotContain((CharSequence)"Options").doesNotContain((CharSequence)"Arguments");
    }

    @Test
    public void testUsageComputationWhenUsingOnlyFlagLongOption() {
        CLI cli = CLI.create((String)"test").addOption(new Option().setLongName("flag").setDescription("turn on/off").setFlag(true));
        StringBuilder builder = new StringBuilder();
        cli.usage(builder);
        Assertions.assertThat((CharSequence)builder).contains(new CharSequence[]{"test [--flag]"}).contains(new CharSequence[]{" --flag   turn on/off"});
    }

    @Test
    public void testUsageComputationWhenUsingShortAndLongFlagOption() {
        CLI cli = CLI.create((String)"test").addOption(new Option().setLongName("flag").setShortName("f").setDescription("turn on/off").setFlag(true));
        StringBuilder builder = new StringBuilder();
        cli.usage(builder);
        Assertions.assertThat((CharSequence)builder).contains(new CharSequence[]{"test [-f]"}).contains(new CharSequence[]{" -f,--flag   turn on/off"});
    }

    @Test
    public void testUsageComputationWhenUsingShortAndLongOption() {
        CLI cli = CLI.create((String)"test").addOption(new Option().setLongName("file").setShortName("f").setDescription("a file"));
        StringBuilder builder = new StringBuilder();
        cli.usage(builder);
        Assertions.assertThat((CharSequence)builder).contains(new CharSequence[]{"test [-f <value>]"}).contains(new CharSequence[]{" -f,--file <value>   a file"});
    }

    @Test
    public void testUsageComputationWhenUsingOnlyShortOption() {
        CLI cli = CLI.create((String)"test").addOption(new Option().setShortName("f").setDescription("a file"));
        StringBuilder builder = new StringBuilder();
        cli.usage(builder);
        Assertions.assertThat((CharSequence)builder).contains(new CharSequence[]{"test [-f <value>]"}).contains(new CharSequence[]{" -f <value>   a file"});
    }

    @Test
    public void testUsageComputationWhenUsingOnlyLongOption() {
        CLI cli = CLI.create((String)"test").addOption(new Option().setLongName("file").setDescription("a file"));
        StringBuilder builder = new StringBuilder();
        cli.usage(builder);
        Assertions.assertThat((CharSequence)builder).contains(new CharSequence[]{"test [--file <value>]"}).contains(new CharSequence[]{" --file <value>   a file"});
    }

    @Test
    public void testUsageComputationWhenUsingRequiredOptionAndArgument() {
        CLI cli = CLI.create((String)"test").addOption(new Option().setLongName("file").setShortName("f").setDescription("a file").setRequired(true)).addArgument(new Argument().setArgName("foo").setDescription("foo").setRequired(true));
        StringBuilder builder = new StringBuilder();
        cli.usage(builder);
        Assertions.assertThat((CharSequence)builder).contains(new CharSequence[]{"test -f <value> foo"}).contains(new CharSequence[]{" -f,--file <value>   a file"}).contains(new CharSequence[]{"<foo>               foo"});
    }

    @Test
    public void testUsageComputationWithSeveralArguments() {
        CLI cli = CLI.create((String)"test").addOption(new Option().setLongName("file").setShortName("f").setDescription("a file").setRequired(true)).addArgument(new Argument().setIndex(0).setArgName("foo").setDescription("foo")).addArgument(new Argument().setIndex(1)).addArgument(new Argument().setIndex(2).setArgName("bar").setDescription("bar"));
        StringBuilder builder = new StringBuilder();
        cli.usage(builder);
        Assertions.assertThat((CharSequence)builder).contains(new CharSequence[]{"test -f <value> foo value bar"}).contains(new CharSequence[]{" -f,--file <value>   a file"}).contains(new CharSequence[]{"<foo>               foo"}).contains(new CharSequence[]{"<value>"}).contains(new CharSequence[]{"<bar>               bar"});
    }

    @Test
    public void testUsageComputationWithHiddenArguments() {
        CLI cli = CLI.create((String)"test").addOption(new Option().setLongName("file").setShortName("f").setDescription("a file").setRequired(true)).addArgument(new Argument().setIndex(0).setArgName("foo").setDescription("foo")).addArgument(new Argument().setIndex(1)).addArgument(new Argument().setIndex(2).setArgName("bar").setDescription("bar").setHidden(true));
        StringBuilder builder = new StringBuilder();
        cli.usage(builder);
        Assertions.assertThat((CharSequence)builder).contains(new CharSequence[]{"test -f <value> foo value"}).contains(new CharSequence[]{" -f,--file <value>   a file"}).contains(new CharSequence[]{"<foo>               foo"}).contains(new CharSequence[]{"<value>"}).doesNotContain((CharSequence)"bar");
    }

    @Test
    public void testUsageComputationWhenUsingNotRequiredArgument() {
        CLI cli = CLI.create((String)"test").addArgument(new Argument().setArgName("foo").setRequired(false));
        StringBuilder builder = new StringBuilder();
        cli.usage(builder);
        Assertions.assertThat((CharSequence)builder).contains(new CharSequence[]{"test [foo]"});
    }

    @Test
    public void testCommandLineValidationWhenValid() {
        CLI cli = CLI.create((String)"test").addArgument(new Argument().setArgName("foo").setRequired(true));
        CommandLine commandLine = cli.parse(Collections.singletonList("foo"));
        Assertions.assertThat((boolean)commandLine.isValid()).isTrue();
    }

    @Test(expected=MissingValueException.class)
    public void testCommandLineValidationWhenInvalid() {
        CLI cli = CLI.create((String)"test").addArgument(new Argument().setArgName("foo").setRequired(true));
        cli.parse(Collections.emptyList());
    }

    @Test
    public void testCommandLineValidationWhenInvalidWithValidationDisabled() {
        CLI cli = CLI.create((String)"test").addArgument(new Argument().setArgName("foo").setRequired(true));
        CommandLine commandLine = cli.parse(Collections.emptyList(), false);
        Assertions.assertThat((boolean)commandLine.isValid()).isEqualTo(false);
    }
}

