/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.cli.impl;

import io.vertx.core.cli.AmbiguousOptionException;
import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.CommandLine;
import io.vertx.core.cli.InvalidValueException;
import io.vertx.core.cli.MissingOptionException;
import io.vertx.core.cli.MissingValueException;
import io.vertx.core.cli.Option;
import io.vertx.core.cli.TypedOption;
import io.vertx.core.cli.impl.DefaultCLI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class IntensiveDefaultParserTest {
    private DefaultCLI cli;

    @Before
    public void setUp() {
        this.cli = new DefaultCLI();
        this.cli.setName("test").setHidden(false).setDescription("A test command");
        this.cli.addOption((Option)new TypedOption().setType(Boolean.class).setShortName("a").setLongName("enable-a").setFlag(true).setDescription("turn [a] on or off"));
        this.cli.addOption((Option)new TypedOption().setType(String.class).setShortName("b").setLongName("bfile").setSingleValued(true).setDescription("set the value of [b]"));
        this.cli.addOption((Option)new TypedOption().setType(Boolean.class).setShortName("c").setLongName("copt").setSingleValued(false).setDescription("turn [c] on or off"));
    }

    private boolean getBooleanOption(CommandLine evaluatedCLI, String name) {
        return (Boolean)evaluatedCLI.getOptionValue(name);
    }

    private String getStringOption(CommandLine evaluatedCLI, String name) {
        return (String)evaluatedCLI.getOptionValue(name);
    }

    @Test
    public void testSimpleShort() throws Exception {
        String[] args = new String[]{"-a", "-b", "toast", "foo", "bar"};
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((boolean)this.getBooleanOption(evaluated, "a")).isTrue();
        Assertions.assertThat((String)this.getStringOption(evaluated, "b")).isEqualTo((Object)"toast");
        Assertions.assertThat((boolean)this.getBooleanOption(evaluated, "c")).isFalse();
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).contains((Object[])new String[]{"foo", "bar"})).hasSize(2);
    }

    @Test
    public void testSimpleLong() throws Exception {
        String[] args = new String[]{"--enable-a", "--bfile", "toast", "foo", "bar"};
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((boolean)this.getBooleanOption(evaluated, "a")).isTrue();
        Assertions.assertThat((String)this.getStringOption(evaluated, "b")).isEqualTo((Object)"toast");
        Assertions.assertThat((String)this.getStringOption(evaluated, "bfile")).isEqualTo((Object)"toast");
        Assertions.assertThat((boolean)this.getBooleanOption(evaluated, "c")).isFalse();
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).contains((Object[])new String[]{"foo", "bar"})).hasSize(2);
    }

    @Test
    public void testArgumentsInTheMiddle() throws Exception {
        String[] args = new String[]{"-c", "foobar", "-b", "toast"};
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((boolean)this.getBooleanOption(evaluated, "c")).isTrue();
        Assertions.assertThat((String)this.getStringOption(evaluated, "b")).isEqualTo((Object)"toast");
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).contains((Object[])new String[]{"foobar"})).hasSize(1);
    }

    @Test
    public void testUnrecognizedOption() throws Exception {
        String[] args = new String[]{"-a", "-d", "-b", "toast", "foo", "bar"};
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).contains((Object[])new String[]{"-d", "foo", "bar"})).hasSize(3);
    }

    @Test
    public void testMissingValue() throws Exception {
        String[] args = new String[]{"-b"};
        try {
            CommandLine evaluated = this.cli.parse(Arrays.asList(args));
            Assertions.fail((String)"Exception expected");
        }
        catch (MissingValueException e) {
            Assertions.assertThat((String)e.getOption().getShortName()).isEqualToIgnoringCase((CharSequence)"b");
        }
    }

    @Test
    public void testDoubleDash1() throws Exception {
        String[] args = new String[]{"--copt", "--", "-b", "toast"};
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((boolean)this.getBooleanOption(evaluated, "c")).isTrue();
        Assertions.assertThat((String)this.getStringOption(evaluated, "b")).isNull();
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).hasSize(2)).contains((Object[])new String[]{"-b", "toast"});
    }

    @Test
    public void testMissingValueBecauseOfDoubleDash() throws Exception {
        this.cli.addOption((Option)new TypedOption().setType(String.class).setShortName("n").setSingleValued(true));
        this.cli.addOption((Option)new TypedOption().setType(String.class).setShortName("m").setSingleValued(false));
        try {
            this.cli.parse(Arrays.asList("-n", "--", "-m"));
            Assertions.fail((String)"Exception expected");
        }
        catch (MissingValueException e) {
            Assertions.assertThat((String)e.getOption().getShortName()).isEqualTo((Object)"n");
        }
    }

    @Test
    public void testSingleDash() throws Exception {
        String[] args = new String[]{"--copt", "-b", "-", "-a", "-"};
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((boolean)this.getBooleanOption(evaluated, "a")).isTrue();
        Assertions.assertThat((String)this.getStringOption(evaluated, "b")).isEqualTo((Object)"-");
        Assertions.assertThat((boolean)this.getBooleanOption(evaluated, "c")).isTrue();
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).contains((Object[])new String[]{"-"})).hasSize(1);
    }

    @Test
    public void testNegativeArgument() throws Exception {
        String[] args = new String[]{"-b", "-1"};
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((String)this.getStringOption(evaluated, "b")).isEqualTo((Object)"-1");
    }

    @Test
    public void testNegativeOption() throws Exception {
        String[] args = new String[]{"-b", "-1"};
        this.cli.addOption((Option)new TypedOption().setType(Boolean.class).setSingleValued(false).setShortName("1"));
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((String)this.getStringOption(evaluated, "b")).isEqualTo((Object)"-1");
        Assertions.assertThat((boolean)this.getBooleanOption(evaluated, "1")).isFalse();
        evaluated = this.cli.parse(Collections.singletonList("-1"));
        Assertions.assertThat((boolean)this.getBooleanOption(evaluated, "1")).isTrue();
        Assertions.assertThat((String)this.getStringOption(evaluated, "b")).isNull();
    }

    @Test
    public void testArgumentStartingWithHyphen() throws Exception {
        String[] args = new String[]{"-b", "-foo"};
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((String)this.getStringOption(evaluated, "b")).isEqualTo((Object)"-foo");
    }

    @Test
    public void testShortWithEqual() throws Exception {
        String[] args = new String[]{"-f=bar"};
        this.cli.addOption((Option)new TypedOption().setType(String.class).setSingleValued(true).setLongName("foo").setShortName("f"));
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((String)this.getStringOption(evaluated, "foo")).isEqualTo((Object)"bar");
    }

    @Test
    public void testShortWithoutEqual() throws Exception {
        String[] args = new String[]{"-fbar"};
        this.cli.addOption((Option)new TypedOption().setType(String.class).setSingleValued(true).setLongName("foo").setShortName("f"));
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((String)this.getStringOption(evaluated, "foo")).isEqualTo((Object)"bar");
    }

    @Test
    public void testLongWithEqualDoubleDash() throws Exception {
        String[] args = new String[]{"--foo=bar"};
        this.cli.addOption((Option)new TypedOption().setType(String.class).setSingleValued(true).setLongName("foo").setShortName("f"));
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((String)this.getStringOption(evaluated, "foo")).isEqualTo((Object)"bar");
    }

    @Test
    public void testLongWithEqualSingleDash() throws Exception {
        String[] args = new String[]{"-foo=bar"};
        this.cli.addOption((Option)new TypedOption().setType(String.class).setSingleValued(true).setLongName("foo").setShortName("f"));
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((String)this.getStringOption(evaluated, "foo")).isEqualTo((Object)"bar");
    }

    @Test
    public void testLongWithoutEqualSingleDash() throws Exception {
        String[] args = new String[]{"-foobar"};
        this.cli.addOption((Option)new TypedOption().setType(String.class).setSingleValued(true).setLongName("foo").setShortName("f"));
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((String)this.getStringOption(evaluated, "foo")).isEqualTo((Object)"bar");
    }

    @Test
    public void testAmbiguousLongWithoutEqualSingleDash() throws Exception {
        String[] args = new String[]{"-b", "-foobar"};
        TypedOption f = new TypedOption().setType(String.class).setLongName("foo").setShortName("f").setSingleValued(true);
        TypedOption b = new TypedOption().setType(Boolean.class).setLongName("bar").setShortName("b").setFlag(true);
        this.cli.removeOption("b").addOption((Option)f).addOption((Option)b);
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("bar"))).isTrue();
        Assertions.assertThat((String)((String)evaluated.getOptionValue("foo"))).isEqualTo((Object)"bar");
    }

    @Test
    public void testLongWithoutEqualDoubleDash() throws Exception {
        String[] args = new String[]{"--foobar"};
        TypedOption f = new TypedOption().setType(String.class).setLongName("foo").setShortName("f").setSingleValued(true);
        this.cli.addOption((Option)f);
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((String)((String)evaluated.getOptionValue("foo"))).isNull();
    }

    @Test
    public void testLongWithUnexpectedArgument1() throws Exception {
        String[] args = new String[]{"--foo=bar"};
        TypedOption f = new TypedOption().setLongName("foo").setShortName("f").setType(Boolean.class).setSingleValued(false).setFlag(true);
        this.cli.addOption((Option)f);
        try {
            CommandLine evaluated = this.cli.parse(Arrays.asList(args));
            Assertions.fail((String)"Exception expected");
        }
        catch (InvalidValueException e) {
            Assertions.assertThat((String)e.getOption().getShortName()).isEqualToIgnoringCase((CharSequence)"f");
            Assertions.assertThat((String)e.getValue()).isEqualToIgnoringCase((CharSequence)"bar");
        }
    }

    @Test
    public void testLongWithUnexpectedArgument2() throws Exception {
        String[] args = new String[]{"-foobar"};
        TypedOption f = new TypedOption().setLongName("foo").setShortName("f").setType(Boolean.class).setSingleValued(false);
        this.cli.addOption((Option)f);
        try {
            CommandLine evaluated = this.cli.parse(Arrays.asList(args));
            Assertions.fail((String)"Exception expected");
        }
        catch (InvalidValueException e) {
            Assertions.assertThat((String)e.getOption().getShortName()).isEqualToIgnoringCase((CharSequence)"f");
            Assertions.assertThat((String)e.getValue()).isEqualToIgnoringCase((CharSequence)"bar");
        }
    }

    @Test
    public void testShortWithUnexpectedArgument() throws Exception {
        String[] args = new String[]{"-f=bar"};
        TypedOption f = new TypedOption().setLongName("foo").setShortName("f").setType(Boolean.class).setSingleValued(false);
        this.cli.addOption((Option)f);
        try {
            CommandLine evaluated = this.cli.parse(Arrays.asList(args));
            Assertions.fail((String)"Exception expected");
        }
        catch (InvalidValueException e) {
            Assertions.assertThat((String)e.getOption().getShortName()).isEqualToIgnoringCase((CharSequence)"f");
            Assertions.assertThat((String)e.getValue()).isEqualToIgnoringCase((CharSequence)"bar");
        }
    }

    @Test
    public void testPropertiesOption1() throws Exception {
        String[] args = new String[]{"-Jsource=1.5", "-J", "target", "1.5", "foo"};
        TypedOption f = new TypedOption().setShortName("J").setType(String.class).setMultiValued(true);
        this.cli.addOption((Option)f);
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        List values = evaluated.getOptionValues("J");
        ((AbstractListAssert)Assertions.assertThat((List)values).hasSize(4)).containsExactly((Object[])new String[]{"source=1.5", "target", "1.5", "foo"});
    }

    @Test
    public void testUnambiguousPartialLongOption1() throws Exception {
        String[] args = new String[]{"--ver"};
        TypedOption v = new TypedOption().setLongName("version").setType(Boolean.class).setSingleValued(false);
        TypedOption h = new TypedOption().setLongName("help").setType(Boolean.class).setSingleValued(false);
        this.cli.addOption((Option)v).addOption((Option)h);
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((boolean)this.getBooleanOption(evaluated, "version")).isTrue();
    }

    @Test
    public void testUnambiguousPartialLongOption2() throws Exception {
        String[] args = new String[]{"-ver"};
        TypedOption v = new TypedOption().setLongName("version").setType(Boolean.class).setSingleValued(false);
        TypedOption h = new TypedOption().setLongName("help").setType(Boolean.class).setSingleValued(false);
        this.cli.addOption((Option)v).addOption((Option)h);
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((boolean)this.getBooleanOption(evaluated, "version")).isTrue();
    }

    @Test
    public void testUnambiguousPartialLongOption3() throws Exception {
        String[] args = new String[]{"--ver=1"};
        TypedOption v = new TypedOption().setLongName("verbose").setSingleValued(true).setType(Integer.class);
        TypedOption h = new TypedOption().setLongName("help").setType(Boolean.class).setSingleValued(false);
        this.cli.addOption((Option)v).addOption((Option)h);
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((int)((Integer)evaluated.getOptionValue("verbose"))).isEqualTo(1);
    }

    @Test
    public void testUnambiguousPartialLongOption4() throws Exception {
        String[] args = new String[]{"-ver=1"};
        TypedOption v = new TypedOption().setLongName("verbose").setSingleValued(true).setType(Integer.class);
        TypedOption h = new TypedOption().setLongName("help").setType(Boolean.class).setSingleValued(false);
        this.cli.addOption((Option)v).addOption((Option)h);
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((int)((Integer)evaluated.getOptionValue("verbose"))).isEqualTo(1);
    }

    @Test
    public void testAmbiguousPartialLongOption1() throws Exception {
        String[] args = new String[]{"--ver"};
        TypedOption v1 = new TypedOption().setLongName("verbose").setSingleValued(true).setType(Integer.class);
        TypedOption v2 = new TypedOption().setLongName("version").setType(Boolean.class).setSingleValued(false);
        this.cli.addOption((Option)v1).addOption((Option)v2);
        try {
            this.cli.parse(Arrays.asList(args));
            Assertions.fail((String)"Exception expected");
        }
        catch (AmbiguousOptionException e) {
            Assertions.assertThat((String)e.getToken()).isEqualTo((Object)"--ver");
            Assertions.assertThat((List)e.getOptions()).hasSize(2);
        }
    }

    @Test
    public void testAmbiguousPartialLongOption2() throws Exception {
        String[] args = new String[]{"-ver"};
        TypedOption v1 = new TypedOption().setLongName("verbose").setSingleValued(true).setType(Integer.class);
        TypedOption v2 = new TypedOption().setLongName("version").setType(Boolean.class).setSingleValued(false);
        this.cli.addOption((Option)v1).addOption((Option)v2);
        try {
            this.cli.parse(Arrays.asList(args));
            Assertions.fail((String)"Exception expected");
        }
        catch (AmbiguousOptionException e) {
            Assertions.assertThat((String)e.getToken()).isEqualTo((Object)"-ver");
            Assertions.assertThat((List)e.getOptions()).hasSize(2);
        }
    }

    @Test
    public void testAmbiguousPartialLongOption3() throws Exception {
        String[] args = new String[]{"--ver=1"};
        TypedOption v1 = new TypedOption().setLongName("verbose").setSingleValued(true).setType(Integer.class);
        TypedOption v2 = new TypedOption().setLongName("version").setType(Boolean.class).setSingleValued(false);
        this.cli.addOption((Option)v1).addOption((Option)v2);
        try {
            this.cli.parse(Arrays.asList(args));
            Assertions.fail((String)"Exception expected");
        }
        catch (AmbiguousOptionException e) {
            Assertions.assertThat((String)e.getToken()).isEqualTo((Object)"--ver");
            Assertions.assertThat((List)e.getOptions()).hasSize(2);
        }
    }

    @Test
    public void testAmbiguousPartialLongOption4() throws Exception {
        String[] args = new String[]{"-ver=1"};
        TypedOption v1 = new TypedOption().setLongName("verbose").setSingleValued(true).setType(Integer.class);
        TypedOption v2 = new TypedOption().setLongName("version").setType(Boolean.class).setSingleValued(false);
        this.cli.addOption((Option)v1).addOption((Option)v2);
        try {
            this.cli.parse(Arrays.asList(args));
            Assertions.fail((String)"Exception expected");
        }
        catch (AmbiguousOptionException e) {
            Assertions.assertThat((String)e.getToken()).isEqualTo((Object)"-ver");
            Assertions.assertThat((List)e.getOptions()).hasSize(2);
        }
    }

    @Test
    public void testPartialLongOptionSingleDash() throws Exception {
        String[] args = new String[]{"-ver"};
        TypedOption v2 = new TypedOption().setLongName("version").setType(Boolean.class).setSingleValued(false);
        TypedOption v1 = new TypedOption().setSingleValued(true).setShortName("v").setType(Integer.class);
        this.cli.addOption((Option)v1).addOption((Option)v2);
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((Object)evaluated.getOptionValue("v")).isNull();
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("version"))).isTrue();
    }

    @Test
    public void testWithRequiredOption() throws Exception {
        String[] args = new String[]{"-b", "file"};
        TypedOption b = new TypedOption().setShortName("b").setLongName("bfile").setSingleValued(true).setDescription("set the value of [b]").setType(String.class).setRequired(true);
        this.cli.removeOption("b").addOption((Option)b);
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((boolean)this.getBooleanOption(evaluated, "a")).isFalse();
        Assertions.assertThat((String)((String)evaluated.getOptionValue("b"))).isEqualTo((Object)"file");
        Assertions.assertThat((List)evaluated.allArguments()).isEmpty();
    }

    @Test
    public void testOptionAndRequiredOption() throws Exception {
        String[] args = new String[]{"-a", "-b", "file"};
        TypedOption b = new TypedOption().setShortName("b").setLongName("bfile").setSingleValued(true).setDescription("set the value of [b]").setType(String.class).setRequired(true);
        this.cli.removeOption("b").addOption((Option)b);
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((boolean)this.getBooleanOption(evaluated, "a")).isTrue();
        Assertions.assertThat((String)this.getStringOption(evaluated, "b")).isEqualTo((Object)"file");
        Assertions.assertThat((List)evaluated.allArguments()).isEmpty();
    }

    @Test
    public void testMissingRequiredOption() throws Exception {
        String[] args = new String[]{"-a"};
        TypedOption b = new TypedOption().setShortName("b").setLongName("bfile").setSingleValued(true).setDescription("set the value of [b]").setType(String.class).setRequired(true);
        this.cli.removeOption("b").addOption((Option)b);
        try {
            this.cli.parse(Arrays.asList(args));
            Assertions.fail((String)"exception expected");
        }
        catch (MissingOptionException e) {
            Assertions.assertThat((Iterable)e.getExpected()).hasSize(1);
        }
    }

    @Test
    public void testMissingRequiredOptions() throws CLIException {
        String[] args = new String[]{"-a"};
        TypedOption b = new TypedOption().setShortName("b").setLongName("bfile").setSingleValued(true).setDescription("set the value of [b]").setType(String.class).setRequired(true);
        TypedOption c = new TypedOption().setShortName("c").setLongName("copt").setSingleValued(false).setDescription("turn [c] on or off").setType(Boolean.class).setRequired(true);
        this.cli.removeOption("b").addOption((Option)b).removeOption("c").addOption((Option)c);
        try {
            CommandLine evaluated = this.cli.parse(Arrays.asList(args));
            Assertions.fail((String)"exception expected");
        }
        catch (MissingOptionException e) {
            Assertions.assertThat((Iterable)e.getExpected()).hasSize(2);
        }
    }

    @Test
    public void testBursting() throws Exception {
        String[] args = new String[]{"-acbtoast", "foo", "bar"};
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        Assertions.assertThat((boolean)this.getBooleanOption(evaluated, "a")).isTrue();
        Assertions.assertThat((boolean)this.getBooleanOption(evaluated, "c")).isTrue();
        Assertions.assertThat((String)this.getStringOption(evaluated, "b")).isEqualTo((Object)"toast");
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).hasSize(2)).contains((Object[])new String[]{"foo", "bar"});
    }

    @Test
    public void testUnrecognizedOptionWithBursting() throws Exception {
        String[] args = new String[]{"-adbtoast", "foo", "bar"};
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).contains((Object[])new String[]{"-adbtoast", "foo", "bar"})).hasSize(3);
    }

    @Test
    public void testMissingArgWithBursting() throws Exception {
        String[] args = new String[]{"-acb"};
        try {
            CommandLine evaluated = this.cli.parse(Arrays.asList(args));
            Assertions.fail((String)"exception expected");
        }
        catch (MissingValueException e) {
            Assertions.assertThat((String)e.getOption().getShortName()).isEqualTo((Object)"b");
        }
    }

    @Test
    public void testMultiValues() throws Exception {
        String[] args = new String[]{"-e", "one", "two", "-f", "1"};
        TypedOption e = new TypedOption().setShortName("e").setMultiValued(true).setType(String.class);
        TypedOption f = new TypedOption().setShortName("f").setMultiValued(true).setType(Integer.class);
        this.cli.addOption((Option)e).addOption((Option)f);
        CommandLine evaluated = this.cli.parse(Arrays.asList(args));
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.getOptionValues("e")).contains(new Object[]{"one", "two"})).hasSize(2);
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.getOptionValues("f")).contains(new Object[]{1})).hasSize(1);
    }
}

