/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher.commands;

import io.vertx.core.Launcher;
import io.vertx.core.Vertx;
import io.vertx.core.impl.launcher.commands.CommandTestBase;
import io.vertx.core.impl.launcher.commands.ExecUtils;
import io.vertx.core.impl.launcher.commands.HttpTestVerticle;
import io.vertx.core.impl.launcher.commands.RunCommand;
import io.vertx.core.impl.launcher.commands.RunCommandTest;
import io.vertx.core.json.JsonObject;
import io.vertx.test.fakecluster.FakeClusterManager;
import java.io.File;
import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;

public class RedeployTest
extends CommandTestBase {
    private void waitForTermination() {
        this.assertWaitUntil(() -> {
            try {
                RunCommandTest.getHttpCode();
                return false;
            }
            catch (IOException e) {
                return true;
            }
        });
    }

    @Override
    @After
    public void tearDown() throws InterruptedException {
        super.tearDown();
        RunCommand run = (RunCommand)this.cli.getExistingCommandInstance("run");
        if (run != null) {
            Vertx vertx = run.vertx;
            this.close(vertx);
            run.stopBackgroundApplication(null);
            run.shutdownRedeployment();
        }
        FakeClusterManager.reset();
        this.waitForTermination();
    }

    @Test
    public void testStartingApplicationInRedeployMode() {
        this.cli.dispatch((Object)new Launcher(), new String[]{"run", HttpTestVerticle.class.getName(), "--redeploy=**" + File.separator + "*.txt", "--launcher-class=" + Launcher.class.getName()});
        this.assertWaitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
    }

    @Test
    public void testStartingApplicationInRedeployModeWithInlineConf() throws IOException {
        int random = (int)(Math.random() * 100.0);
        this.cli.dispatch((Object)new Launcher(), new String[]{"run", HttpTestVerticle.class.getName(), "--redeploy=**" + File.separator + "*.txt", "--launcher-class=" + Launcher.class.getName(), "--conf", "{\"random\":" + random + "}"});
        this.assertWaitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
        JsonObject conf = RunCommandTest.getContent().getJsonObject("conf");
        Assertions.assertThat((Iterable)conf).isNotNull().isNotEmpty();
        Assertions.assertThat((Integer)conf.getInteger("random")).isEqualTo(random);
    }

    @Test
    public void testStartingApplicationInRedeployModeWithInlineConf2() throws IOException {
        int random = (int)(Math.random() * 100.0);
        this.cli.dispatch((Object)new Launcher(), new String[]{"run", HttpTestVerticle.class.getName(), "--redeploy=**" + File.separator + "*.txt", "--launcher-class=" + Launcher.class.getName(), "--conf={\"random\":" + random + "}"});
        this.assertWaitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
        JsonObject conf = RunCommandTest.getContent().getJsonObject("conf");
        Assertions.assertThat((Iterable)conf).isNotNull().isNotEmpty();
        Assertions.assertThat((Integer)conf.getInteger("random")).isEqualTo(random);
    }

    @Test
    public void testStartingApplicationInRedeployModeWithFileConf() throws IOException {
        this.cli.dispatch((Object)new Launcher(), new String[]{"run", HttpTestVerticle.class.getName(), "--redeploy=**" + File.separator + "*.txt", "--launcher-class=" + Launcher.class.getName(), "--conf", new File("src/test/resources/conf.json").getAbsolutePath()});
        this.assertWaitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
        JsonObject conf = RunCommandTest.getContent().getJsonObject("conf");
        Assertions.assertThat((Iterable)conf).isNotNull().isNotEmpty();
        Assertions.assertThat((String)conf.getString("name")).isEqualTo((Object)"vertx");
    }

    @Test
    public void testStartingApplicationInRedeployModeWithFileConf2() throws IOException {
        this.cli.dispatch((Object)new Launcher(), new String[]{"run", HttpTestVerticle.class.getName(), "--redeploy=**" + File.separator + "*.txt", "--launcher-class=" + Launcher.class.getName(), "--conf=" + new File("src/test/resources/conf.json").getAbsolutePath()});
        this.assertWaitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
        JsonObject conf = RunCommandTest.getContent().getJsonObject("conf");
        Assertions.assertThat((Iterable)conf).isNotNull().isNotEmpty();
        Assertions.assertThat((String)conf.getString("name")).isEqualTo((Object)"vertx");
    }

    @Test
    public void testStartingApplicationInRedeployModeWithCluster() throws IOException {
        this.cli.dispatch((Object)new Launcher(), new String[]{"run", HttpTestVerticle.class.getName(), "--redeploy=**" + File.separator + "*.txt", "--launcher-class=" + Launcher.class.getName(), "--cluster", ExecUtils.isWindows() ? "--redeploy-termination-period=3000" : ""});
        this.assertWaitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        }, 20000L);
        Assertions.assertThat((Boolean)RunCommandTest.getContent().getBoolean("clustered")).isTrue();
    }

    @Test
    public void testRedeployment() throws IOException {
        this.cli.dispatch((Object)new Launcher(), new String[]{"run", HttpTestVerticle.class.getName(), "--redeploy=**" + File.separator + "*.txt", "--launcher-class=" + Launcher.class.getName(), ExecUtils.isWindows() ? "--redeploy-termination-period=3000" : ""});
        this.assertWaitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
        long start1 = RunCommandTest.getContent().getLong("startTime");
        File file = new File("target/test-classes/foo.txt");
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        this.assertWaitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200 && start1 != RunCommandTest.getContent().getLong("startTime");
            }
            catch (IOException e) {
                return false;
            }
        }, 20000L);
    }

    @Test
    public void testRedeploymentWithSlash() throws IOException {
        this.cli.dispatch((Object)new Launcher(), new String[]{"run", HttpTestVerticle.class.getName(), "--redeploy=**/*.txt", "--launcher-class=" + Launcher.class.getName(), ExecUtils.isWindows() ? "--redeploy-termination-period=3000" : ""});
        this.assertWaitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
        long start1 = RunCommandTest.getContent().getLong("startTime");
        File file = new File("target/test-classes/foo.txt");
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        this.assertWaitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200 && start1 != RunCommandTest.getContent().getLong("startTime");
            }
            catch (IOException e) {
                return false;
            }
        }, 20000L);
    }
}

