/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.internal.ArrayComparisonFailure;
import org.junit.rules.TestName;

public class AsyncTestBase {
    private static final Logger log = LoggerFactory.getLogger(AsyncTestBase.class);
    private CountDownLatch latch;
    private volatile Throwable throwable;
    private volatile Thread thrownThread;
    private volatile boolean testCompleteCalled;
    private volatile boolean awaitCalled;
    private boolean threadChecksEnabled = true;
    private volatile boolean tearingDown;
    private volatile String mainThreadName;
    private Map<String, Exception> threadNames = new ConcurrentHashMap<String, Exception>();
    @Rule
    public TestName name = new TestName();

    protected void setUp() throws Exception {
        log.info((Object)("Starting test: " + this.getClass().getSimpleName() + "#" + this.name.getMethodName()));
        this.mainThreadName = Thread.currentThread().getName();
        this.tearingDown = false;
        this.waitFor(1);
        this.throwable = null;
        this.testCompleteCalled = false;
        this.awaitCalled = false;
        this.threadNames.clear();
    }

    protected void tearDown() throws Exception {
        this.tearingDown = true;
        this.afterAsyncTestBase();
    }

    @Before
    public void before() throws Exception {
        this.setUp();
    }

    @After
    public void after() throws Exception {
        this.tearDown();
    }

    protected synchronized void waitFor(int count) {
        this.latch = new CountDownLatch(count);
    }

    protected synchronized void waitForMore(int count) {
        this.latch = new CountDownLatch(count + (int)this.latch.getCount());
    }

    protected synchronized void complete() {
        if (this.tearingDown) {
            throw new IllegalStateException("testComplete called after test has completed");
        }
        this.checkThread();
        if (this.testCompleteCalled) {
            throw new IllegalStateException("already complete");
        }
        this.latch.countDown();
        if (this.latch.getCount() == 0L) {
            this.testCompleteCalled = true;
        }
    }

    protected void testComplete() {
        if (this.tearingDown) {
            throw new IllegalStateException("testComplete called after test has completed");
        }
        this.checkThread();
        if (this.testCompleteCalled) {
            throw new IllegalStateException("testComplete() already called");
        }
        this.testCompleteCalled = true;
        this.latch.countDown();
    }

    protected void await() {
        this.await(2L, TimeUnit.MINUTES);
    }

    public void await(long delay, TimeUnit timeUnit) {
        if (this.awaitCalled) {
            throw new IllegalStateException("await() already called");
        }
        this.awaitCalled = true;
        try {
            boolean ok = this.latch.await(delay, timeUnit);
            if (!ok) {
                throw new IllegalStateException("Timed out in waiting for test complete");
            }
            this.rethrowError();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Test thread was interrupted!");
        }
    }

    private void rethrowError() {
        if (this.throwable != null) {
            if (this.throwable instanceof Error) {
                throw (Error)this.throwable;
            }
            if (this.throwable instanceof RuntimeException) {
                throw (RuntimeException)this.throwable;
            }
            throw new IllegalStateException(this.throwable);
        }
    }

    protected void disableThreadChecks() {
        this.threadChecksEnabled = false;
    }

    protected void afterAsyncTestBase() {
        if (this.throwable != null && this.thrownThread != Thread.currentThread() && !this.awaitCalled) {
            throw new IllegalStateException("Assert or failure from non main thread but no await() on main thread", this.throwable);
        }
        for (Map.Entry<String, Exception> entry : this.threadNames.entrySet()) {
            if (entry.getKey().equals(this.mainThreadName) || !this.threadChecksEnabled || entry.getKey().startsWith("vert.x-")) continue;
            IllegalStateException is = new IllegalStateException("Non Vert.x thread! :" + entry.getKey());
            is.setStackTrace(entry.getValue().getStackTrace());
            throw is;
        }
    }

    private void handleThrowable(Throwable t) {
        if (this.tearingDown) {
            throw new IllegalStateException("assert or failure occurred after test has completed");
        }
        this.throwable = t;
        t.printStackTrace();
        this.thrownThread = Thread.currentThread();
        this.latch.countDown();
        if (t instanceof AssertionError) {
            throw (AssertionError)((Object)t);
        }
    }

    protected void clearThrown() {
        this.throwable = null;
    }

    protected void checkThread() {
        this.threadNames.put(Thread.currentThread().getName(), new Exception());
    }

    protected void assertTrue(String message, boolean condition) {
        this.checkThread();
        try {
            Assert.assertTrue((String)message, (boolean)condition);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertFalse(boolean condition) {
        this.checkThread();
        try {
            Assert.assertFalse((boolean)condition);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertArrayEquals(String message, char[] expecteds, char[] actuals) throws ArrayComparisonFailure {
        this.checkThread();
        try {
            Assert.assertArrayEquals((String)message, (char[])expecteds, (char[])actuals);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertSame(String message, Object expected, Object actual) {
        this.checkThread();
        try {
            Assert.assertSame((String)message, (Object)expected, (Object)actual);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertEquals(long expected, long actual) {
        this.checkThread();
        try {
            Assert.assertEquals((long)expected, (long)actual);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertNull(Object object) {
        this.checkThread();
        try {
            Assert.assertNull((Object)object);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertFalse(String message, boolean condition) {
        this.checkThread();
        try {
            Assert.assertFalse((String)message, (boolean)condition);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void fail(String message) {
        this.checkThread();
        try {
            Assert.fail((String)message);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertNull(String message, Object object) {
        this.checkThread();
        try {
            Assert.assertNull((String)message, (Object)object);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertArrayEquals(String message, float[] expecteds, float[] actuals, float delta) throws ArrayComparisonFailure {
        this.checkThread();
        try {
            Assert.assertArrayEquals((String)message, (float[])expecteds, (float[])actuals, (float)delta);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    @Deprecated
    protected void assertEquals(String message, double expected, double actual) {
        this.checkThread();
        try {
            Assert.assertEquals((String)message, (double)expected, (double)actual);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertArrayEquals(String message, double[] expecteds, double[] actuals, double delta) throws ArrayComparisonFailure {
        this.checkThread();
        try {
            Assert.assertArrayEquals((String)message, (double[])expecteds, (double[])actuals, (double)delta);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertArrayEquals(String message, Object[] expecteds, Object[] actuals) throws ArrayComparisonFailure {
        this.checkThread();
        try {
            Assert.assertArrayEquals((String)message, (Object[])expecteds, (Object[])actuals);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertArrayEquals(String message, short[] expecteds, short[] actuals) throws ArrayComparisonFailure {
        this.checkThread();
        try {
            Assert.assertArrayEquals((String)message, (short[])expecteds, (short[])actuals);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertArrayEquals(short[] expecteds, short[] actuals) {
        this.checkThread();
        try {
            Assert.assertArrayEquals((short[])expecteds, (short[])actuals);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertArrayEquals(long[] expecteds, long[] actuals) {
        this.checkThread();
        try {
            Assert.assertArrayEquals((long[])expecteds, (long[])actuals);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertNotNull(Object object) {
        this.checkThread();
        try {
            Assert.assertNotNull((Object)object);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertEquals(Object expected, Object actual) {
        this.checkThread();
        try {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertEquals(String message, Object expected, Object actual) {
        this.checkThread();
        try {
            Assert.assertEquals((String)message, (Object)expected, (Object)actual);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertTrue(boolean condition) {
        this.checkThread();
        try {
            Assert.assertTrue((boolean)condition);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertArrayEquals(Object[] expecteds, Object[] actuals) {
        this.checkThread();
        try {
            Assert.assertArrayEquals((Object[])expecteds, (Object[])actuals);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertNotNull(String message, Object object) {
        this.checkThread();
        try {
            Assert.assertNotNull((String)message, (Object)object);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertEquals(String message, double expected, double actual, double delta) {
        this.checkThread();
        try {
            Assert.assertEquals((String)message, (double)expected, (double)actual, (double)delta);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void fail() {
        this.checkThread();
        try {
            Assert.fail();
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void fail(Throwable cause) {
        this.checkThread();
        this.handleThrowable(cause);
    }

    protected void assertSame(Object expected, Object actual) {
        this.checkThread();
        try {
            Assert.assertSame((Object)expected, (Object)actual);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertEquals(String message, long expected, long actual) {
        this.checkThread();
        try {
            Assert.assertEquals((String)message, (long)expected, (long)actual);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertArrayEquals(String message, byte[] expecteds, byte[] actuals) throws ArrayComparisonFailure {
        this.checkThread();
        try {
            Assert.assertArrayEquals((String)message, (byte[])expecteds, (byte[])actuals);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertArrayEquals(String message, long[] expecteds, long[] actuals) throws ArrayComparisonFailure {
        this.checkThread();
        try {
            Assert.assertArrayEquals((String)message, (long[])expecteds, (long[])actuals);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertEquals(double expected, double actual, double delta) {
        this.checkThread();
        try {
            Assert.assertEquals((double)expected, (double)actual, (double)delta);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected <T> void assertThat(T actual, Matcher<T> matcher) {
        this.checkThread();
        try {
            Assert.assertThat(actual, matcher);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    @Deprecated
    protected void assertEquals(String message, Object[] expecteds, Object[] actuals) {
        this.checkThread();
        try {
            Assert.assertEquals((String)message, (Object[])expecteds, (Object[])actuals);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    @Deprecated
    protected void assertEquals(Object[] expecteds, Object[] actuals) {
        this.checkThread();
        try {
            Assert.assertEquals((Object[])expecteds, (Object[])actuals);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertNotSame(String message, Object unexpected, Object actual) {
        this.checkThread();
        try {
            Assert.assertNotSame((String)message, (Object)unexpected, (Object)actual);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected <T> void assertThat(String reason, T actual, Matcher<T> matcher) {
        this.checkThread();
        try {
            Assert.assertThat((String)reason, actual, matcher);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertArrayEquals(float[] expecteds, float[] actuals, float delta) {
        this.checkThread();
        try {
            Assert.assertArrayEquals((float[])expecteds, (float[])actuals, (float)delta);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertNotSame(Object unexpected, Object actual) {
        this.checkThread();
        try {
            Assert.assertNotSame((Object)unexpected, (Object)actual);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertArrayEquals(byte[] expecteds, byte[] actuals) {
        this.checkThread();
        try {
            Assert.assertArrayEquals((byte[])expecteds, (byte[])actuals);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertArrayEquals(char[] expecteds, char[] actuals) {
        this.checkThread();
        try {
            Assert.assertArrayEquals((char[])expecteds, (char[])actuals);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertArrayEquals(double[] expecteds, double[] actuals, double delta) {
        this.checkThread();
        try {
            Assert.assertArrayEquals((double[])expecteds, (double[])actuals, (double)delta);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertArrayEquals(int[] expecteds, int[] actuals) {
        this.checkThread();
        try {
            Assert.assertArrayEquals((int[])expecteds, (int[])actuals);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    @Deprecated
    protected void assertEquals(double expected, double actual) {
        this.checkThread();
        try {
            Assert.assertEquals((double)expected, (double)actual);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected void assertArrayEquals(String message, int[] expecteds, int[] actuals) throws ArrayComparisonFailure {
        this.checkThread();
        try {
            Assert.assertArrayEquals((String)message, (int[])expecteds, (int[])actuals);
        }
        catch (AssertionError e) {
            this.handleThrowable((Throwable)((Object)e));
        }
    }

    protected <T> Handler<AsyncResult<T>> onFailure(Consumer<Throwable> consumer) {
        return result -> {
            this.assertFalse(result.succeeded());
            consumer.accept(result.cause());
        };
    }

    protected void awaitLatch(CountDownLatch latch) throws InterruptedException {
        this.assertTrue(latch.await(10L, TimeUnit.SECONDS));
    }

    public static void assertWaitUntil(BooleanSupplier supplier) {
        AsyncTestBase.assertWaitUntil(supplier, 10000L);
    }

    public static void waitUntil(BooleanSupplier supplier) {
        AsyncTestBase.waitUntil(supplier, 10000L);
    }

    public static void assertWaitUntil(BooleanSupplier supplier, long timeout) {
        if (!AsyncTestBase.waitUntil(supplier, timeout)) {
            throw new IllegalStateException("Timed out");
        }
    }

    public static void assertWaitUntil(BooleanSupplier supplier, long timeout, String reason) {
        if (!AsyncTestBase.waitUntil(supplier, timeout)) {
            throw new IllegalStateException("Timed out: " + reason);
        }
    }

    public static boolean waitUntil(BooleanSupplier supplier, long timeout) {
        long now;
        long start = System.currentTimeMillis();
        do {
            if (supplier.getAsBoolean()) {
                return true;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((now = System.currentTimeMillis()) - start <= timeout);
        return false;
    }

    protected <T> Handler<AsyncResult<T>> onSuccess(Consumer<T> consumer) {
        return result -> {
            if (result.failed()) {
                result.cause().printStackTrace();
                this.fail(result.cause().getMessage());
            } else {
                consumer.accept(result.result());
            }
        };
    }

    protected void close(Vertx vertx) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        vertx.close(ar -> latch.countDown());
        this.awaitLatch(latch);
    }
}

