/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.Handler;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class EventBusInterceptorTest
extends VertxTestBase {
    protected EventBus eb;

    @Test
    public void testInterceptorSend() {
        this.eb.addInterceptor(sc -> {
            this.assertEquals("armadillo", sc.message().body());
            this.assertTrue(sc.send());
            sc.next();
        });
        this.eb.consumer("some-address", msg -> {
            this.assertEquals("armadillo", msg.body());
            this.testComplete();
        });
        this.eb.send("some-address", (Object)"armadillo");
        this.await();
    }

    @Test
    public void testInterceptorPublish() {
        this.eb.addInterceptor(sc -> {
            this.assertEquals("armadillo", sc.message().body());
            this.assertFalse(sc.send());
            sc.next();
        });
        this.eb.consumer("some-address", msg -> {
            this.assertEquals("armadillo", msg.body());
            this.testComplete();
        });
        this.eb.publish("some-address", (Object)"armadillo");
        this.await();
    }

    @Test
    public void testInterceptorNoNext() {
        this.eb.addInterceptor(sc -> this.assertEquals("armadillo", sc.message().body()));
        this.eb.consumer("some-address", msg -> this.fail("Should not receive message"));
        this.eb.send("some-address", (Object)"armadillo");
        this.vertx.setTimer(200L, tid -> this.testComplete());
        this.await();
    }

    @Test
    public void testMultipleInterceptors() {
        AtomicInteger cnt = new AtomicInteger();
        int interceptorNum = 10;
        int i = 0;
        while (i < interceptorNum) {
            int expectedCount = i++;
            this.eb.addInterceptor(sc -> {
                this.assertEquals("armadillo", sc.message().body());
                int count = cnt.getAndIncrement();
                this.assertEquals(expectedCount, count);
                sc.next();
            });
        }
        this.eb.consumer("some-address", msg -> {
            this.assertEquals("armadillo", msg.body());
            this.assertEquals(interceptorNum, cnt.get());
            this.testComplete();
        });
        this.eb.send("some-address", (Object)"armadillo");
        this.await();
    }

    @Test
    public void testRemoveInterceptor() {
        AtomicInteger cnt1 = new AtomicInteger();
        AtomicInteger cnt2 = new AtomicInteger();
        Handler eb1 = sc -> {
            cnt1.incrementAndGet();
            sc.next();
        };
        Handler eb2 = sc -> {
            cnt2.incrementAndGet();
            sc.next();
        };
        this.eb.addInterceptor(eb1).addInterceptor(eb2);
        this.eb.consumer("some-address", msg -> {
            if (msg.body().equals("armadillo")) {
                this.assertEquals(1L, cnt1.get());
                this.assertEquals(1L, cnt2.get());
                this.eb.removeInterceptor(eb2);
                this.eb.send("some-address", (Object)"aardvark");
            } else if (msg.body().equals("aardvark")) {
                this.assertEquals(2L, cnt1.get());
                this.assertEquals(1L, cnt2.get());
                this.testComplete();
            } else {
                this.fail("wrong body");
            }
        });
        this.eb.send("some-address", (Object)"armadillo");
        this.await();
    }

    @Test
    public void testInterceptorOnReply() {
        AtomicInteger cnt = new AtomicInteger();
        this.eb.addInterceptor(sc -> {
            if (sc.message().body().equals("armadillo")) {
                this.assertEquals(0L, cnt.get());
            } else if (sc.message().body().equals("echidna")) {
                this.assertEquals(1L, cnt.get());
            } else {
                this.fail("wrong body");
            }
            cnt.incrementAndGet();
            sc.next();
        });
        this.eb.consumer("some-address", msg -> {
            this.assertEquals("armadillo", msg.body());
            this.assertEquals(1L, cnt.get());
            msg.reply((Object)"echidna");
        });
        this.eb.send("some-address", (Object)"armadillo", reply -> {
            this.assertEquals("echidna", ((Message)reply.result()).body());
            this.assertEquals(2L, cnt.get());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testExceptionInInterceptor() {
        AtomicInteger cnt = new AtomicInteger();
        Handler eb1 = sc -> {
            cnt.incrementAndGet();
            this.vertx.runOnContext(v -> sc.next());
            throw new RuntimeException("foo");
        };
        Handler eb2 = sc -> {
            cnt.incrementAndGet();
            sc.next();
        };
        this.eb.addInterceptor(eb1).addInterceptor(eb2);
        this.eb.consumer("some-address", msg -> {
            this.assertEquals("armadillo", msg.body());
            this.assertEquals(2L, cnt.get());
            this.testComplete();
        });
        this.eb.send("some-address", (Object)"armadillo");
        this.await();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.eb = this.vertx.eventBus();
    }
}

