/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.http.impl.HttpUtils;
import org.junit.Assert;
import org.junit.Test;

public class HttpUtilTest {
    @Test
    public void testParseKeepAliveTimeout() {
        HttpUtilTest.assertKeepAliveTimeout("timeout=5", 5);
        HttpUtilTest.assertKeepAliveTimeout(" timeout=5", 5);
        HttpUtilTest.assertKeepAliveTimeout("timeout=5 ", 5);
        HttpUtilTest.assertKeepAliveTimeout("a=4,timeout=5", 5);
        HttpUtilTest.assertKeepAliveTimeout(" a=4,timeout=5", 5);
        HttpUtilTest.assertKeepAliveTimeout("a=4 ,timeout=5", 5);
        HttpUtilTest.assertKeepAliveTimeout("a=4, timeout=5", 5);
        HttpUtilTest.assertKeepAliveTimeout("a=4,timeout=5 ", 5);
        HttpUtilTest.assertKeepAliveTimeout("", -1);
        HttpUtilTest.assertKeepAliveTimeout("a=4", -1);
        HttpUtilTest.assertKeepAliveTimeout("timeout", -1);
        HttpUtilTest.assertKeepAliveTimeout("timeout=", -1);
        HttpUtilTest.assertKeepAliveTimeout("timeout=a", -1);
        HttpUtilTest.assertKeepAliveTimeout("timeout=-5", -1);
        HttpUtilTest.assertKeepAliveTimeout("timeout=5_", -1);
    }

    private static void assertKeepAliveTimeout(CharSequence header, int expected) {
        Assert.assertEquals((long)expected, (long)HttpUtils.parseKeepAliveHeaderTimeout((CharSequence)header));
    }
}

