/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.test.core.FileResolverTestBase;
import java.net.MalformedURLException;
import java.net.URL;

public class NestedJarFileResolverTest
extends FileResolverTestBase {
    private ClassLoader prevCL;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.webRoot = "webroot4";
        this.prevCL = Thread.currentThread().getContextClassLoader();
        final URL webroot4URL = this.prevCL.getResource("webroot4.jar");
        this.prevCL = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = new ClassLoader(this.prevCL){

            @Override
            public URL getResource(String name) {
                try {
                    if (name.startsWith("lib/")) {
                        return new URL("jar:" + webroot4URL + "!/" + name);
                    }
                    if (name.startsWith("webroot4")) {
                        return new URL("jar:" + webroot4URL + "!/lib/nested.jar!/" + name.substring(7));
                    }
                }
                catch (MalformedURLException e) {
                    throw new AssertionError((Object)e);
                }
                return super.getResource(name);
            }
        };
        Thread.currentThread().setContextClassLoader(loader);
    }

    @Override
    public void after() throws Exception {
        if (this.prevCL != null) {
            Thread.currentThread().setContextClassLoader(this.prevCL);
        }
        super.after();
    }
}

