/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.http.impl.HttpUtils;
import java.net.URI;
import org.junit.Assert;
import org.junit.Test;

public class URITest {
    @Test
    public void testResolve() throws Exception {
        this.assertResolve("http://a/b/c/g", "http://a/b/c/d;p?q", "g");
        this.assertResolve("http://a/b/c/g", "http://a/b/c/d;p?q", "./g");
        this.assertResolve("http://a/b/c/g/", "http://a/b/c/d;p?q", "g/");
        this.assertResolve("http://a/g", "http://a/b/c/d;p?q", "/g");
        this.assertResolve("http://g", "http://a/b/c/d;p?q", "//g");
        this.assertResolve("http://a/b/c/d;p?y", "http://a/b/c/d;p?q", "?y");
        this.assertResolve("http://a/b/c/g?y", "http://a/b/c/d;p?q", "g?y");
        this.assertResolve("http://a/b/c/d;p?q#s", "http://a/b/c/d;p?q", "#s");
        this.assertResolve("http://a/b/c/g#s", "http://a/b/c/d;p?q", "g#s");
        this.assertResolve("http://a/b/c/;x", "http://a/b/c/d;p?q", ";x");
        this.assertResolve("http://a/b/c/g;x", "http://a/b/c/d;p?q", "g;x");
        this.assertResolve("http://a/b/c/g;x?y#s", "http://a/b/c/d;p?q", "g;x?y#s");
        this.assertResolve("http://a/b/c/d;p?q", "http://a/b/c/d;p?q", "");
        this.assertResolve("http://a/b/c/", "http://a/b/c/d;p?q", ".");
        this.assertResolve("http://a/b/c/", "http://a/b/c/d;p?q", "./");
        this.assertResolve("http://a/b/", "http://a/b/c/d;p?q", "..");
        this.assertResolve("http://a/", "http://a/b/c/d;p?q", "../..");
        this.assertResolve("http://a/", "http://a/b/c/d;p?q", "../../");
        this.assertResolve("http://a/g", "http://a/b/c/d;p?q", "../../g");
        this.assertResolve("http://a/g", "http://a/b/c/d;p?q", "../../../g");
        this.assertResolve("http://a/g", "http://a/b/c/d;p?q", "../../../../g");
        this.assertResolve("http://example.com/path", "https://example.com/path", "http://example.com/path");
        this.assertResolve("https://example.com/relativeUrl", "https://example.com/path?q=2", "/relativeUrl");
        this.assertResolve("https://example.com/path?q=2#test", "https://example.com/path?q=2", "#test");
        this.assertResolve("https://example.com/relativePath?q=3", "https://example.com/path?q=2", "/relativePath?q=3");
        this.assertResolve("https://example.com/path?q=3", "https://example.com/path?q=2", "?q=3");
    }

    private void assertResolve(String expected, String base, String rel) throws Exception {
        URI resolved = HttpUtils.resolveURIReference((String)base, (String)rel);
        Assert.assertEquals((Object)URI.create(expected), (Object)resolved);
    }
}

