/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.it;

import io.vertx.core.logging.Log4j2LogDelegateFactory;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.spi.logging.LogDelegate;
import io.vertx.test.it.StreamRecording;
import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class Log4J2LogDelegateTest {
    private static StreamRecording recording;

    @BeforeClass
    public static void initialize() throws IOException {
        System.setProperty("vertx.logger-delegate-factory-class-name", Log4j2LogDelegateFactory.class.getName());
        LoggerFactory.initialise();
        recording = new StreamRecording();
    }

    @AfterClass
    public static void terminate() {
        System.clearProperty("vertx.logger-delegate-factory-class-name");
        recording.terminate();
    }

    @Test
    public void testDelegateUnwrap() {
        io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-log4j2-logger");
        LogDelegate delegate = logger.getDelegate();
        Assert.assertNotNull((String)"Delegate is null", (Object)delegate);
        try {
            Logger unwrapped = (Logger)delegate.unwrap();
            Assert.assertNotNull((String)"Unwrapped is null", (Object)unwrapped);
        }
        catch (ClassCastException e) {
            Assert.fail((String)("Unexpected unwrapped type: " + e.getMessage()));
        }
    }

    @Test
    public void testInfo() {
        io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-log4j2-logger");
        String result = recording.execute(() -> logger.info((Object)"hello"));
        Assert.assertTrue((boolean)result.contains("hello"));
        result = recording.execute(() -> logger.info((Object)"exception", (Throwable)new NullPointerException()));
        Assert.assertTrue((boolean)result.contains("exception"));
        Assert.assertTrue((boolean)result.contains("java.lang.NullPointerException"));
        result = recording.execute(() -> logger.info((Object)"hello {} and {}", new Object[]{"Paulo", "Julien"}));
        Assert.assertTrue((boolean)result.contains("hello Paulo and Julien"));
        result = recording.execute(() -> logger.info((Object)"hello {}", new Object[]{"vert.x"}));
        String expected = "hello vert.x";
        Assert.assertTrue((String)("Was expected <" + result + "> to contain <" + expected + ">"), (boolean)result.contains(expected));
        result = recording.execute(() -> logger.info((Object)"hello {} - {}", new Object[]{"vert.x"}));
        Assert.assertTrue((boolean)result.contains("hello vert.x - {}"));
        result = recording.execute(() -> logger.info((Object)"hello {} {}", new Object[]{"vert.x", "foo"}));
        Assert.assertTrue((boolean)result.contains("hello vert.x foo"));
        result = recording.execute(() -> logger.info((Object)"{}, an exception has been thrown", (Throwable)new IllegalStateException(), new Object[]{"Luke"}));
        Assert.assertTrue((boolean)result.contains("Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
        result = recording.execute(() -> logger.info((Object)"{}, an exception has been thrown", new Object[]{"Luke", new IllegalStateException()}));
        Assert.assertTrue((boolean)result.contains("Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
    }

    @Test
    public void testError() {
        io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-log4j2-logger");
        String result = recording.execute(() -> logger.error((Object)"hello"));
        Assert.assertTrue((boolean)result.contains("hello"));
        result = recording.execute(() -> logger.error((Object)"exception", (Throwable)new NullPointerException()));
        Assert.assertTrue((boolean)result.contains("exception"));
        Assert.assertTrue((boolean)result.contains("java.lang.NullPointerException"));
        result = recording.execute(() -> logger.error((Object)"hello {} and {}", new Object[]{"Paulo", "Julien"}));
        Assert.assertTrue((boolean)result.contains("hello Paulo and Julien"));
        result = recording.execute(() -> logger.error((Object)"hello {}", new Object[]{"vert.x"}));
        Assert.assertTrue((boolean)result.contains("hello vert.x"));
        result = recording.execute(() -> logger.error((Object)"hello {} - {}", new Object[]{"vert.x"}));
        Assert.assertTrue((boolean)result.contains("hello vert.x - {}"));
        result = recording.execute(() -> logger.error((Object)"hello {} {}", new Object[]{"vert.x", "foo"}));
        String expected = "hello vert.x foo";
        Assert.assertTrue((String)("Was expected <" + result + "> to contain <" + expected + ">"), (boolean)result.contains(expected));
        result = recording.execute(() -> logger.error((Object)"{}, an exception has been thrown", (Throwable)new IllegalStateException(), new Object[]{"Luke"}));
        Assert.assertTrue((boolean)result.contains("Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
        result = recording.execute(() -> logger.error((Object)"{}, an exception has been thrown", new Object[]{"Luke", new IllegalStateException()}));
        Assert.assertTrue((boolean)result.contains("Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
    }

    @Test
    public void testWarning() {
        io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-log4j2-logger");
        String result = recording.execute(() -> logger.warn((Object)"hello"));
        Assert.assertTrue((boolean)result.contains("hello"));
        result = recording.execute(() -> logger.warn((Object)"exception", (Throwable)new NullPointerException()));
        Assert.assertTrue((boolean)result.contains("exception"));
        Assert.assertTrue((boolean)result.contains("java.lang.NullPointerException"));
        result = recording.execute(() -> logger.warn((Object)"hello {} and {}", new Object[]{"Paulo", "Julien"}));
        Assert.assertTrue((boolean)result.contains("hello Paulo and Julien"));
        result = recording.execute(() -> logger.warn((Object)"hello {}", new Object[]{"vert.x"}));
        Assert.assertTrue((boolean)result.contains("hello vert.x"));
        result = recording.execute(() -> logger.warn((Object)"hello {} - {}", new Object[]{"vert.x"}));
        Assert.assertTrue((boolean)result.contains("hello vert.x - {}"));
        result = recording.execute(() -> logger.warn((Object)"hello {} {}", new Object[]{"vert.x", "foo"}));
        String expected = "hello vert.x foo";
        Assert.assertTrue((String)("Was expected <" + result + "> to contain <" + expected + ">"), (boolean)result.contains(expected));
        result = recording.execute(() -> logger.warn((Object)"{}, an exception has been thrown", (Throwable)new IllegalStateException(), new Object[]{"Luke"}));
        Assert.assertTrue((boolean)result.contains("Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
        result = recording.execute(() -> logger.warn((Object)"{}, an exception has been thrown", new Object[]{"Luke", new IllegalStateException()}));
        Assert.assertTrue((boolean)result.contains("Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
    }

    @Test
    public void testMethodName() {
        final io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-log4j2-logger");
        String result = recording.execute(new Runnable(){

            @Override
            public void run() {
                logger.warn((Object)"hello");
            }
        });
        Assert.assertTrue((boolean)result.contains(".run:"));
    }
}

