/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.it;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.LogManager;

public class StreamRecording {
    private static final PrintStream ORIGINAL_ERR = System.err;
    private ByteArrayOutputStream error = new ByteArrayOutputStream();

    public StreamRecording() throws IOException {
        LogManager.getLogManager().reset();
        LogManager.getLogManager().readConfiguration();
    }

    public void start() {
        this.error.reset();
        System.setErr(new PrintStream(this.error));
    }

    public void stop() {
        if (System.err != ORIGINAL_ERR) {
            System.setErr(ORIGINAL_ERR);
        }
    }

    public String get() {
        try {
            this.error.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.error.toString();
    }

    public void terminate() {
        if (System.err != ORIGINAL_ERR) {
            System.setErr(ORIGINAL_ERR);
        }
    }

    public String execute(Runnable runnable) {
        this.start();
        runnable.run();
        String result = this.get();
        this.stop();
        return result;
    }
}

