/*
 * Copyright (c) 2011-2019 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */

package io.vertx.core.http.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * We do our own mapping since support for mime mapping in Java is platform dependent
 * and doesn't seem to work very well
 *
 * @author <a href="http://tfox.org">Tim Fox</a>
 */
public final class MimeMapping {

  private static final Map<String, String> MAPPING;

  static {
    Map<String, String> mapping = new HashMap<>();
    mapping.put("ez", "application/andrew-inset");
    mapping.put("aw", "application/applixware");
    mapping.put("atom", "application/atom+xml");
    mapping.put("atomcat", "application/atomcat+xml");
    mapping.put("atomsvc", "application/atomsvc+xml");
    mapping.put("ccxml", "application/ccxml+xml");
    mapping.put("cdmia", "application/cdmi-capability");
    mapping.put("cdmic", "application/cdmi-container");
    mapping.put("cdmid", "application/cdmi-domain");
    mapping.put("cdmio", "application/cdmi-object");
    mapping.put("cdmiq", "application/cdmi-queue");
    mapping.put("cu", "application/cu-seeme");
    mapping.put("davmount", "application/davmount+xml");
    mapping.put("dbk", "application/docbook+xml");
    mapping.put("dssc", "application/dssc+der");
    mapping.put("xdssc", "application/dssc+xml");
    mapping.put("ecma", "application/ecmascript");
    mapping.put("emma", "application/emma+xml");
    mapping.put("epub", "application/epub+zip");
    mapping.put("exi", "application/exi");
    mapping.put("pfr", "application/font-tdpfr");
    mapping.put("gml", "application/gml+xml");
    mapping.put("gpx", "application/gpx+xml");
    mapping.put("gxf", "application/gxf");
    mapping.put("stk", "application/hyperstudio");
    mapping.put("ink", "application/inkml+xml");
    mapping.put("inkml", "application/inkml+xml");
    mapping.put("ipfix", "application/ipfix");
    mapping.put("jar", "application/java-archive");
    mapping.put("ser", "application/java-serialized-object");
    mapping.put("class", "application/java-vm");
    mapping.put("js", "text/javascript");
    mapping.put("mjs", "text/javascript");
    mapping.put("json", "application/json");
    mapping.put("jsonml", "application/jsonml+json");
    mapping.put("lostxml", "application/lost+xml");
    mapping.put("hqx", "application/mac-binhex40");
    mapping.put("cpt", "application/mac-compactpro");
    mapping.put("mads", "application/mads+xml");
    mapping.put("mrc", "application/marc");
    mapping.put("mrcx", "application/marcxml+xml");
    mapping.put("ma", "application/mathematica");
    mapping.put("nb", "application/mathematica");
    mapping.put("mb", "application/mathematica");
    mapping.put("mathml", "application/mathml+xml");
    mapping.put("mbox", "application/mbox");
    mapping.put("mscml", "application/mediaservercontrol+xml");
    mapping.put("metalink", "application/metalink+xml");
    mapping.put("meta4", "application/metalink4+xml");
    mapping.put("mets", "application/mets+xml");
    mapping.put("mods", "application/mods+xml");
    mapping.put("m21", "application/mp21");
    mapping.put("mp21", "application/mp21");
    mapping.put("mp4s", "application/mp4");
    mapping.put("doc", "application/msword");
    mapping.put("dot", "application/msword");
    mapping.put("mxf", "application/mxf");
    mapping.put("bin", "application/octet-stream");
    mapping.put("dms", "application/octet-stream");
    mapping.put("lrf", "application/octet-stream");
    mapping.put("mar", "application/octet-stream");
    mapping.put("so", "application/octet-stream");
    mapping.put("dist", "application/octet-stream");
    mapping.put("distz", "application/octet-stream");
    mapping.put("pkg", "application/octet-stream");
    mapping.put("bpk", "application/octet-stream");
    mapping.put("dump", "application/octet-stream");
    mapping.put("elc", "application/octet-stream");
    mapping.put("deploy", "application/octet-stream");
    mapping.put("oda", "application/oda");
    mapping.put("opf", "application/oebps-package+xml");
    mapping.put("ogx", "application/ogg");
    mapping.put("omdoc", "application/omdoc+xml");
    mapping.put("onetoc", "application/onenote");
    mapping.put("onetoc2", "application/onenote");
    mapping.put("onetmp", "application/onenote");
    mapping.put("onepkg", "application/onenote");
    mapping.put("oxps", "application/oxps");
    mapping.put("xer", "application/patch-ops-error+xml");
    mapping.put("pdf", "application/pdf");
    mapping.put("pgp", "application/pgp-encrypted");
    mapping.put("asc", "application/pgp-signature");
    mapping.put("sig", "application/pgp-signature");
    mapping.put("prf", "application/pics-rules");
    mapping.put("p10", "application/pkcs10");
    mapping.put("p7m", "application/pkcs7-mime");
    mapping.put("p7c", "application/pkcs7-mime");
    mapping.put("p7s", "application/pkcs7-signature");
    mapping.put("p8", "application/pkcs8");
    mapping.put("ac", "application/pkix-attr-cert");
    mapping.put("cer", "application/pkix-cert");
    mapping.put("crl", "application/pkix-crl");
    mapping.put("pkipath", "application/pkix-pkipath");
    mapping.put("pki", "application/pkixcmp");
    mapping.put("pls", "application/pls+xml");
    mapping.put("ai", "application/postscript");
    mapping.put("eps", "application/postscript");
    mapping.put("ps", "application/postscript");
    mapping.put("cww", "application/prs.cww");
    mapping.put("pskcxml", "application/pskc+xml");
    mapping.put("rdf", "application/rdf+xml");
    mapping.put("rif", "application/reginfo+xml");
    mapping.put("rnc", "application/relax-ng-compact-syntax");
    mapping.put("rl", "application/resource-lists+xml");
    mapping.put("rld", "application/resource-lists-diff+xml");
    mapping.put("rs", "application/rls-services+xml");
    mapping.put("gbr", "application/rpki-ghostbusters");
    mapping.put("mft", "application/rpki-manifest");
    mapping.put("roa", "application/rpki-roa");
    mapping.put("rsd", "application/rsd+xml");
    mapping.put("rss", "application/rss+xml");
    mapping.put("rtf", "application/rtf");
    mapping.put("sbml", "application/sbml+xml");
    mapping.put("scq", "application/scvp-cv-request");
    mapping.put("scs", "application/scvp-cv-response");
    mapping.put("spq", "application/scvp-vp-request");
    mapping.put("spp", "application/scvp-vp-response");
    mapping.put("sdp", "application/sdp");
    mapping.put("setpay", "application/set-payment-initiation");
    mapping.put("setreg", "application/set-registration-initiation");
    mapping.put("shf", "application/shf+xml");
    mapping.put("smi", "application/smil+xml");
    mapping.put("smil", "application/smil+xml");
    mapping.put("rq", "application/sparql-query");
    mapping.put("srx", "application/sparql-results+xml");
    mapping.put("gram", "application/srgs");
    mapping.put("grxml", "application/srgs+xml");
    mapping.put("sru", "application/sru+xml");
    mapping.put("ssdl", "application/ssdl+xml");
    mapping.put("ssml", "application/ssml+xml");
    mapping.put("tei", "application/tei+xml");
    mapping.put("teicorpus", "application/tei+xml");
    mapping.put("tfi", "application/thraud+xml");
    mapping.put("tsd", "application/timestamped-data");
    mapping.put("plb", "application/vnd.3gpp.pic-bw-large");
    mapping.put("psb", "application/vnd.3gpp.pic-bw-small");
    mapping.put("pvb", "application/vnd.3gpp.pic-bw-var");
    mapping.put("tcap", "application/vnd.3gpp2.tcap");
    mapping.put("pwn", "application/vnd.3m.post-it-notes");
    mapping.put("aso", "application/vnd.accpac.simply.aso");
    mapping.put("imp", "application/vnd.accpac.simply.imp");
    mapping.put("acu", "application/vnd.acucobol");
    mapping.put("atc", "application/vnd.acucorp");
    mapping.put("acutc", "application/vnd.acucorp");
    mapping.put("air", "application/vnd.adobe.air-application-installer-package+zip");
    mapping.put("fcdt", "application/vnd.adobe.formscentral.fcdt");
    mapping.put("fxp", "application/vnd.adobe.fxp");
    mapping.put("fxpl", "application/vnd.adobe.fxp");
    mapping.put("xdp", "application/vnd.adobe.xdp+xml");
    mapping.put("xfdf", "application/vnd.adobe.xfdf");
    mapping.put("ahead", "application/vnd.ahead.space");
    mapping.put("azf", "application/vnd.airzip.filesecure.azf");
    mapping.put("azs", "application/vnd.airzip.filesecure.azs");
    mapping.put("azw", "application/vnd.amazon.ebook");
    mapping.put("acc", "application/vnd.americandynamics.acc");
    mapping.put("ami", "application/vnd.amiga.ami");
    mapping.put("apk", "application/vnd.android.package-archive");
    mapping.put("cii", "application/vnd.anser-web-certificate-issue-initiation");
    mapping.put("fti", "application/vnd.anser-web-funds-transfer-initiation");
    mapping.put("atx", "application/vnd.antix.game-component");
    mapping.put("mpkg", "application/vnd.apple.installer+xml");
    mapping.put("m3u8", "application/vnd.apple.mpegurl");
    mapping.put("swi", "application/vnd.aristanetworks.swi");
    mapping.put("iota", "application/vnd.astraea-software.iota");
    mapping.put("aep", "application/vnd.audiograph");
    mapping.put("mpm", "application/vnd.blueice.multipass");
    mapping.put("bmi", "application/vnd.bmi");
    mapping.put("rep", "application/vnd.businessobjects");
    mapping.put("cdxml", "application/vnd.chemdraw+xml");
    mapping.put("mmd", "application/vnd.chipnuts.karaoke-mmd");
    mapping.put("cdy", "application/vnd.cinderella");
    mapping.put("cla", "application/vnd.claymore");
    mapping.put("rp9", "application/vnd.cloanto.rp9");
    mapping.put("c4g", "application/vnd.clonk.c4group");
    mapping.put("c4d", "application/vnd.clonk.c4group");
    mapping.put("c4f", "application/vnd.clonk.c4group");
    mapping.put("c4p", "application/vnd.clonk.c4group");
    mapping.put("c4u", "application/vnd.clonk.c4group");
    mapping.put("c11amc", "application/vnd.cluetrust.cartomobile-config");
    mapping.put("c11amz", "application/vnd.cluetrust.cartomobile-config-pkg");
    mapping.put("csp", "application/vnd.commonspace");
    mapping.put("cdbcmsg", "application/vnd.contact.cmsg");
    mapping.put("cmc", "application/vnd.cosmocaller");
    mapping.put("clkx", "application/vnd.crick.clicker");
    mapping.put("clkk", "application/vnd.crick.clicker.keyboard");
    mapping.put("clkp", "application/vnd.crick.clicker.palette");
    mapping.put("clkt", "application/vnd.crick.clicker.template");
    mapping.put("clkw", "application/vnd.crick.clicker.wordbank");
    mapping.put("wbs", "application/vnd.criticaltools.wbs+xml");
    mapping.put("pml", "application/vnd.ctc-posml");
    mapping.put("ppd", "application/vnd.cups-ppd");
    mapping.put("car", "application/vnd.curl.car");
    mapping.put("pcurl", "application/vnd.curl.pcurl");
    mapping.put("dart", "application/vnd.dart");
    mapping.put("rdz", "application/vnd.data-vision.rdz");
    mapping.put("uvf", "application/vnd.dece.data");
    mapping.put("uvvf", "application/vnd.dece.data");
    mapping.put("uvd", "application/vnd.dece.data");
    mapping.put("uvvd", "application/vnd.dece.data");
    mapping.put("uvt", "application/vnd.dece.ttml+xml");
    mapping.put("uvvt", "application/vnd.dece.ttml+xml");
    mapping.put("uvx", "application/vnd.dece.unspecified");
    mapping.put("uvvx", "application/vnd.dece.unspecified");
    mapping.put("uvz", "application/vnd.dece.zip");
    mapping.put("uvvz", "application/vnd.dece.zip");
    mapping.put("fe_launch", "application/vnd.denovo.fcselayout-link");
    mapping.put("dna", "application/vnd.dna");
    mapping.put("mlp", "application/vnd.dolby.mlp");
    mapping.put("dpg", "application/vnd.dpgraph");
    mapping.put("dfac", "application/vnd.dreamfactory");
    mapping.put("kpxx", "application/vnd.ds-keypoint");
    mapping.put("ait", "application/vnd.dvb.ait");
    mapping.put("svc", "application/vnd.dvb.service");
    mapping.put("geo", "application/vnd.dynageo");
    mapping.put("mag", "application/vnd.ecowin.chart");
    mapping.put("nml", "application/vnd.enliven");
    mapping.put("esf", "application/vnd.epson.esf");
    mapping.put("msf", "application/vnd.epson.msf");
    mapping.put("qam", "application/vnd.epson.quickanime");
    mapping.put("slt", "application/vnd.epson.salt");
    mapping.put("ssf", "application/vnd.epson.ssf");
    mapping.put("es3", "application/vnd.eszigno3+xml");
    mapping.put("et3", "application/vnd.eszigno3+xml");
    mapping.put("ez2", "application/vnd.ezpix-album");
    mapping.put("ez3", "application/vnd.ezpix-package");
    mapping.put("fdf", "application/vnd.fdf");
    mapping.put("mseed", "application/vnd.fdsn.mseed");
    mapping.put("seed", "application/vnd.fdsn.seed");
    mapping.put("dataless", "application/vnd.fdsn.seed");
    mapping.put("gph", "application/vnd.flographit");
    mapping.put("ftc", "application/vnd.fluxtime.clip");
    mapping.put("fm", "application/vnd.framemaker");
    mapping.put("frame", "application/vnd.framemaker");
    mapping.put("maker", "application/vnd.framemaker");
    mapping.put("book", "application/vnd.framemaker");
    mapping.put("fnc", "application/vnd.frogans.fnc");
    mapping.put("ltf", "application/vnd.frogans.ltf");
    mapping.put("fsc", "application/vnd.fsc.weblaunch");
    mapping.put("oas", "application/vnd.fujitsu.oasys");
    mapping.put("oa2", "application/vnd.fujitsu.oasys2");
    mapping.put("oa3", "application/vnd.fujitsu.oasys3");
    mapping.put("fg5", "application/vnd.fujitsu.oasysgp");
    mapping.put("bh2", "application/vnd.fujitsu.oasysprs");
    mapping.put("ddd", "application/vnd.fujixerox.ddd");
    mapping.put("xdw", "application/vnd.fujixerox.docuworks");
    mapping.put("xbd", "application/vnd.fujixerox.docuworks.binder");
    mapping.put("fzs", "application/vnd.fuzzysheet");
    mapping.put("txd", "application/vnd.genomatix.tuxedo");
    mapping.put("ggb", "application/vnd.geogebra.file");
    mapping.put("ggt", "application/vnd.geogebra.tool");
    mapping.put("gex", "application/vnd.geometry-explorer");
    mapping.put("gre", "application/vnd.geometry-explorer");
    mapping.put("gxt", "application/vnd.geonext");
    mapping.put("g2w", "application/vnd.geoplan");
    mapping.put("g3w", "application/vnd.geospace");
    mapping.put("gmx", "application/vnd.gmx");
    mapping.put("kml", "application/vnd.google-earth.kml+xml");
    mapping.put("kmz", "application/vnd.google-earth.kmz");
    mapping.put("gqf", "application/vnd.grafeq");
    mapping.put("gqs", "application/vnd.grafeq");
    mapping.put("gac", "application/vnd.groove-account");
    mapping.put("ghf", "application/vnd.groove-help");
    mapping.put("gim", "application/vnd.groove-identity-message");
    mapping.put("grv", "application/vnd.groove-injector");
    mapping.put("gtm", "application/vnd.groove-tool-message");
    mapping.put("tpl", "application/vnd.groove-tool-template");
    mapping.put("vcg", "application/vnd.groove-vcard");
    mapping.put("hal", "application/vnd.hal+xml");
    mapping.put("zmm", "application/vnd.handheld-entertainment+xml");
    mapping.put("hbci", "application/vnd.hbci");
    mapping.put("les", "application/vnd.hhe.lesson-player");
    mapping.put("hpgl", "application/vnd.hp-hpgl");
    mapping.put("hpid", "application/vnd.hp-hpid");
    mapping.put("hps", "application/vnd.hp-hps");
    mapping.put("jlt", "application/vnd.hp-jlyt");
    mapping.put("pcl", "application/vnd.hp-pcl");
    mapping.put("pclxl", "application/vnd.hp-pclxl");
    mapping.put("sfd-hdstx", "application/vnd.hydrostatix.sof-data");
    mapping.put("mpy", "application/vnd.ibm.minipay");
    mapping.put("afp", "application/vnd.ibm.modcap");
    mapping.put("listafp", "application/vnd.ibm.modcap");
    mapping.put("list3820", "application/vnd.ibm.modcap");
    mapping.put("irm", "application/vnd.ibm.rights-management");
    mapping.put("sc", "application/vnd.ibm.secure-container");
    mapping.put("icc", "application/vnd.iccprofile");
    mapping.put("icm", "application/vnd.iccprofile");
    mapping.put("igl", "application/vnd.igloader");
    mapping.put("ivp", "application/vnd.immervision-ivp");
    mapping.put("ivu", "application/vnd.immervision-ivu");
    mapping.put("igm", "application/vnd.insors.igm");
    mapping.put("xpw", "application/vnd.intercon.formnet");
    mapping.put("xpx", "application/vnd.intercon.formnet");
    mapping.put("i2g", "application/vnd.intergeo");
    mapping.put("qbo", "application/vnd.intu.qbo");
    mapping.put("qfx", "application/vnd.intu.qfx");
    mapping.put("rcprofile", "application/vnd.ipunplugged.rcprofile");
    mapping.put("irp", "application/vnd.irepository.package+xml");
    mapping.put("xpr", "application/vnd.is-xpr");
    mapping.put("fcs", "application/vnd.isac.fcs");
    mapping.put("jam", "application/vnd.jam");
    mapping.put("rms", "application/vnd.jcp.javame.midlet-rms");
    mapping.put("jisp", "application/vnd.jisp");
    mapping.put("joda", "application/vnd.joost.joda-archive");
    mapping.put("ktz", "application/vnd.kahootz");
    mapping.put("ktr", "application/vnd.kahootz");
    mapping.put("karbon", "application/vnd.kde.karbon");
    mapping.put("chrt", "application/vnd.kde.kchart");
    mapping.put("kfo", "application/vnd.kde.kformula");
    mapping.put("flw", "application/vnd.kde.kivio");
    mapping.put("kon", "application/vnd.kde.kontour");
    mapping.put("kpr", "application/vnd.kde.kpresenter");
    mapping.put("kpt", "application/vnd.kde.kpresenter");
    mapping.put("ksp", "application/vnd.kde.kspread");
    mapping.put("kwd", "application/vnd.kde.kword");
    mapping.put("kwt", "application/vnd.kde.kword");
    mapping.put("htke", "application/vnd.kenameaapp");
    mapping.put("kia", "application/vnd.kidspiration");
    mapping.put("kne", "application/vnd.kinar");
    mapping.put("knp", "application/vnd.kinar");
    mapping.put("skp", "application/vnd.koan");
    mapping.put("skd", "application/vnd.koan");
    mapping.put("skt", "application/vnd.koan");
    mapping.put("skm", "application/vnd.koan");
    mapping.put("sse", "application/vnd.kodak-descriptor");
    mapping.put("lasxml", "application/vnd.las.las+xml");
    mapping.put("lbd", "application/vnd.llamagraphics.life-balance.desktop");
    mapping.put("lbe", "application/vnd.llamagraphics.life-balance.exchange+xml");
    mapping.put("123", "application/vnd.lotus-1-2-3");
    mapping.put("apr", "application/vnd.lotus-approach");
    mapping.put("pre", "application/vnd.lotus-freelance");
    mapping.put("nsf", "application/vnd.lotus-notes");
    mapping.put("org", "application/vnd.lotus-organizer");
    mapping.put("scm", "application/vnd.lotus-screencam");
    mapping.put("lwp", "application/vnd.lotus-wordpro");
    mapping.put("portpkg", "application/vnd.macports.portpkg");
    mapping.put("mcd", "application/vnd.mcd");
    mapping.put("mc1", "application/vnd.medcalcdata");
    mapping.put("cdkey", "application/vnd.mediastation.cdkey");
    mapping.put("mwf", "application/vnd.mfer");
    mapping.put("mfm", "application/vnd.mfmp");
    mapping.put("flo", "application/vnd.micrografx.flo");
    mapping.put("igx", "application/vnd.micrografx.igx");
    mapping.put("mif", "application/vnd.mif");
    mapping.put("daf", "application/vnd.mobius.daf");
    mapping.put("dis", "application/vnd.mobius.dis");
    mapping.put("mbk", "application/vnd.mobius.mbk");
    mapping.put("mqy", "application/vnd.mobius.mqy");
    mapping.put("msl", "application/vnd.mobius.msl");
    mapping.put("plc", "application/vnd.mobius.plc");
    mapping.put("txf", "application/vnd.mobius.txf");
    mapping.put("mpn", "application/vnd.mophun.application");
    mapping.put("mpc", "application/vnd.mophun.certificate");
    mapping.put("xul", "application/vnd.mozilla.xul+xml");
    mapping.put("cil", "application/vnd.ms-artgalry");
    mapping.put("cab", "application/vnd.ms-cab-compressed");
    mapping.put("xls", "application/vnd.ms-excel");
    mapping.put("xlm", "application/vnd.ms-excel");
    mapping.put("xla", "application/vnd.ms-excel");
    mapping.put("xlc", "application/vnd.ms-excel");
    mapping.put("xlt", "application/vnd.ms-excel");
    mapping.put("xlw", "application/vnd.ms-excel");
    mapping.put("xlam", "application/vnd.ms-excel.addin.macroenabled.12");
    mapping.put("xlsb", "application/vnd.ms-excel.sheet.binary.macroenabled.12");
    mapping.put("xlsm", "application/vnd.ms-excel.sheet.macroenabled.12");
    mapping.put("xltm", "application/vnd.ms-excel.template.macroenabled.12");
    mapping.put("eot", "application/vnd.ms-fontobject");
    mapping.put("chm", "application/vnd.ms-htmlhelp");
    mapping.put("ims", "application/vnd.ms-ims");
    mapping.put("lrm", "application/vnd.ms-lrm");
    mapping.put("thmx", "application/vnd.ms-officetheme");
    mapping.put("cat", "application/vnd.ms-pki.seccat");
    mapping.put("stl", "application/vnd.ms-pki.stl");
    mapping.put("ppt", "application/vnd.ms-powerpoint");
    mapping.put("pps", "application/vnd.ms-powerpoint");
    mapping.put("pot", "application/vnd.ms-powerpoint");
    mapping.put("ppam", "application/vnd.ms-powerpoint.addin.macroenabled.12");
    mapping.put("pptm", "application/vnd.ms-powerpoint.presentation.macroenabled.12");
    mapping.put("sldm", "application/vnd.ms-powerpoint.slide.macroenabled.12");
    mapping.put("ppsm", "application/vnd.ms-powerpoint.slideshow.macroenabled.12");
    mapping.put("potm", "application/vnd.ms-powerpoint.template.macroenabled.12");
    mapping.put("mpp", "application/vnd.ms-project");
    mapping.put("mpt", "application/vnd.ms-project");
    mapping.put("docm", "application/vnd.ms-word.document.macroenabled.12");
    mapping.put("dotm", "application/vnd.ms-word.template.macroenabled.12");
    mapping.put("wps", "application/vnd.ms-works");
    mapping.put("wks", "application/vnd.ms-works");
    mapping.put("wcm", "application/vnd.ms-works");
    mapping.put("wdb", "application/vnd.ms-works");
    mapping.put("wpl", "application/vnd.ms-wpl");
    mapping.put("xps", "application/vnd.ms-xpsdocument");
    mapping.put("mseq", "application/vnd.mseq");
    mapping.put("mus", "application/vnd.musician");
    mapping.put("msty", "application/vnd.muvee.style");
    mapping.put("taglet", "application/vnd.mynfc");
    mapping.put("nlu", "application/vnd.neurolanguage.nlu");
    mapping.put("ntf", "application/vnd.nitf");
    mapping.put("nitf", "application/vnd.nitf");
    mapping.put("nnd", "application/vnd.noblenet-directory");
    mapping.put("nns", "application/vnd.noblenet-sealer");
    mapping.put("nnw", "application/vnd.noblenet-web");
    mapping.put("ngdat", "application/vnd.nokia.n-gage.data");
    mapping.put("n-gage", "application/vnd.nokia.n-gage.symbian.install");
    mapping.put("rpst", "application/vnd.nokia.radio-preset");
    mapping.put("rpss", "application/vnd.nokia.radio-presets");
    mapping.put("edm", "application/vnd.novadigm.edm");
    mapping.put("edx", "application/vnd.novadigm.edx");
    mapping.put("ext", "application/vnd.novadigm.ext");
    mapping.put("odc", "application/vnd.oasis.opendocument.chart");
    mapping.put("otc", "application/vnd.oasis.opendocument.chart-template");
    mapping.put("odb", "application/vnd.oasis.opendocument.database");
    mapping.put("odf", "application/vnd.oasis.opendocument.formula");
    mapping.put("odft", "application/vnd.oasis.opendocument.formula-template");
    mapping.put("odg", "application/vnd.oasis.opendocument.graphics");
    mapping.put("otg", "application/vnd.oasis.opendocument.graphics-template");
    mapping.put("odi", "application/vnd.oasis.opendocument.image");
    mapping.put("oti", "application/vnd.oasis.opendocument.image-template");
    mapping.put("odp", "application/vnd.oasis.opendocument.presentation");
    mapping.put("otp", "application/vnd.oasis.opendocument.presentation-template");
    mapping.put("ods", "application/vnd.oasis.opendocument.spreadsheet");
    mapping.put("ots", "application/vnd.oasis.opendocument.spreadsheet-template");
    mapping.put("odt", "application/vnd.oasis.opendocument.text");
    mapping.put("odm", "application/vnd.oasis.opendocument.text-master");
    mapping.put("ott", "application/vnd.oasis.opendocument.text-template");
    mapping.put("oth", "application/vnd.oasis.opendocument.text-web");
    mapping.put("xo", "application/vnd.olpc-sugar");
    mapping.put("dd2", "application/vnd.oma.dd2+xml");
    mapping.put("oxt", "application/vnd.openofficeorg.extension");
    mapping.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
    mapping.put("sldx", "application/vnd.openxmlformats-officedocument.presentationml.slide");
    mapping.put("ppsx", "application/vnd.openxmlformats-officedocument.presentationml.slideshow");
    mapping.put("potx", "application/vnd.openxmlformats-officedocument.presentationml.template");
    mapping.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    mapping.put("xltx", "application/vnd.openxmlformats-officedocument.spreadsheetml.template");
    mapping.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
    mapping.put("dotx", "application/vnd.openxmlformats-officedocument.wordprocessingml.template");
    mapping.put("mgp", "application/vnd.osgeo.mapguide.package");
    mapping.put("dp", "application/vnd.osgi.dp");
    mapping.put("esa", "application/vnd.osgi.subsystem");
    mapping.put("pdb", "application/vnd.palm");
    mapping.put("pqa", "application/vnd.palm");
    mapping.put("oprc", "application/vnd.palm");
    mapping.put("paw", "application/vnd.pawaafile");
    mapping.put("str", "application/vnd.pg.format");
    mapping.put("ei6", "application/vnd.pg.osasli");
    mapping.put("efif", "application/vnd.picsel");
    mapping.put("wg", "application/vnd.pmi.widget");
    mapping.put("plf", "application/vnd.pocketlearn");
    mapping.put("pbd", "application/vnd.powerbuilder6");
    mapping.put("box", "application/vnd.previewsystems.box");
    mapping.put("mgz", "application/vnd.proteus.magazine");
    mapping.put("qps", "application/vnd.publishare-delta-tree");
    mapping.put("ptid", "application/vnd.pvi.ptid1");
    mapping.put("qxd", "application/vnd.quark.quarkxpress");
    mapping.put("qxt", "application/vnd.quark.quarkxpress");
    mapping.put("qwd", "application/vnd.quark.quarkxpress");
    mapping.put("qwt", "application/vnd.quark.quarkxpress");
    mapping.put("qxl", "application/vnd.quark.quarkxpress");
    mapping.put("qxb", "application/vnd.quark.quarkxpress");
    mapping.put("bed", "application/vnd.realvnc.bed");
    mapping.put("mxl", "application/vnd.recordare.musicxml");
    mapping.put("musicxml", "application/vnd.recordare.musicxml+xml");
    mapping.put("cryptonote", "application/vnd.rig.cryptonote");
    mapping.put("cod", "application/vnd.rim.cod");
    mapping.put("rm", "application/vnd.rn-realmedia");
    mapping.put("rmvb", "application/vnd.rn-realmedia-vbr");
    mapping.put("link66", "application/vnd.route66.link66+xml");
    mapping.put("st", "application/vnd.sailingtracker.track");
    mapping.put("see", "application/vnd.seemail");
    mapping.put("sema", "application/vnd.sema");
    mapping.put("semd", "application/vnd.semd");
    mapping.put("semf", "application/vnd.semf");
    mapping.put("ifm", "application/vnd.shana.informed.formdata");
    mapping.put("itp", "application/vnd.shana.informed.formtemplate");
    mapping.put("iif", "application/vnd.shana.informed.interchange");
    mapping.put("ipk", "application/vnd.shana.informed.package");
    mapping.put("twd", "application/vnd.simtech-mindmapper");
    mapping.put("twds", "application/vnd.simtech-mindmapper");
    mapping.put("mmf", "application/vnd.smaf");
    mapping.put("teacher", "application/vnd.smart.teacher");
    mapping.put("sdkm", "application/vnd.solent.sdkm+xml");
    mapping.put("sdkd", "application/vnd.solent.sdkm+xml");
    mapping.put("dxp", "application/vnd.spotfire.dxp");
    mapping.put("sfs", "application/vnd.spotfire.sfs");
    mapping.put("sdc", "application/vnd.stardivision.calc");
    mapping.put("sda", "application/vnd.stardivision.draw");
    mapping.put("sdd", "application/vnd.stardivision.impress");
    mapping.put("smf", "application/vnd.stardivision.math");
    mapping.put("sdw", "application/vnd.stardivision.writer");
    mapping.put("vor", "application/vnd.stardivision.writer");
    mapping.put("sgl", "application/vnd.stardivision.writer-global");
    mapping.put("smzip", "application/vnd.stepmania.package");
    mapping.put("sm", "application/vnd.stepmania.stepchart");
    mapping.put("sxc", "application/vnd.sun.xml.calc");
    mapping.put("stc", "application/vnd.sun.xml.calc.template");
    mapping.put("sxd", "application/vnd.sun.xml.draw");
    mapping.put("std", "application/vnd.sun.xml.draw.template");
    mapping.put("sxi", "application/vnd.sun.xml.impress");
    mapping.put("sti", "application/vnd.sun.xml.impress.template");
    mapping.put("sxm", "application/vnd.sun.xml.math");
    mapping.put("sxw", "application/vnd.sun.xml.writer");
    mapping.put("sxg", "application/vnd.sun.xml.writer.global");
    mapping.put("stw", "application/vnd.sun.xml.writer.template");
    mapping.put("sus", "application/vnd.sus-calendar");
    mapping.put("susp", "application/vnd.sus-calendar");
    mapping.put("svd", "application/vnd.svd");
    mapping.put("sis", "application/vnd.symbian.install");
    mapping.put("sisx", "application/vnd.symbian.install");
    mapping.put("xsm", "application/vnd.syncml+xml");
    mapping.put("bdm", "application/vnd.syncml.dm+wbxml");
    mapping.put("xdm", "application/vnd.syncml.dm+xml");
    mapping.put("tao", "application/vnd.tao.intent-module-archive");
    mapping.put("pcap", "application/vnd.tcpdump.pcap");
    mapping.put("cap", "application/vnd.tcpdump.pcap");
    mapping.put("dmp", "application/vnd.tcpdump.pcap");
    mapping.put("tmo", "application/vnd.tmobile-livetv");
    mapping.put("tpt", "application/vnd.trid.tpt");
    mapping.put("mxs", "application/vnd.triscape.mxs");
    mapping.put("tra", "application/vnd.trueapp");
    mapping.put("ufd", "application/vnd.ufdl");
    mapping.put("ufdl", "application/vnd.ufdl");
    mapping.put("utz", "application/vnd.uiq.theme");
    mapping.put("umj", "application/vnd.umajin");
    mapping.put("unityweb", "application/vnd.unity");
    mapping.put("uoml", "application/vnd.uoml+xml");
    mapping.put("vcx", "application/vnd.vcx");
    mapping.put("vsd", "application/vnd.visio");
    mapping.put("vst", "application/vnd.visio");
    mapping.put("vss", "application/vnd.visio");
    mapping.put("vsw", "application/vnd.visio");
    mapping.put("vis", "application/vnd.visionary");
    mapping.put("vsf", "application/vnd.vsf");
    mapping.put("wbxml", "application/vnd.wap.wbxml");
    mapping.put("wmlc", "application/vnd.wap.wmlc");
    mapping.put("wmlsc", "application/vnd.wap.wmlscriptc");
    mapping.put("wtb", "application/vnd.webturbo");
    mapping.put("nbp", "application/vnd.wolfram.player");
    mapping.put("wpd", "application/vnd.wordperfect");
    mapping.put("wqd", "application/vnd.wqd");
    mapping.put("stf", "application/vnd.wt.stf");
    mapping.put("xar", "application/vnd.xara");
    mapping.put("xfdl", "application/vnd.xfdl");
    mapping.put("hvd", "application/vnd.yamaha.hv-dic");
    mapping.put("hvs", "application/vnd.yamaha.hv-script");
    mapping.put("hvp", "application/vnd.yamaha.hv-voice");
    mapping.put("osf", "application/vnd.yamaha.openscoreformat");
    mapping.put("osfpvg", "application/vnd.yamaha.openscoreformat.osfpvg+xml");
    mapping.put("saf", "application/vnd.yamaha.smaf-audio");
    mapping.put("spf", "application/vnd.yamaha.smaf-phrase");
    mapping.put("cmp", "application/vnd.yellowriver-custom-menu");
    mapping.put("zir", "application/vnd.zul");
    mapping.put("zirz", "application/vnd.zul");
    mapping.put("zaz", "application/vnd.zzazz.deck+xml");
    mapping.put("vxml", "application/voicexml+xml");
    mapping.put("wasm", "application/wasm");
    mapping.put("wgt", "application/widget");
    mapping.put("hlp", "application/winhlp");
    mapping.put("wsdl", "application/wsdl+xml");
    mapping.put("wspolicy", "application/wspolicy+xml");
    mapping.put("7z", "application/x-7z-compressed");
    mapping.put("abw", "application/x-abiword");
    mapping.put("ace", "application/x-ace-compressed");
    mapping.put("dmg", "application/x-apple-diskimage");
    mapping.put("aab", "application/x-authorware-bin");
    mapping.put("x32", "application/x-authorware-bin");
    mapping.put("u32", "application/x-authorware-bin");
    mapping.put("vox", "application/x-authorware-bin");
    mapping.put("aam", "application/x-authorware-map");
    mapping.put("aas", "application/x-authorware-seg");
    mapping.put("bcpio", "application/x-bcpio");
    mapping.put("torrent", "application/x-bittorrent");
    mapping.put("blb", "application/x-blorb");
    mapping.put("blorb", "application/x-blorb");
    mapping.put("bz", "application/x-bzip");
    mapping.put("bz2", "application/x-bzip2");
    mapping.put("boz", "application/x-bzip2");
    mapping.put("cbr", "application/x-cbr");
    mapping.put("cba", "application/x-cbr");
    mapping.put("cbt", "application/x-cbr");
    mapping.put("cbz", "application/x-cbr");
    mapping.put("cb7", "application/x-cbr");
    mapping.put("vcd", "application/x-cdlink");
    mapping.put("cfs", "application/x-cfs-compressed");
    mapping.put("chat", "application/x-chat");
    mapping.put("pgn", "application/x-chess-pgn");
    mapping.put("nsc", "application/x-conference");
    mapping.put("cpio", "application/x-cpio");
    mapping.put("csh", "application/x-csh");
    mapping.put("deb", "application/x-debian-package");
    mapping.put("udeb", "application/x-debian-package");
    mapping.put("dgc", "application/x-dgc-compressed");
    mapping.put("dir", "application/x-director");
    mapping.put("dcr", "application/x-director");
    mapping.put("dxr", "application/x-director");
    mapping.put("cst", "application/x-director");
    mapping.put("cct", "application/x-director");
    mapping.put("cxt", "application/x-director");
    mapping.put("w3d", "application/x-director");
    mapping.put("fgd", "application/x-director");
    mapping.put("swa", "application/x-director");
    mapping.put("wad", "application/x-doom");
    mapping.put("ncx", "application/x-dtbncx+xml");
    mapping.put("dtb", "application/x-dtbook+xml");
    mapping.put("res", "application/x-dtbresource+xml");
    mapping.put("dvi", "application/x-dvi");
    mapping.put("evy", "application/x-envoy");
    mapping.put("eva", "application/x-eva");
    mapping.put("bdf", "application/x-font-bdf");
    mapping.put("gsf", "application/x-font-ghostscript");
    mapping.put("psf", "application/x-font-linux-psf");
    mapping.put("otf", "application/x-font-otf");
    mapping.put("pcf", "application/x-font-pcf");
    mapping.put("snf", "application/x-font-snf");
    mapping.put("ttf", "application/x-font-ttf");
    mapping.put("ttc", "application/x-font-ttf");
    mapping.put("pfa", "application/x-font-type1");
    mapping.put("pfb", "application/x-font-type1");
    mapping.put("pfm", "application/x-font-type1");
    mapping.put("afm", "application/x-font-type1");
    mapping.put("woff", "application/x-font-woff");
    mapping.put("woff2", "font/woff2");
    mapping.put("arc", "application/x-freearc");
    mapping.put("spl", "application/x-futuresplash");
    mapping.put("gca", "application/x-gca-compressed");
    mapping.put("ulx", "application/x-glulx");
    mapping.put("gnumeric", "application/x-gnumeric");
    mapping.put("gramps", "application/x-gramps-xml");
    mapping.put("gtar", "application/x-gtar");
    mapping.put("hdf", "application/x-hdf");
    mapping.put("install", "application/x-install-instructions");
    mapping.put("iso", "application/x-iso9660-image");
    mapping.put("jnlp", "application/x-java-jnlp-file");
    mapping.put("latex", "application/x-latex");
    mapping.put("lzh", "application/x-lzh-compressed");
    mapping.put("lha", "application/x-lzh-compressed");
    mapping.put("mie", "application/x-mie");
    mapping.put("prc", "application/x-mobipocket-ebook");
    mapping.put("mobi", "application/x-mobipocket-ebook");
    mapping.put("application", "application/x-ms-application");
    mapping.put("lnk", "application/x-ms-shortcut");
    mapping.put("wmd", "application/x-ms-wmd");
    mapping.put("wmz", "application/x-ms-wmz");
    mapping.put("xbap", "application/x-ms-xbap");
    mapping.put("mdb", "application/x-msaccess");
    mapping.put("obd", "application/x-msbinder");
    mapping.put("crd", "application/x-mscardfile");
    mapping.put("clp", "application/x-msclip");
    mapping.put("exe", "application/x-msdownload");
    mapping.put("dll", "application/x-msdownload");
    mapping.put("com", "application/x-msdownload");
    mapping.put("bat", "application/x-msdownload");
    mapping.put("msi", "application/x-msdownload");
    mapping.put("mvb", "application/x-msmediaview");
    mapping.put("m13", "application/x-msmediaview");
    mapping.put("m14", "application/x-msmediaview");
    mapping.put("wmf", "application/x-msmetafile");
    mapping.put("emf", "application/x-msmetafile");
    mapping.put("emz", "application/x-msmetafile");
    mapping.put("mny", "application/x-msmoney");
    mapping.put("pub", "application/x-mspublisher");
    mapping.put("scd", "application/x-msschedule");
    mapping.put("trm", "application/x-msterminal");
    mapping.put("wri", "application/x-mswrite");
    mapping.put("nc", "application/x-netcdf");
    mapping.put("cdf", "application/x-netcdf");
    mapping.put("nzb", "application/x-nzb");
    mapping.put("p12", "application/x-pkcs12");
    mapping.put("pfx", "application/x-pkcs12");
    mapping.put("p7b", "application/x-pkcs7-certificates");
    mapping.put("spc", "application/x-pkcs7-certificates");
    mapping.put("p7r", "application/x-pkcs7-certreqresp");
    mapping.put("rar", "application/x-rar-compressed");
    mapping.put("ris", "application/x-research-info-systems");
    mapping.put("sh", "application/x-sh");
    mapping.put("shar", "application/x-shar");
    mapping.put("swf", "application/x-shockwave-flash");
    mapping.put("xap", "application/x-silverlight-app");
    mapping.put("sql", "application/x-sql");
    mapping.put("sit", "application/x-stuffit");
    mapping.put("sitx", "application/x-stuffitx");
    mapping.put("srt", "application/x-subrip");
    mapping.put("sv4cpio", "application/x-sv4cpio");
    mapping.put("sv4crc", "application/x-sv4crc");
    mapping.put("t3", "application/x-t3vm-image");
    mapping.put("gam", "application/x-tads");
    mapping.put("tar", "application/x-tar");
    mapping.put("tcl", "application/x-tcl");
    mapping.put("tex", "application/x-tex");
    mapping.put("tfm", "application/x-tex-tfm");
    mapping.put("texinfo", "application/x-texinfo");
    mapping.put("texi", "application/x-texinfo");
    mapping.put("obj", "application/x-tgif");
    mapping.put("ustar", "application/x-ustar");
    mapping.put("src", "application/x-wais-source");
    mapping.put("der", "application/x-x509-ca-cert");
    mapping.put("crt", "application/x-x509-ca-cert");
    mapping.put("fig", "application/x-xfig");
    mapping.put("xlf", "application/x-xliff+xml");
    mapping.put("xpi", "application/x-xpinstall");
    mapping.put("xz", "application/x-xz");
    mapping.put("yml", "application/x-yaml");
    mapping.put("yaml", "application/x-yaml");
    mapping.put("z1", "application/x-zmachine");
    mapping.put("z2", "application/x-zmachine");
    mapping.put("z3", "application/x-zmachine");
    mapping.put("z4", "application/x-zmachine");
    mapping.put("z5", "application/x-zmachine");
    mapping.put("z6", "application/x-zmachine");
    mapping.put("z7", "application/x-zmachine");
    mapping.put("z8", "application/x-zmachine");
    mapping.put("xaml", "application/xaml+xml");
    mapping.put("xdf", "application/xcap-diff+xml");
    mapping.put("xenc", "application/xenc+xml");
    mapping.put("xhtml", "application/xhtml+xml");
    mapping.put("xht", "application/xhtml+xml");
    mapping.put("xml", "application/xml");
    mapping.put("xsl", "application/xml");
    mapping.put("dtd", "application/xml-dtd");
    mapping.put("xop", "application/xop+xml");
    mapping.put("xpl", "application/xproc+xml");
    mapping.put("xslt", "application/xslt+xml");
    mapping.put("xspf", "application/xspf+xml");
    mapping.put("mxml", "application/xv+xml");
    mapping.put("xhvml", "application/xv+xml");
    mapping.put("xvml", "application/xv+xml");
    mapping.put("xvm", "application/xv+xml");
    mapping.put("yang", "application/yang");
    mapping.put("yin", "application/yin+xml");
    mapping.put("zip", "application/zip");
    mapping.put("adp", "audio/adpcm");
    mapping.put("au", "audio/basic");
    mapping.put("snd", "audio/basic");
    mapping.put("mid", "audio/midi");
    mapping.put("midi", "audio/midi");
    mapping.put("kar", "audio/midi");
    mapping.put("rmi", "audio/midi");
    mapping.put("mp4a", "audio/mp4");
    mapping.put("mpga", "audio/mpeg");
    mapping.put("mp2", "audio/mpeg");
    mapping.put("mp2a", "audio/mpeg");
    mapping.put("mp3", "audio/mpeg");
    mapping.put("m2a", "audio/mpeg");
    mapping.put("m3a", "audio/mpeg");
    mapping.put("oga", "audio/ogg");
    mapping.put("ogg", "audio/ogg");
    mapping.put("spx", "audio/ogg");
    mapping.put("s3m", "audio/s3m");
    mapping.put("sil", "audio/silk");
    mapping.put("uva", "audio/vnd.dece.audio");
    mapping.put("uvva", "audio/vnd.dece.audio");
    mapping.put("eol", "audio/vnd.digital-winds");
    mapping.put("dra", "audio/vnd.dra");
    mapping.put("dts", "audio/vnd.dts");
    mapping.put("dtshd", "audio/vnd.dts.hd");
    mapping.put("lvp", "audio/vnd.lucent.voice");
    mapping.put("pya", "audio/vnd.ms-playready.media.pya");
    mapping.put("ecelp4800", "audio/vnd.nuera.ecelp4800");
    mapping.put("ecelp7470", "audio/vnd.nuera.ecelp7470");
    mapping.put("ecelp9600", "audio/vnd.nuera.ecelp9600");
    mapping.put("rip", "audio/vnd.rip");
    mapping.put("weba", "audio/webm");
    mapping.put("aac", "audio/x-aac");
    mapping.put("aif", "audio/x-aiff");
    mapping.put("aiff", "audio/x-aiff");
    mapping.put("aifc", "audio/x-aiff");
    mapping.put("caf", "audio/x-caf");
    mapping.put("flac", "audio/x-flac");
    mapping.put("mka", "audio/x-matroska");
    mapping.put("m3u", "audio/x-mpegurl");
    mapping.put("wax", "audio/x-ms-wax");
    mapping.put("wma", "audio/x-ms-wma");
    mapping.put("ram", "audio/x-pn-realaudio");
    mapping.put("ra", "audio/x-pn-realaudio");
    mapping.put("rmp", "audio/x-pn-realaudio-plugin");
    mapping.put("wav", "audio/x-wav");
    mapping.put("xm", "audio/xm");
    mapping.put("cdx", "chemical/x-cdx");
    mapping.put("cif", "chemical/x-cif");
    mapping.put("cmdf", "chemical/x-cmdf");
    mapping.put("cml", "chemical/x-cml");
    mapping.put("csml", "chemical/x-csml");
    mapping.put("xyz", "chemical/x-xyz");
    mapping.put("bmp", "image/bmp");
    mapping.put("cgm", "image/cgm");
    mapping.put("g3", "image/g3fax");
    mapping.put("gif", "image/gif");
    mapping.put("ief", "image/ief");
    mapping.put("jpeg", "image/jpeg");
    mapping.put("jpg", "image/jpeg");
    mapping.put("jpe", "image/jpeg");
    mapping.put("ktx", "image/ktx");
    mapping.put("png", "image/png");
    mapping.put("btif", "image/prs.btif");
    mapping.put("sgi", "image/sgi");
    mapping.put("svg", "image/svg+xml");
    mapping.put("svgz", "image/svg+xml");
    mapping.put("tiff", "image/tiff");
    mapping.put("tif", "image/tiff");
    mapping.put("psd", "image/vnd.adobe.photoshop");
    mapping.put("uvi", "image/vnd.dece.graphic");
    mapping.put("uvvi", "image/vnd.dece.graphic");
    mapping.put("uvg", "image/vnd.dece.graphic");
    mapping.put("uvvg", "image/vnd.dece.graphic");
    mapping.put("sub", "image/vnd.dvb.subtitle");
    mapping.put("djvu", "image/vnd.djvu");
    mapping.put("djv", "image/vnd.djvu");
    mapping.put("dwg", "image/vnd.dwg");
    mapping.put("dxf", "image/vnd.dxf");
    mapping.put("fbs", "image/vnd.fastbidsheet");
    mapping.put("fpx", "image/vnd.fpx");
    mapping.put("fst", "image/vnd.fst");
    mapping.put("mmr", "image/vnd.fujixerox.edmics-mmr");
    mapping.put("rlc", "image/vnd.fujixerox.edmics-rlc");
    mapping.put("mdi", "image/vnd.ms-modi");
    mapping.put("wdp", "image/vnd.ms-photo");
    mapping.put("npx", "image/vnd.net-fpx");
    mapping.put("wbmp", "image/vnd.wap.wbmp");
    mapping.put("xif", "image/vnd.xiff");
    mapping.put("webp", "image/webp");
    mapping.put("3ds", "image/x-3ds");
    mapping.put("ras", "image/x-cmu-raster");
    mapping.put("cmx", "image/x-cmx");
    mapping.put("fh", "image/x-freehand");
    mapping.put("fhc", "image/x-freehand");
    mapping.put("fh4", "image/x-freehand");
    mapping.put("fh5", "image/x-freehand");
    mapping.put("fh7", "image/x-freehand");
    mapping.put("ico", "image/x-icon");
    mapping.put("sid", "image/x-mrsid-image");
    mapping.put("pcx", "image/x-pcx");
    mapping.put("pic", "image/x-pict");
    mapping.put("pct", "image/x-pict");
    mapping.put("pnm", "image/x-portable-anymap");
    mapping.put("pbm", "image/x-portable-bitmap");
    mapping.put("pgm", "image/x-portable-graymap");
    mapping.put("ppm", "image/x-portable-pixmap");
    mapping.put("rgb", "image/x-rgb");
    mapping.put("tga", "image/x-tga");
    mapping.put("xbm", "image/x-xbitmap");
    mapping.put("xpm", "image/x-xpixmap");
    mapping.put("xwd", "image/x-xwindowdump");
    mapping.put("eml", "message/rfc822");
    mapping.put("mime", "message/rfc822");
    mapping.put("igs", "model/iges");
    mapping.put("iges", "model/iges");
    mapping.put("msh", "model/mesh");
    mapping.put("mesh", "model/mesh");
    mapping.put("silo", "model/mesh");
    mapping.put("dae", "model/vnd.collada+xml");
    mapping.put("dwf", "model/vnd.dwf");
    mapping.put("gdl", "model/vnd.gdl");
    mapping.put("gtw", "model/vnd.gtw");
    mapping.put("mts", "model/vnd.mts");
    mapping.put("vtu", "model/vnd.vtu");
    mapping.put("wrl", "model/vrml");
    mapping.put("vrml", "model/vrml");
    mapping.put("x3db", "model/x3d+binary");
    mapping.put("x3dbz", "model/x3d+binary");
    mapping.put("x3dv", "model/x3d+vrml");
    mapping.put("x3dvz", "model/x3d+vrml");
    mapping.put("x3d", "model/x3d+xml");
    mapping.put("x3dz", "model/x3d+xml");
    mapping.put("appcache", "text/cache-manifest");
    mapping.put("ics", "text/calendar");
    mapping.put("ifb", "text/calendar");
    mapping.put("css", "text/css");
    mapping.put("csv", "text/csv");
    mapping.put("html", "text/html");
    mapping.put("htm", "text/html");
    mapping.put("n3", "text/n3");
    mapping.put("txt", "text/plain");
    mapping.put("text", "text/plain");
    mapping.put("conf", "text/plain");
    mapping.put("def", "text/plain");
    mapping.put("list", "text/plain");
    mapping.put("log", "text/plain");
    mapping.put("in", "text/plain");
    mapping.put("dsc", "text/prs.lines.tag");
    mapping.put("rtx", "text/richtext");
    mapping.put("sgml", "text/sgml");
    mapping.put("sgm", "text/sgml");
    mapping.put("tsv", "text/tab-separated-values");
    mapping.put("t", "text/troff");
    mapping.put("tr", "text/troff");
    mapping.put("roff", "text/troff");
    mapping.put("man", "text/troff");
    mapping.put("me", "text/troff");
    mapping.put("ms", "text/troff");
    mapping.put("ttl", "text/turtle");
    mapping.put("uri", "text/uri-list");
    mapping.put("uris", "text/uri-list");
    mapping.put("urls", "text/uri-list");
    mapping.put("vcard", "text/vcard");
    mapping.put("curl", "text/vnd.curl");
    mapping.put("dcurl", "text/vnd.curl.dcurl");
    mapping.put("scurl", "text/vnd.curl.scurl");
    mapping.put("mcurl", "text/vnd.curl.mcurl");
    mapping.put("fly", "text/vnd.fly");
    mapping.put("flx", "text/vnd.fmi.flexstor");
    mapping.put("gv", "text/vnd.graphviz");
    mapping.put("3dml", "text/vnd.in3d.3dml");
    mapping.put("spot", "text/vnd.in3d.spot");
    mapping.put("jad", "text/vnd.sun.j2me.app-descriptor");
    mapping.put("wml", "text/vnd.wap.wml");
    mapping.put("wmls", "text/vnd.wap.wmlscript");
    mapping.put("s", "text/x-asm");
    mapping.put("asm", "text/x-asm");
    mapping.put("c", "text/x-c");
    mapping.put("cc", "text/x-c");
    mapping.put("cxx", "text/x-c");
    mapping.put("cpp", "text/x-c");
    mapping.put("h", "text/x-c");
    mapping.put("hh", "text/x-c");
    mapping.put("dic", "text/x-c");
    mapping.put("f", "text/x-fortran");
    mapping.put("for", "text/x-fortran");
    mapping.put("f77", "text/x-fortran");
    mapping.put("f90", "text/x-fortran");
    mapping.put("java", "text/x-java-source");
    mapping.put("opml", "text/x-opml");
    mapping.put("p", "text/x-pascal");
    mapping.put("pas", "text/x-pascal");
    mapping.put("nfo", "text/x-nfo");
    mapping.put("etx", "text/x-setext");
    mapping.put("sfv", "text/x-sfv");
    mapping.put("uu", "text/x-uuencode");
    mapping.put("vcs", "text/x-vcalendar");
    mapping.put("vcf", "text/x-vcard");
    mapping.put("3gp", "video/3gpp");
    mapping.put("3g2", "video/3gpp2");
    mapping.put("h261", "video/h261");
    mapping.put("h263", "video/h263");
    mapping.put("h264", "video/h264");
    mapping.put("jpgv", "video/jpeg");
    mapping.put("jpm", "video/jpm");
    mapping.put("jpgm", "video/jpm");
    mapping.put("mj2", "video/mj2");
    mapping.put("mjp2", "video/mj2");
    mapping.put("mp4", "video/mp4");
    mapping.put("mp4v", "video/mp4");
    mapping.put("mpg4", "video/mp4");
    mapping.put("mpeg", "video/mpeg");
    mapping.put("mpg", "video/mpeg");
    mapping.put("mpe", "video/mpeg");
    mapping.put("m1v", "video/mpeg");
    mapping.put("m2v", "video/mpeg");
    mapping.put("ogv", "video/ogg");
    mapping.put("qt", "video/quicktime");
    mapping.put("mov", "video/quicktime");
    mapping.put("uvh", "video/vnd.dece.hd");
    mapping.put("uvvh", "video/vnd.dece.hd");
    mapping.put("uvm", "video/vnd.dece.mobile");
    mapping.put("uvvm", "video/vnd.dece.mobile");
    mapping.put("uvp", "video/vnd.dece.pd");
    mapping.put("uvvp", "video/vnd.dece.pd");
    mapping.put("uvs", "video/vnd.dece.sd");
    mapping.put("uvvs", "video/vnd.dece.sd");
    mapping.put("uvv", "video/vnd.dece.video");
    mapping.put("uvvv", "video/vnd.dece.video");
    mapping.put("dvb", "video/vnd.dvb.file");
    mapping.put("fvt", "video/vnd.fvt");
    mapping.put("mxu", "video/vnd.mpegurl");
    mapping.put("m4u", "video/vnd.mpegurl");
    mapping.put("pyv", "video/vnd.ms-playready.media.pyv");
    mapping.put("uvu", "video/vnd.uvvu.mp4");
    mapping.put("uvvu", "video/vnd.uvvu.mp4");
    mapping.put("viv", "video/vnd.vivo");
    mapping.put("webm", "video/webm");
    mapping.put("f4v", "video/x-f4v");
    mapping.put("fli", "video/x-fli");
    mapping.put("flv", "video/x-flv");
    mapping.put("m4a", "audio/x-m4a");
    mapping.put("m4v", "video/x-m4v");
    mapping.put("mkv", "video/x-matroska");
    mapping.put("mk3d", "video/x-matroska");
    mapping.put("mks", "video/x-matroska");
    mapping.put("mng", "video/x-mng");
    mapping.put("asf", "video/x-ms-asf");
    mapping.put("asx", "video/x-ms-asf");
    mapping.put("vob", "video/x-ms-vob");
    mapping.put("wm", "video/x-ms-wm");
    mapping.put("wmv", "video/x-ms-wmv");
    mapping.put("wmx", "video/x-ms-wmx");
    mapping.put("wvx", "video/x-ms-wvx");
    mapping.put("avi", "video/x-msvideo");
    mapping.put("movie", "video/x-sgi-movie");
    mapping.put("smv", "video/x-smv");
    mapping.put("ice", "x-conference/x-cooltalk");
    MAPPING = mapping;
  }

  /**
   * @param ext the file name extension in lower case format
   * @return the matching mime type for a file extension (e.g. {@code .mkv}) or {@code null}
   */
  public static String getMimeTypeForExtension(String ext) {
    return MAPPING.get(ext);
  }

  /**
   * @param filename the file name, the filename extension is converted to the lower-case format before matching the
   *                 mime mapping
   * @return the matching mime type for a file name or {@code null}, the file extension is used for lookup
   */
  public static String getMimeTypeForFilename(String filename) {
    int from = filename.lastIndexOf('.') + 1;
    int len;
    if (from != 0 && (len = filename.length() - from) > 0) {
      char[] chars = new char[len];
      for (int i = 0;i < len;i++) {
        char ch = filename.charAt(from + i);
        if (ch >= 'A' && ch <= 'Z') {
          ch = (char)(ch - 'A' + 'a');
        }
        chars[i] = ch;
      }
      String ext = new String(chars);
      return getMimeTypeForExtension(ext);
    }
    return null;
  }
}
