/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MemoryAttribute;
import io.netty.handler.codec.http.multipart.MemoryFileUpload;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.impl.ClientMultipartFormDataPart;
import io.vertx.core.http.impl.ClientMultipartFormImpl;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.internal.concurrent.InboundMessageQueue;
import io.vertx.core.internal.http.HttpHeadersInternal;
import io.vertx.core.streams.Pipe;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class ClientMultipartFormUpload
implements ReadStream<Buffer> {
    private static final Object END_SENTINEL = new Object();
    private static final UnpooledByteBufAllocator ALLOC = new UnpooledByteBufAllocator(false);
    private DefaultFullHttpRequest request;
    private HttpPostRequestEncoder encoder;
    private Handler<Throwable> exceptionHandler;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private final InboundMessageQueue<Object> pending;
    private boolean writable;
    private boolean ended;
    private final ContextInternal context;

    public ClientMultipartFormUpload(ContextInternal context, ClientMultipartFormImpl parts, boolean multipart, HttpPostRequestEncoder.EncoderMode encoderMode) throws Exception {
        this.context = context;
        this.writable = true;
        this.pending = new InboundMessageQueue<Object>(context.executor(), context.executor()){

            @Override
            protected void handleResume() {
                ClientMultipartFormUpload.this.writable = true;
                ClientMultipartFormUpload.this.pump();
            }

            @Override
            protected void handlePause() {
                ClientMultipartFormUpload.this.writable = false;
            }

            @Override
            protected void handleMessage(Object msg) {
                ClientMultipartFormUpload.this.handleChunk(msg);
            }
        };
        this.request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/");
        parts.charset();
        final Charset charset = parts.charset() != null ? parts.charset() : HttpConstants.DEFAULT_CHARSET;
        this.encoder = new HttpPostRequestEncoder((HttpDataFactory)new DefaultHttpDataFactory(16384L, charset){

            public Attribute createAttribute(HttpRequest request, String name, String value) {
                try {
                    return new MemoryAttribute(name, value, charset);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            public FileUpload createFileUpload(HttpRequest request, String name, String filename, String contentType, String contentTransferEncoding, Charset _charset, long size) {
                if (_charset == null) {
                    _charset = charset;
                }
                return super.createFileUpload(request, name, filename, contentType, contentTransferEncoding, _charset, size);
            }
        }, (HttpRequest)this.request, multipart, charset, encoderMode);
        for (ClientMultipartFormDataPart formDataPart : parts) {
            if (formDataPart.isAttribute()) {
                this.encoder.addBodyAttribute(formDataPart.name(), formDataPart.value());
                continue;
            }
            String pathname = formDataPart.pathname();
            if (pathname != null) {
                this.encoder.addBodyFileUpload(formDataPart.name(), formDataPart.filename(), new File(formDataPart.pathname()), formDataPart.mediaType(), formDataPart.isText().booleanValue());
                continue;
            }
            String contentType = formDataPart.mediaType();
            if (formDataPart.mediaType() == null) {
                contentType = formDataPart.isText() != false ? "text/plain" : "application/octet-stream";
            }
            String transferEncoding = formDataPart.isText() != false ? null : "binary";
            MemoryFileUpload fileUpload = new MemoryFileUpload(formDataPart.name(), formDataPart.filename(), contentType, transferEncoding, null, (long)formDataPart.content().length());
            fileUpload.setContent(((BufferInternal)formDataPart.content()).getByteBuf());
            this.encoder.addBodyHttpData((InterfaceHttpData)fileUpload);
        }
        this.encoder.finalizeRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChunk(Object item) {
        Handler<Object> handler;
        ClientMultipartFormUpload clientMultipartFormUpload = this;
        synchronized (clientMultipartFormUpload) {
            if (item instanceof Buffer) {
                handler = this.dataHandler;
            } else if (item instanceof Throwable) {
                handler = this.exceptionHandler;
            } else if (item == END_SENTINEL) {
                handler = this.endHandler;
                item = null;
            } else {
                return;
            }
        }
        handler.handle((Buffer)item);
    }

    public void pump() {
        if (!this.context.inThread()) {
            throw new IllegalArgumentException();
        }
        while (!this.ended) {
            if (this.encoder.isChunked()) {
                try {
                    HttpContent chunk = this.encoder.readChunk((ByteBufAllocator)ALLOC);
                    ByteBuf content = chunk.content();
                    BufferInternal buff = BufferInternal.buffer(content);
                    this.pending.write(buff);
                    if (this.encoder.isEndOfInput()) {
                        this.ended = true;
                        this.request = null;
                        this.encoder = null;
                        this.pending.write(END_SENTINEL);
                        continue;
                    }
                    if (this.writable) continue;
                }
                catch (Exception e) {
                    this.ended = true;
                    this.request = null;
                    this.encoder = null;
                    this.pending.write(e);
                }
                break;
            }
            ByteBuf content = this.request.content();
            BufferInternal buffer = BufferInternal.buffer(content);
            this.request = null;
            this.encoder = null;
            this.pending.write(buffer);
            this.ended = true;
            this.pending.write(END_SENTINEL);
        }
    }

    public MultiMap headers() {
        return HttpHeadersInternal.headers(this.request.headers());
    }

    @Override
    public synchronized ClientMultipartFormUpload exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public synchronized ClientMultipartFormUpload handler(Handler<Buffer> handler) {
        this.dataHandler = handler;
        return this;
    }

    public synchronized ClientMultipartFormUpload pause() {
        this.pending.pause();
        return this;
    }

    @Override
    public ReadStream<Buffer> fetch(long amount) {
        this.pending.fetch(amount);
        return this;
    }

    public synchronized ClientMultipartFormUpload resume() {
        this.pending.fetch(Long.MAX_VALUE);
        return this;
    }

    public synchronized ClientMultipartFormUpload endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    @Override
    public Future<Void> pipeTo(WriteStream<Buffer> dst) {
        return this.pipe().to(dst);
    }

    @Override
    public Pipe<Buffer> pipe() {
        final Pipe pipe = ReadStream.super.pipe();
        return new Pipe<Buffer>(){

            @Override
            public Pipe<Buffer> endOnFailure(boolean end) {
                pipe.endOnFailure(end);
                return this;
            }

            @Override
            public Pipe<Buffer> endOnSuccess(boolean end) {
                pipe.endOnSuccess(end);
                return this;
            }

            @Override
            public Pipe<Buffer> endOnComplete(boolean end) {
                pipe.endOnComplete(end);
                return this;
            }

            @Override
            public Future<Void> to(WriteStream<Buffer> dst) {
                Future<Void> f = pipe.to(dst);
                ClientMultipartFormUpload.this.pump();
                return f;
            }

            @Override
            public void close() {
                pipe.close();
            }
        };
    }
}

