/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal;

import io.vertx.core.Closeable;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.internal.NestedCloseable;
import io.vertx.core.internal.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class CloseFuture
extends NestedCloseable
implements Closeable {
    private final Logger log;
    private final Promise<Void> promise = Promise.promise();
    private boolean closed;
    private Map<Closeable, CloseFuture> children;

    public CloseFuture() {
        this(null);
    }

    public CloseFuture(Logger log) {
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean add(Closeable closeable) {
        if (this.closed) {
            return false;
        }
        if (closeable instanceof NestedCloseable) {
            NestedCloseable base;
            NestedCloseable nestedCloseable = base = (NestedCloseable)((Object)closeable);
            synchronized (nestedCloseable) {
                if (base.owner != null) {
                    throw new IllegalStateException();
                }
                base.owner = this;
            }
        }
        if (this.children == null) {
            this.children = new HashMap<Closeable, CloseFuture>();
        }
        this.children.put(closeable, this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Closeable nested) {
        if (nested instanceof NestedCloseable) {
            NestedCloseable base;
            NestedCloseable nestedCloseable = base = (NestedCloseable)((Object)nested);
            synchronized (nestedCloseable) {
                if (base.owner == this) {
                    base.owner = null;
                }
            }
        }
        CloseFuture closeFuture = this;
        synchronized (closeFuture) {
            if (this.children != null) {
                return this.children.remove(nested) != null;
            }
        }
        return false;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public Future<Void> future() {
        return this.promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> close() {
        CloseFuture closeFuture = this;
        synchronized (closeFuture) {
            if (this.closed) {
                return this.promise.future();
            }
            this.closed = true;
        }
        this.cascadeClose();
        return this.promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeClose() {
        List<Closeable> toClose = Collections.emptyList();
        CloseFuture closeFuture = this;
        synchronized (closeFuture) {
            if (this.children != null) {
                toClose = new ArrayList<Closeable>(this.children.keySet());
            }
            this.children = null;
        }
        int num = toClose.size();
        if (num > 0) {
            AtomicInteger count = new AtomicInteger();
            for (Closeable hook : toClose) {
                if (hook instanceof NestedCloseable) {
                    NestedCloseable base;
                    NestedCloseable nestedCloseable = base = (NestedCloseable)((Object)hook);
                    synchronized (nestedCloseable) {
                        base.owner = null;
                    }
                }
                Promise<Void> p = Promise.promise();
                p.future().onComplete(ar -> {
                    if (count.incrementAndGet() == num) {
                        this.unregisterFromOwner();
                        this.promise.complete();
                    }
                });
                try {
                    hook.close(p);
                }
                catch (Throwable t) {
                    if (this.log != null) {
                        this.log.warn((Object)"Failed to run close hook", t);
                    }
                    p.tryFail(t);
                }
            }
        } else {
            this.unregisterFromOwner();
            this.promise.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterFromOwner() {
        CloseFuture owner;
        CloseFuture closeFuture = this;
        synchronized (closeFuture) {
            owner = this.owner;
        }
        if (owner != null) {
            owner.remove(this);
        }
    }

    @Override
    public void close(Completable<Void> promise) {
        this.close().onComplete(promise);
    }
}

