/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.VertxException;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Lock;
import java.util.function.Supplier;

@VertxGen
public interface SharedData {
    public <K, V> Future<AsyncMap<K, V>> getClusterWideMap(String var1);

    public <K, V> Future<AsyncMap<K, V>> getAsyncMap(String var1);

    public <K, V> Future<AsyncMap<K, V>> getLocalAsyncMap(String var1);

    public Future<Lock> getLock(String var1);

    public Future<Lock> getLockWithTimeout(String var1, long var2);

    default public <T> Future<T> withLock(String name, Supplier<Future<T>> block) {
        return this.withLock(name, 10000L, block);
    }

    default public <T> Future<T> withLock(String name, long timeout, Supplier<Future<T>> block) {
        return this.getLockWithTimeout(name, timeout).compose(lock -> {
            Future res;
            try {
                res = (Future)block.get();
            }
            catch (Exception e) {
                lock.release();
                throw new VertxException(e);
            }
            return res.andThen(ar -> lock.release());
        });
    }

    public Future<Lock> getLocalLock(String var1);

    public Future<Lock> getLocalLockWithTimeout(String var1, long var2);

    default public <T> Future<T> withLocalLock(String name, Supplier<Future<T>> block) {
        return this.withLocalLock(name, 10000L, block);
    }

    default public <T> Future<T> withLocalLock(String name, long timeout, Supplier<Future<T>> block) {
        return this.getLocalLockWithTimeout(name, timeout).compose(lock -> {
            Future res;
            try {
                res = (Future)block.get();
            }
            catch (Exception e) {
                lock.release();
                throw new VertxException(e);
            }
            return res.andThen(ar -> lock.release());
        });
    }

    public Future<Counter> getCounter(String var1);

    public Future<Counter> getLocalCounter(String var1);

    public <K, V> LocalMap<K, V> getLocalMap(String var1);
}

