/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus;

import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.json.JsonObject;
import java.util.Map;

public class EventBusOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, EventBusOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "clientAuth": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setClientAuth(ClientAuth.valueOf((String)member.getValue()));
                    break;
                }
                case "acceptBacklog": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setAcceptBacklog(((Number)member.getValue()).intValue());
                    break;
                }
                case "host": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHost((String)member.getValue());
                    break;
                }
                case "port": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPort(((Number)member.getValue()).intValue());
                    break;
                }
                case "reconnectAttempts": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setReconnectAttempts(((Number)member.getValue()).intValue());
                    break;
                }
                case "reconnectInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setReconnectInterval(((Number)member.getValue()).longValue());
                    break;
                }
                case "trustAll": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTrustAll((Boolean)member.getValue());
                    break;
                }
                case "connectTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setConnectTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "clusterPingInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setClusterPingInterval(((Number)member.getValue()).longValue());
                    break;
                }
                case "clusterPingReplyInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setClusterPingReplyInterval(((Number)member.getValue()).longValue());
                    break;
                }
                case "clusterPublicHost": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setClusterPublicHost((String)member.getValue());
                    break;
                }
                case "clusterPublicPort": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setClusterPublicPort(((Number)member.getValue()).intValue());
                    break;
                }
                case "clusterNodeMetadata": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setClusterNodeMetadata(((JsonObject)member.getValue()).copy());
                }
            }
        }
    }

    static void toJson(EventBusOptions obj, JsonObject json) {
        EventBusOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(EventBusOptions obj, Map<String, Object> json) {
        if (obj.getClientAuth() != null) {
            json.put("clientAuth", obj.getClientAuth().name());
        }
        json.put("acceptBacklog", obj.getAcceptBacklog());
        if (obj.getHost() != null) {
            json.put("host", obj.getHost());
        }
        json.put("port", obj.getPort());
        json.put("reconnectAttempts", obj.getReconnectAttempts());
        json.put("reconnectInterval", obj.getReconnectInterval());
        json.put("trustAll", obj.isTrustAll());
        json.put("connectTimeout", obj.getConnectTimeout());
        json.put("clusterPingInterval", obj.getClusterPingInterval());
        json.put("clusterPingReplyInterval", obj.getClusterPingReplyInterval());
        if (obj.getClusterPublicHost() != null) {
            json.put("clusterPublicHost", obj.getClusterPublicHost());
        }
        json.put("clusterPublicPort", obj.getClusterPublicPort());
        if (obj.getClusterNodeMetadata() != null) {
            json.put("clusterNodeMetadata", obj.getClusterNodeMetadata());
        }
    }
}

