/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl.clustered.selector;

import io.vertx.core.eventbus.impl.clustered.selector.Index;
import io.vertx.core.eventbus.impl.clustered.selector.RoundRobinSelector;
import java.util.Collections;
import java.util.List;

public class SimpleRoundRobinSelector
implements RoundRobinSelector {
    private final List<String> nodeIds;
    private final Index index;

    public SimpleRoundRobinSelector(List<String> nodeIds) {
        if (nodeIds.size() > 1) {
            this.nodeIds = Collections.unmodifiableList(nodeIds);
            this.index = new Index(nodeIds.size());
        } else {
            this.nodeIds = Collections.singletonList(nodeIds.get(0));
            this.index = null;
        }
    }

    @Override
    public String selectForSend() {
        if (this.index == null) {
            return this.nodeIds.get(0);
        }
        return this.nodeIds.get(this.index.nextVal());
    }

    @Override
    public Iterable<String> selectForPublish() {
        return this.nodeIds;
    }
}

