/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFileLock;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.util.function.Supplier;

@VertxGen
public interface AsyncFile
extends ReadStream<Buffer>,
WriteStream<Buffer> {
    public AsyncFile handler(Handler<Buffer> var1);

    public AsyncFile pause();

    public AsyncFile resume();

    public AsyncFile endHandler(Handler<Void> var1);

    public AsyncFile setWriteQueueMaxSize(int var1);

    public AsyncFile drainHandler(Handler<Void> var1);

    @Override
    public AsyncFile exceptionHandler(Handler<Throwable> var1);

    public AsyncFile fetch(long var1);

    public Future<Void> close();

    public Future<Void> write(Buffer var1, long var2);

    public Future<Buffer> read(Buffer var1, int var2, long var3, int var5);

    public Future<Void> flush();

    @Fluent
    public AsyncFile setReadPos(long var1);

    @Fluent
    public AsyncFile setReadLength(long var1);

    public long getReadLength();

    @Fluent
    public AsyncFile setWritePos(long var1);

    public long getWritePos();

    @Fluent
    public AsyncFile setReadBufferSize(int var1);

    public long sizeBlocking();

    public Future<Long> size();

    default public @Nullable AsyncFileLock tryLock() {
        return this.tryLock(0L, Long.MAX_VALUE, false);
    }

    public @Nullable AsyncFileLock tryLock(long var1, long var3, boolean var5);

    default public Future<AsyncFileLock> lock() {
        return this.lock(0L, Long.MAX_VALUE, false);
    }

    public Future<AsyncFileLock> lock(long var1, long var3, boolean var5);

    default public <T> Future<T> withLock(Supplier<Future<T>> block) {
        return this.withLock(0L, Long.MAX_VALUE, false, block);
    }

    default public <T> Future<T> withLock(long position, long size, boolean shared, Supplier<Future<T>> block) {
        return this.lock(position, size, shared).compose(lock -> {
            Future res;
            try {
                res = (Future)block.get();
            }
            catch (Exception e) {
                lock.release();
                throw new VertxException(e);
            }
            return res.eventually(() -> lock.release());
        });
    }
}

