/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.future;

import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.future.FutureBase;
import io.vertx.core.impl.future.FutureImpl;

public class CompositeFutureImpl
extends FutureImpl<CompositeFuture>
implements CompositeFuture,
Completable<Object> {
    private static final int OP_ALL = 0;
    private static final int OP_ANY = 1;
    private static final int OP_JOIN = 2;
    private final Future<?>[] results;
    private final int op;
    private boolean initializing;
    private Object completed;
    private int completions;

    public static CompositeFuture all(Future<?> ... results) {
        return CompositeFutureImpl.create(0, results);
    }

    public static CompositeFuture any(Future<?> ... results) {
        return CompositeFutureImpl.create(1, results);
    }

    public static CompositeFuture join(Future<?> ... results) {
        return CompositeFutureImpl.create(2, results);
    }

    private static CompositeFuture create(int op, Future<?> ... results) {
        CompositeFutureImpl composite;
        int len = results.length;
        if (len > 0) {
            composite = new CompositeFutureImpl(op, true, results);
            composite.init();
        } else {
            composite = new CompositeFutureImpl(op, false, results);
            composite.doComplete(composite);
        }
        return composite;
    }

    private CompositeFutureImpl(int op, boolean initializing, Future<?> ... results) {
        this.op = op;
        this.initializing = initializing;
        this.results = results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object o;
        for (Future<?> result : this.results) {
            if (result instanceof FutureBase) {
                FutureBase internal = (FutureBase)result;
                internal.addListener(this);
                continue;
            }
            result.onComplete(this);
        }
        CompositeFutureImpl compositeFutureImpl = this;
        synchronized (compositeFutureImpl) {
            this.initializing = false;
            o = this.completed;
            if (o == null) {
                return;
            }
        }
        this.doComplete(o);
    }

    @Override
    public void complete(Object result, Throwable failure) {
        if (failure == null) {
            this.onSuccess(result);
        } else {
            this.onFailure(failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSuccess(Object value) {
        Object completion;
        int len = this.results.length;
        CompositeFutureImpl compositeFutureImpl = this;
        synchronized (compositeFutureImpl) {
            int val = ++this.completions;
            if (this.completed != null) {
                return;
            }
            switch (this.op) {
                case 0: {
                    if (val < len) {
                        return;
                    }
                    completion = this;
                    break;
                }
                case 1: {
                    completion = this;
                    break;
                }
                case 2: {
                    if (val < len) {
                        return;
                    }
                    completion = this.anyFailureOrThis();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.completed = completion;
            if (this.initializing) {
                return;
            }
        }
        this.doComplete(completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFailure(Throwable failure) {
        Object completion;
        int len = this.results.length;
        CompositeFutureImpl compositeFutureImpl = this;
        synchronized (compositeFutureImpl) {
            int val = ++this.completions;
            if (this.completed != null) {
                return;
            }
            switch (this.op) {
                case 0: {
                    completion = failure;
                    break;
                }
                case 1: {
                    if (val < len) {
                        return;
                    }
                    completion = failure;
                    break;
                }
                case 2: {
                    if (val < len) {
                        return;
                    }
                    completion = this.anyFailureOrThis();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.completed = completion;
            if (this.initializing) {
                return;
            }
        }
        this.doComplete(completion);
    }

    private Object anyFailureOrThis() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Future<?> res = this.results[i];
            if (res.succeeded()) continue;
            return res.cause();
        }
        return this;
    }

    @Override
    public Throwable cause(int index) {
        return this.future(index).cause();
    }

    @Override
    public boolean succeeded(int index) {
        return this.future(index).succeeded();
    }

    @Override
    public boolean failed(int index) {
        return this.future(index).failed();
    }

    @Override
    public boolean isComplete(int index) {
        return this.future(index).isComplete();
    }

    @Override
    public <T> T resultAt(int index) {
        return this.future(index).result();
    }

    private <T> Future<T> future(int index) {
        if (index < 0 || index >= this.results.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.results[index];
    }

    @Override
    public int size() {
        return this.results.length;
    }

    private void doComplete(Object result) {
        for (Future<?> r : this.results) {
            if (!(r instanceof FutureBase)) continue;
            FutureBase internal = (FutureBase)r;
            internal.removeListener(this);
        }
        if (result == this) {
            this.tryComplete(this);
        } else if (result instanceof Throwable) {
            this.tryFail((Throwable)result);
        }
    }

    @Override
    public CompositeFuture onComplete(Handler<AsyncResult<CompositeFuture>> handler) {
        return (CompositeFuture)super.onComplete(handler);
    }

    @Override
    public CompositeFuture onSuccess(Handler<? super CompositeFuture> handler) {
        return (CompositeFuture)super.onSuccess(handler);
    }

    @Override
    public CompositeFuture onFailure(Handler<? super Throwable> handler) {
        return (CompositeFuture)super.onFailure(handler);
    }

    @Override
    protected void formatValue(Object value, StringBuilder sb) {
        sb.append('(');
        for (int i = 0; i < this.results.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.results[i]);
        }
        sb.append(')');
    }
}

